/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.manager.importer;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.interfaces.EconomyImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.EconomyImportResults;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.BetterEconomyImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.CraftConomy3Importer;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.EssentialsXImporter;
import com.github.encryptsl.lite.eco.common.manager.importer.economies.ScruffyBoyImporter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a4\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n \u000b*\u0019\u0012\u0010\b\u0001\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/encryptsl/lite/eco/common/manager/importer/ImportEconomy;", "", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "offlinePlayers", "", "Lorg/bukkit/OfflinePlayer;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "kotlin.jvm.PlatformType", "[Lorg/bukkit/OfflinePlayer;", "importers", "", "", "Lcom/github/encryptsl/lite/eco/api/interfaces/EconomyImporter;", "registerImporter", "", "importer", "import", "Lcom/github/encryptsl/lite/eco/common/manager/importer/EconomyImportResults;", "pluginName", "currency", "getAvailableImporters", "", "LiteEco"})
public final class ImportEconomy {
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    private final OfflinePlayer[] offlinePlayers;
    @NotNull
    private final Map<String, EconomyImporter> importers;

    public ImportEconomy(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        this.liteEco = liteEco;
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayerArray, (String)"getOfflinePlayers(...)");
        this.offlinePlayers = offlinePlayerArray;
        this.importers = new LinkedHashMap();
        this.registerImporter(new EssentialsXImporter());
        this.registerImporter(new BetterEconomyImporter());
        this.registerImporter(new ScruffyBoyImporter());
        this.registerImporter(new CraftConomy3Importer());
    }

    private final void registerImporter(EconomyImporter importer) {
        this.importers.put(importer.getName(), importer);
    }

    @NotNull
    public final EconomyImportResults import(@NotNull String pluginName, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        EconomyImporter economyImporter = this.importers.get(pluginName);
        if (economyImporter == null) {
            throw new IllegalArgumentException("Importer " + pluginName + " not found");
        }
        EconomyImporter importer = economyImporter;
        return importer.import(currency, this.liteEco, this.offlinePlayers);
    }

    @NotNull
    public final Set<String> getAvailableImporters() {
        return this.importers.keySet();
    }
}

