/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.hook.vault;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.common.hook.HookListener;
import com.github.encryptsl.lite.eco.common.hook.vault.AdaptiveEconomyVaultAPI;
import com.github.encryptsl.lite.eco.common.hook.vault.unlocked.AdaptiveEconomyVaultUnlockedAPI;
import com.github.encryptsl.lite.eco.utils.ClassUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/vault/VaultHook;", "Lcom/github/encryptsl/lite/eco/common/hook/HookListener;", "liteEco", "Lcom/github/encryptsl/lite/eco/LiteEco;", "<init>", "(Lcom/github/encryptsl/lite/eco/LiteEco;)V", "getLiteEco", "()Lcom/github/encryptsl/lite/eco/LiteEco;", "canRegister", "", "register", "", "unregister", "Companion", "LiteEco"})
public final class VaultHook
extends HookListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiteEco liteEco;
    @NotNull
    public static final String PLUGIN_NAME = "Vault";

    public VaultHook(@NotNull LiteEco liteEco) {
        Intrinsics.checkNotNullParameter((Object)((Object)liteEco), (String)"liteEco");
        super(PLUGIN_NAME, "You can now use Vault API !");
        this.liteEco = liteEco;
    }

    @NotNull
    public final LiteEco getLiteEco() {
        return this.liteEco;
    }

    @Override
    public boolean canRegister() {
        return !this.getRegistered() && this.liteEco.getPluginManager().getPlugin(PLUGIN_NAME) != null;
    }

    @Override
    public void register() {
        if (Companion.isVaultUnlocked()) {
            this.liteEco.getServer().getServicesManager().register(net.milkbowl.vault2.economy.Economy.class, (Object)new AdaptiveEconomyVaultUnlockedAPI(this.liteEco), (Plugin)this.liteEco, ServicePriority.Highest);
            this.liteEco.getComponentLogger().info("You can now use modern VaultUnlocked API.");
        }
        this.liteEco.getServer().getServicesManager().register(Economy.class, (Object)new AdaptiveEconomyVaultAPI(this.liteEco), (Plugin)this.liteEco, ServicePriority.Highest);
        this.setRegistered(true);
    }

    @Override
    public void unregister() {
        this.liteEco.getServer().getServicesManager().unregister(AdaptiveEconomyVaultAPI.class);
        if (Companion.isVaultUnlocked()) {
            this.liteEco.getServer().getServicesManager().unregister(AdaptiveEconomyVaultUnlockedAPI.class);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/encryptsl/lite/eco/common/hook/vault/VaultHook$Companion;", "", "<init>", "()V", "PLUGIN_NAME", "", "isVaultUnlocked", "", "LiteEco"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isVaultUnlocked() {
            return ClassUtil.INSTANCE.isValidClasspath("net.milkbowl.vault2.economy.Economy");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

