/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.common.database.models;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.economy.Currency;
import com.github.encryptsl.lite.eco.api.enums.TypeLogger;
import com.github.encryptsl.lite.eco.api.interfaces.TransactionLogger;
import com.github.encryptsl.lite.eco.common.config.Locales;
import com.github.encryptsl.lite.eco.common.database.entity.EconomyLog;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseMonologModel;
import com.github.encryptsl.lite.eco.common.database.tables.MonologTable;
import com.github.encryptsl.lite.eco.common.extensions.DatabaseLoggerTransactionKt;
import com.github.encryptsl.lite.eco.common.extensions.KotlinHelperKt;
import com.github.encryptsl.lite.eco.common.extensions.StringExtentionsKt;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import kotlinx.coroutines.CoroutineScope;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.SortOrder;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\tH\u0016J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0018JF\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ>\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel;", "Lcom/github/encryptsl/lite/eco/api/interfaces/TransactionLogger;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "logging", "", "typeLogger", "Lcom/github/encryptsl/lite/eco/api/enums/TypeLogger;", "sender", "", "target", "currency", "previousBalance", "Ljava/math/BigDecimal;", "newBalance", "(Lcom/github/encryptsl/lite/eco/api/enums/TypeLogger;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/math/BigDecimal;Ljava/math/BigDecimal;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearLogs", "getLog", "", "Lcom/github/encryptsl/lite/eco/common/database/entity/EconomyLog;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "message", "Lnet/kyori/adventure/text/Component;", "translation", "instant", "Lkotlin/time/Instant;", "log", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nDatabaseMonologModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseMonologModel.kt\ncom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1617#2,9:99\n1869#2:108\n1870#2:110\n1626#2:111\n1#3:109\n*S KotlinDebug\n*F\n+ 1 DatabaseMonologModel.kt\ncom/github/encryptsl/lite/eco/common/database/models/DatabaseMonologModel\n*L\n44#1:99,9\n44#1:108\n44#1:110\n44#1:111\n44#1:109\n*E\n"})
public final class DatabaseMonologModel
implements TransactionLogger {
    @NotNull
    private final Plugin plugin;

    public DatabaseMonologModel(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @Nullable
    public Object logging(@NotNull TypeLogger typeLogger, @NotNull String sender, @NotNull String target, @NotNull String currency, @NotNull BigDecimal previousBalance, @NotNull BigDecimal newBalance, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.log(typeLogger, sender, target, currency, previousBalance, newBalance, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void clearLogs() {
        DatabaseLoggerTransactionKt.loggedTransaction$default(null, DatabaseMonologModel::clearLogs$lambda$0, 1, null);
    }

    @Override
    @Nullable
    public Object getLog(@NotNull Continuation<? super List<EconomyLog>> $completion) {
        return DatabaseLoggerTransactionKt.loggedTransaction$default(null, DatabaseMonologModel::getLog$lambda$2, 1, null);
    }

    @NotNull
    public final Component message(@NotNull String translation, @NotNull TypeLogger typeLogger, @NotNull String sender, @NotNull String target, @NotNull String currency, @NotNull BigDecimal previousBalance, @NotNull BigDecimal newBalance, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        Intrinsics.checkNotNullParameter((Object)((Object)typeLogger), (String)"typeLogger");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)previousBalance, (String)"previousBalance");
        Intrinsics.checkNotNullParameter((Object)newBalance, (String)"newBalance");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        Locales locales = LiteEco.Companion.getInstance().getLocale();
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed((String)"action", (String)typeLogger.name()), Placeholder.parsed((String)"sender", (String)sender), Placeholder.parsed((String)"target", (String)target), Placeholder.parsed((String)"currency", (String)currency), Placeholder.parsed((String)"previous_balance", (String)Currency.fullFormatting$default(LiteEco.Companion.getInstance().getCurrencyImpl(), previousBalance, null, 2, null)), Placeholder.parsed((String)"new_balance", (String)Currency.fullFormatting$default(LiteEco.Companion.getInstance().getCurrencyImpl(), newBalance, null, 2, null)), Placeholder.parsed((String)"timestamp", (String)StringExtentionsKt.convertInstant(instant))};
        TagResolver tagResolver = TagResolver.resolver((TagResolver[])tagResolverArray);
        Intrinsics.checkNotNullExpressionValue((Object)tagResolver, (String)"resolver(...)");
        return locales.translation(translation, tagResolver);
    }

    private final Object log(TypeLogger typeLogger, String sender, String target, String currency, BigDecimal previousBalance, BigDecimal newBalance, Continuation<? super Unit> $completion) {
        if (!this.plugin.getConfig().getBoolean("economy.monolog_activity", true)) {
            return Unit.INSTANCE;
        }
        Object object = KotlinHelperKt.io((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, typeLogger, sender, target, currency, previousBalance, newBalance, null){
            int label;
            final /* synthetic */ DatabaseMonologModel this$0;
            final /* synthetic */ TypeLogger $typeLogger;
            final /* synthetic */ String $sender;
            final /* synthetic */ String $target;
            final /* synthetic */ String $currency;
            final /* synthetic */ BigDecimal $previousBalance;
            final /* synthetic */ BigDecimal $newBalance;
            {
                this.this$0 = $receiver;
                this.$typeLogger = $typeLogger;
                this.$sender = $sender;
                this.$target = $target;
                this.$currency = $currency;
                this.$previousBalance = $previousBalance;
                this.$newBalance = $newBalance;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return DatabaseLoggerTransactionKt.loggedTransaction$default(null, arg_0 -> log.2.invokeSuspend$lambda$1(this.this$0, this.$typeLogger, this.$sender, this.$target, this.$currency, this.$previousBalance, this.$newBalance, arg_0), 1, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$1$lambda$0(TypeLogger $typeLogger, String $sender, String $target, String $currency, BigDecimal $previousBalance, BigDecimal $newBalance, MonologTable $this$insert, InsertStatement it) {
                it.set($this$insert.getAction(), (Object)$typeLogger.name());
                it.set(MonologTable.INSTANCE.getSender(), (Object)$sender);
                it.set(MonologTable.INSTANCE.getTarget(), (Object)$target);
                it.set(MonologTable.INSTANCE.getCurrency(), (Object)$currency);
                it.set(MonologTable.INSTANCE.getPreviousBalance(), (Object)$previousBalance);
                it.set(MonologTable.INSTANCE.getNewBalance(), (Object)$newBalance);
                return Unit.INSTANCE;
            }

            private static final Object invokeSuspend$lambda$1(DatabaseMonologModel this$0, TypeLogger $typeLogger, String $sender, String $target, String $currency, BigDecimal $previousBalance, BigDecimal $newBalance, Transaction $this$loggedTransaction) {
                InsertStatement insertStatement;
                try {
                    insertStatement = QueriesKt.insert((Table)((Table)MonologTable.INSTANCE), (arg_0, arg_1) -> log.2.invokeSuspend$lambda$1$lambda$0($typeLogger, $sender, $target, $currency, $previousBalance, $newBalance, arg_0, arg_1));
                }
                catch (Exception e) {
                    ComponentLogger componentLogger = this$0.getPlugin().getComponentLogger();
                    String string = e.getMessage();
                    if (string == null) {
                        string = e.getLocalizedMessage();
                    }
                    componentLogger.warn(string);
                    insertStatement = Unit.INSTANCE;
                }
                return insertStatement;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final int clearLogs$lambda$0(Transaction $this$loggedTransaction) {
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        return QueriesKt.deleteAll((Table)((Table)MonologTable.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private static final List getLog$lambda$2(Transaction $this$loggedTransaction) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loggedTransaction, (String)"$this$loggedTransaction");
        Iterable $this$mapNotNull$iv = (Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)MonologTable.INSTANCE)).orderBy((Expression)MonologTable.INSTANCE.getTimestamp(), SortOrder.DESC);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ResultRow it = (ResultRow)element$iv$iv;
            boolean bl2 = false;
            EconomyLog it$iv$iv = new EconomyLog((String)it.get((Expression)MonologTable.INSTANCE.getAction()), (String)it.get((Expression)MonologTable.INSTANCE.getSender()), (String)it.get((Expression)MonologTable.INSTANCE.getTarget()), (String)it.get((Expression)MonologTable.INSTANCE.getCurrency()), (BigDecimal)it.get((Expression)MonologTable.INSTANCE.getPreviousBalance()), (BigDecimal)it.get((Expression)MonologTable.INSTANCE.getNewBalance()), (Instant)it.get((Expression)MonologTable.INSTANCE.getTimestamp()));
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Object access$log(DatabaseMonologModel $this, TypeLogger typeLogger, String sender, String target, String currency, BigDecimal previousBalance, BigDecimal newBalance, Continuation $completion) {
        return $this.log(typeLogger, sender, target, currency, previousBalance, newBalance, (Continuation<? super Unit>)$completion);
    }
}

