/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.lite.eco.api;

import com.github.encryptsl.lite.eco.LiteEco;
import com.github.encryptsl.lite.eco.api.interfaces.AccountAPI;
import com.github.encryptsl.lite.eco.common.database.models.DatabaseEcoModel;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/encryptsl/lite/eco/api/PlayerAccount;", "Lcom/github/encryptsl/lite/eco/api/interfaces/AccountAPI;", "<init>", "()V", "databaseEcoModel", "Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "getDatabaseEcoModel", "()Lcom/github/encryptsl/lite/eco/common/database/models/DatabaseEcoModel;", "databaseEcoModel$delegate", "Lkotlin/Lazy;", "cache", "", "Ljava/util/UUID;", "", "Ljava/math/BigDecimal;", "cacheAccount", "", "uuid", "currency", "value", "getBalance", "syncAccount", "syncAccounts", "clearFromCache", "isAccountCached", "", "isPlayerOnline", "LiteEco"})
@SourceDebugExtension(value={"SMAP\nPlayerAccount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerAccount.kt\ncom/github/encryptsl/lite/eco/api/PlayerAccount\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n216#2,2:74\n216#2,2:77\n1869#3:76\n1870#3:79\n1#4:80\n*S KotlinDebug\n*F\n+ 1 PlayerAccount.kt\ncom/github/encryptsl/lite/eco/api/PlayerAccount\n*L\n30#1:74,2\n46#1:77,2\n46#1:76\n46#1:79\n*E\n"})
public final class PlayerAccount
implements AccountAPI {
    @NotNull
    public static final PlayerAccount INSTANCE = new PlayerAccount();
    @NotNull
    private static final Lazy databaseEcoModel$delegate = LazyKt.lazy(PlayerAccount::databaseEcoModel_delegate$lambda$0);
    @NotNull
    private static final Map<UUID, Map<String, BigDecimal>> cache = new LinkedHashMap();

    private PlayerAccount() {
    }

    private final DatabaseEcoModel getDatabaseEcoModel() {
        Lazy lazy = databaseEcoModel$delegate;
        return (DatabaseEcoModel)lazy.getValue();
    }

    @Override
    public void cacheAccount(@NotNull UUID uuid, @NotNull String currency, @NotNull BigDecimal value) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (this.isAccountCached(uuid, currency)) break block0;
                Map map2 = cache.computeIfAbsent(uuid, arg_0 -> PlayerAccount.cacheAccount$lambda$2(PlayerAccount::cacheAccount$lambda$1, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
                map2.put(currency, value);
                break block1;
            }
            Map<String, BigDecimal> map3 = cache.get(uuid);
            if (map3 == null) break block1;
            map3.computeIfPresent(currency, (arg_0, arg_1) -> PlayerAccount.cacheAccount$lambda$4((arg_0, arg_1) -> PlayerAccount.cacheAccount$lambda$3(value, arg_0, arg_1), arg_0, arg_1));
        }
    }

    @Override
    @NotNull
    public BigDecimal getBalance(@NotNull UUID uuid, @NotNull String currency) {
        Map<String, BigDecimal> map2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
                map2 = cache.get(uuid);
                if (map2 == null) break block2;
                BigDecimal bigDecimal = BigDecimal.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
                if ((map2 = map2.getOrDefault(currency, bigDecimal)) != null) break block3;
            }
            BigDecimal bigDecimal = BigDecimal.ZERO;
            map2 = bigDecimal;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        }
        return map2;
    }

    @Override
    public void syncAccount(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Map<String, BigDecimal> map2 = cache.get(uuid);
        if (map2 == null) {
            return;
        }
        Map<String, BigDecimal> userBalances = map2;
        try {
            Map<String, BigDecimal> $this$forEach$iv = userBalances;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, BigDecimal>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, BigDecimal> element$iv;
                Map.Entry<String, BigDecimal> entry = element$iv = iterator2.next();
                boolean bl = false;
                String currency = entry.getKey();
                BigDecimal amount = entry.getValue();
                BigDecimal finalAmount = LiteEco.Companion.getInstance().getCurrencyImpl().getCheckBalanceLimit(amount, currency) ? LiteEco.Companion.getInstance().getCurrencyImpl().getCurrencyLimit(currency) : amount;
                INSTANCE.getDatabaseEcoModel().set(uuid, currency, finalAmount);
            }
            cache.remove(uuid);
        }
        catch (Exception e) {
            LiteEco.Companion.getInstance().getLogger().severe("Error while sync cache with database for " + uuid + ": " + e.getLocalizedMessage());
        }
    }

    @Override
    public void syncAccounts() {
        try {
            Iterable $this$forEach$iv = cache.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry user = (Map.Entry)element$iv;
                boolean bl = false;
                Map $this$forEach$iv2 = (Map)user.getValue();
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry it = element$iv2 = iterator2.next();
                    boolean bl2 = false;
                    BigDecimal finalAmount = LiteEco.Companion.getInstance().getCurrencyImpl().getCheckBalanceLimit((BigDecimal)it.getValue(), (String)it.getKey()) ? LiteEco.Companion.getInstance().getCurrencyImpl().getCurrencyLimit((String)it.getKey()) : (BigDecimal)it.getValue();
                    INSTANCE.getDatabaseEcoModel().set((UUID)user.getKey(), (String)it.getKey(), finalAmount);
                }
            }
            cache.clear();
        }
        catch (Exception e) {
            Logger logger = LiteEco.Companion.getInstance().getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            logger.severe(string);
        }
    }

    @Override
    public void clearFromCache(@NotNull UUID uuid) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Iterable iterable = cache.keySet();
            for (Object t : iterable) {
                UUID key = (UUID)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)key, (Object)uuid)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        UUID uUID = v0;
        if (uUID == null) {
            return;
        }
        UUID player = uUID;
        cache.remove(player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAccountCached(@NotNull UUID uuid, @Nullable String currency) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (!cache.containsKey(uuid)) return false;
        Map<String, BigDecimal> map2 = cache.get(uuid);
        if (map2 == null) return false;
        if (!map2.containsKey(currency)) return false;
        return true;
    }

    @Override
    public boolean isPlayerOnline(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return Bukkit.getPlayer((UUID)uuid) != null;
    }

    private static final DatabaseEcoModel databaseEcoModel_delegate$lambda$0() {
        return new DatabaseEcoModel();
    }

    private static final Map cacheAccount$lambda$1(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Map cacheAccount$lambda$2(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final BigDecimal cacheAccount$lambda$3(BigDecimal $value, String string, BigDecimal bigDecimal) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)bigDecimal, (String)"<unused var>");
        return $value;
    }

    private static final BigDecimal cacheAccount$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (BigDecimal)$tmp0.invoke(p0, p1);
    }
}

