/*
 * Decompiled with CFR 0.152.
 */
package com.github.encryptsl.ktor.client.engine.java;

import com.github.encryptsl.ktor.client.call.UnsupportedContentTypeException;
import com.github.encryptsl.ktor.client.engine.UtilsKt;
import com.github.encryptsl.ktor.client.engine.java.JavaHttpEngineKt;
import com.github.encryptsl.ktor.client.engine.java.JavaHttpRequestBodyPublisher;
import com.github.encryptsl.ktor.client.plugins.HttpTimeoutCapability;
import com.github.encryptsl.ktor.client.plugins.HttpTimeoutConfig;
import com.github.encryptsl.ktor.client.request.HttpRequestData;
import com.github.encryptsl.ktor.http.HttpHeaders;
import com.github.encryptsl.ktor.http.URLUtilsJvmKt;
import com.github.encryptsl.ktor.http.content.OutgoingContent;
import com.github.encryptsl.ktor.utils.io.ByteReadChannel;
import com.github.encryptsl.ktor.utils.io.ByteWriteChannelOperationsKt;
import com.github.encryptsl.ktor.utils.io.WriterScope;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u001b\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\b\u001a\u00020\u0007*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\b\u0010\t\"(\u0010\r\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/github/encryptsl/ktor/client/request/HttpRequestData;", "Lkotlin/coroutines/CoroutineContext;", "callContext", "Ljava/net/http/HttpRequest;", "convertToHttpRequest", "(Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/CoroutineContext;)Ljava/net/http/HttpRequest;", "Lcom/github/encryptsl/ktor/http/content/OutgoingContent;", "Ljava/net/http/HttpRequest$BodyPublisher;", "convertToHttpRequestBody", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/CoroutineContext;)Ljava/net/http/HttpRequest$BodyPublisher;", "Ljava/util/TreeSet;", "", "kotlin.jvm.PlatformType", "DISALLOWED_HEADERS", "Ljava/util/TreeSet;", "getDISALLOWED_HEADERS", "()Ljava/util/TreeSet;", "ktor-client-java"})
public final class JavaHttpRequestKt {
    @NotNull
    private static final TreeSet<String> DISALLOWED_HEADERS;

    @NotNull
    public static final TreeSet<String> getDISALLOWED_HEADERS() {
        return DISALLOWED_HEADERS;
    }

    @NotNull
    public static final HttpRequest convertToHttpRequest(@NotNull HttpRequestData $this$convertToHttpRequest, @NotNull CoroutineContext callContext) {
        HttpRequest.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$convertToHttpRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        HttpRequest.Builder $this$convertToHttpRequest_u24lambda_u244 = builder = HttpRequest.newBuilder(URLUtilsJvmKt.toURI($this$convertToHttpRequest.getUrl()));
        boolean bl = false;
        HttpTimeoutConfig httpTimeoutConfig = (HttpTimeoutConfig)$this$convertToHttpRequest.getCapabilityOrNull(HttpTimeoutCapability.INSTANCE);
        if (httpTimeoutConfig != null) {
            HttpTimeoutConfig timeoutAttributes = httpTimeoutConfig;
            boolean bl2 = false;
            Long l = timeoutAttributes.getRequestTimeoutMillis();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                if (!JavaHttpEngineKt.isTimeoutInfinite$default(it, null, 2, null)) {
                    $this$convertToHttpRequest_u24lambda_u244.timeout(Duration.ofMillis(it));
                }
            }
        }
        UtilsKt.mergeHeaders($this$convertToHttpRequest.getHeaders(), $this$convertToHttpRequest.getBody(), (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> JavaHttpRequestKt.convertToHttpRequest$lambda$4$lambda$3($this$convertToHttpRequest_u24lambda_u244, arg_0, arg_1)));
        $this$convertToHttpRequest_u24lambda_u244.method($this$convertToHttpRequest.getMethod().getValue(), JavaHttpRequestKt.convertToHttpRequestBody($this$convertToHttpRequest.getBody(), callContext));
        HttpRequest httpRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"build(...)");
        return httpRequest;
    }

    @NotNull
    public static final HttpRequest.BodyPublisher convertToHttpRequestBody(@NotNull OutgoingContent $this$convertToHttpRequestBody, @NotNull CoroutineContext callContext) {
        HttpRequest.BodyPublisher bodyPublisher;
        Intrinsics.checkNotNullParameter((Object)$this$convertToHttpRequestBody, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        OutgoingContent outgoingContent = $this$convertToHttpRequestBody;
        if (outgoingContent instanceof OutgoingContent.ByteArrayContent) {
            HttpRequest.BodyPublisher bodyPublisher2 = HttpRequest.BodyPublishers.ofByteArray(((OutgoingContent.ByteArrayContent)$this$convertToHttpRequestBody).bytes());
            bodyPublisher = bodyPublisher2;
            Intrinsics.checkNotNullExpressionValue((Object)bodyPublisher2, (String)"ofByteArray(...)");
        } else if (outgoingContent instanceof OutgoingContent.ReadChannelContent) {
            Long l = $this$convertToHttpRequestBody.getContentLength();
            bodyPublisher = new JavaHttpRequestBodyPublisher(callContext, l != null ? l : -1L, (Function0<? extends ByteReadChannel>)((Function0)() -> JavaHttpRequestKt.convertToHttpRequestBody$lambda$5($this$convertToHttpRequestBody)));
        } else if (outgoingContent instanceof OutgoingContent.WriteChannelContent) {
            Long l = $this$convertToHttpRequestBody.getContentLength();
            bodyPublisher = new JavaHttpRequestBodyPublisher(callContext, l != null ? l : -1L, (Function0<? extends ByteReadChannel>)((Function0)() -> JavaHttpRequestKt.convertToHttpRequestBody$lambda$6(callContext, $this$convertToHttpRequestBody)));
        } else if (outgoingContent instanceof OutgoingContent.NoContent) {
            HttpRequest.BodyPublisher bodyPublisher3 = HttpRequest.BodyPublishers.noBody();
            bodyPublisher = bodyPublisher3;
            Intrinsics.checkNotNullExpressionValue((Object)bodyPublisher3, (String)"noBody(...)");
        } else if (outgoingContent instanceof OutgoingContent.ContentWrapper) {
            bodyPublisher = JavaHttpRequestKt.convertToHttpRequestBody(((OutgoingContent.ContentWrapper)$this$convertToHttpRequestBody).delegate(), callContext);
        } else {
            if (outgoingContent instanceof OutgoingContent.ProtocolUpgrade) {
                throw new UnsupportedContentTypeException($this$convertToHttpRequestBody);
            }
            throw new NoWhenBranchMatchedException();
        }
        return bodyPublisher;
    }

    private static final Unit convertToHttpRequest$lambda$4$lambda$3(HttpRequest.Builder $this_with, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!DISALLOWED_HEADERS.contains(key)) {
            $this_with.header(key, value);
        }
        return Unit.INSTANCE;
    }

    private static final ByteReadChannel convertToHttpRequestBody$lambda$5(OutgoingContent $this_convertToHttpRequestBody) {
        return ((OutgoingContent.ReadChannelContent)$this_convertToHttpRequestBody).readFrom();
    }

    private static final ByteReadChannel convertToHttpRequestBody$lambda$6(CoroutineContext $callContext, OutgoingContent $this_convertToHttpRequestBody) {
        return ByteWriteChannelOperationsKt.writer$default((CoroutineScope)GlobalScope.INSTANCE, $callContext, false, (Function2)new Function2<WriterScope, Continuation<? super Unit>, Object>($this_convertToHttpRequestBody, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ OutgoingContent $this_convertToHttpRequestBody;
            {
                this.$this_convertToHttpRequestBody = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WriterScope $this$writer = (WriterScope)this.L$0;
                        this.label = 1;
                        Object object3 = ((OutgoingContent.WriteChannelContent)this.$this_convertToHttpRequestBody).writeTo($this$writer.getChannel(), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(WriterScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null).getChannel();
    }

    static {
        TreeSet treeSet;
        TreeSet $this$DISALLOWED_HEADERS_u24lambda_u240 = treeSet = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        boolean bl = false;
        Object[] objectArray = new String[]{HttpHeaders.INSTANCE.getConnection(), HttpHeaders.INSTANCE.getContentLength(), HttpHeaders.INSTANCE.getDate(), HttpHeaders.INSTANCE.getExpect(), HttpHeaders.INSTANCE.getFrom(), HttpHeaders.INSTANCE.getHost(), HttpHeaders.INSTANCE.getUpgrade(), HttpHeaders.INSTANCE.getVia(), HttpHeaders.INSTANCE.getWarning()};
        $this$DISALLOWED_HEADERS_u24lambda_u240.addAll(SetsKt.setOf((Object[])objectArray));
        DISALLOWED_HEADERS = treeSet;
    }
}

