/*
 * Decompiled with CFR 0.152.
 */
package cz.enchant.reports;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import cz.enchant.reports.DiscordWebhook;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class Reports
extends JavaPlugin {
    public void onEnable() {
        this.saveResource("config.yml", false);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register(this.createReportCommand());
            ((Commands)commands.registrar()).register(this.createReportsCommand());
        });
    }

    private LiteralCommandNode<CommandSourceStack> createReportCommand() {
        String reasonText = this.getConfig().getString("messages.reason", "reason");
        return ((LiteralArgumentBuilder)Commands.literal((String)"report").then(Commands.argument((String)reasonText, (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
            Entity executor = ((CommandSourceStack)ctx.getSource()).getExecutor();
            if (!(executor instanceof Player)) {
                Component onlyPlayersText = this.getMsg("only_players", "Only players can use this command!");
                sender.sendMessage(onlyPlayersText);
                return 1;
            }
            Player player = (Player)executor;
            String nick = player.getName();
            String location = this.getLocationString(player.getLocation());
            String reason = (String)ctx.getArgument(reasonText, String.class);
            boolean success = this.sendWebhook(nick, location, reason);
            Component sentText = this.getMsg("sent", "Report was submitted.");
            Component errorText = this.getMsg("error", "Failed to submit report!");
            sender.sendMessage(success ? sentText : errorText);
            return 1;
        }))).build();
    }

    private LiteralCommandNode<CommandSourceStack> createReportsCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reports").requires(sender -> sender.getSender().hasPermission("reports.admin"))).then(Commands.literal((String)"reload").executes(ctx -> {
            this.reloadConfig();
            Component reloadedText = this.getMsg("reloaded", "Configuration was reloaded!");
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(reloadedText);
            return 1;
        }))).build();
    }

    private Component getMsg(String key, String def) {
        String msg = this.getConfig().getString("messages." + key, def);
        return MiniMessage.miniMessage().deserialize((Object)msg);
    }

    private String getLocationString(Location location) {
        String format = this.getConfig().getString("location_format", "X: {x}, Y: {y}, Z: {z}, {world}");
        Map<String, String> replaces = Map.of("{world}", location.getWorld().getName(), "{x}", String.valueOf(location.getBlockX()), "{y}", String.valueOf(location.getBlockY()), "{z}", String.valueOf(location.getBlockZ()));
        return this.replacePlaceholders(format, replaces);
    }

    private String replacePlaceholders(String text, Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            text = text.replace(entry.getKey(), entry.getValue());
        }
        return text;
    }

    public boolean sendWebhook(String nick, String location, String reason) {
        String avatar = this.replacePlaceholders(this.getConfig().getString("avatar_url"), Map.of("{nick}", nick));
        String webhookUrl = this.getConfig().getString("discord_webhook_url");
        try {
            URL url = new URL(webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            DiscordWebhook webhook = new DiscordWebhook(nick, avatar);
            webhook.addEmbed(reason, location);
            String jsonPayload = webhook.toJson();
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 204) {
                this.getLogger().info("Report webhook sent successfully!");
                return true;
            }
            this.getLogger().warning("Failed to send report webhook. Response code: " + responseCode);
        }
        catch (Exception e) {
            this.getLogger().severe("Error sending report webhook: " + e.getMessage());
        }
        return false;
    }
}

