/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.world.npc;

import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CreateNPC {
    public static void createAuctionMaster(Location loc, String facing) {
        World world = loc.getWorld();
        if (world == null) {
            AuctionHouse.getPlugin().getLogger().severe("Creating an npc failed. The world is null.");
            return;
        }
        int rotation = 0;
        switch (facing) {
            case "north": {
                rotation = 180;
                break;
            }
            case "west": {
                rotation = 90;
                break;
            }
            case "east": {
                rotation = -90;
            }
        }
        loc.setYaw((float)rotation);
        assert (loc.getWorld() != null);
        ArmorStand stand = (ArmorStand)loc.getWorld().spawnEntity(loc.add(0.0, -1.0, 0.0), EntityType.ARMOR_STAND);
        stand.setSmall(true);
        stand.setInvulnerable(true);
        stand.setBasePlate(false);
        stand.setGravity(false);
        stand.setCollidable(false);
        stand.setInvisible(true);
        stand.setAI(false);
        stand.setSilent(true);
        stand.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "auction_stand"), PersistentDataType.BOOLEAN, (Object)true);
        Villager npc = (Villager)world.spawnEntity(loc, EntityType.VILLAGER);
        stand.addPassenger((Entity)npc);
        npc.setProfession(Villager.Profession.SHEPHERD);
        npc.setBreed(false);
        npc.setHealth(1.0);
        npc.setVillagerLevel(5);
        npc.setVillagerType(Villager.Type.JUNGLE);
        npc.setAdult();
        npc.setCanPickupItems(false);
        npc.setCustomName(Messages.getFormatted("world.npc", new String[0]));
        npc.setCustomNameVisible(true);
        npc.setCollidable(false);
        npc.setGravity(false);
        npc.setInvulnerable(true);
        npc.setSilent(true);
        npc.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "auction_master"), PersistentDataType.BOOLEAN, (Object)true);
    }

    public static void removeAuctionMaster(Villager npc) {
        if (npc == null) {
            return;
        }
        for (Entity entity : npc.getNearbyEntities(1.0, 1.0, 1.0)) {
            ArmorStand stand;
            if (!(entity instanceof ArmorStand) || !(stand = (ArmorStand)entity).getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "auction_stand"), PersistentDataType.BOOLEAN) || stand.getPassengers().isEmpty() || !npc.equals(stand.getPassengers().getFirst())) continue;
            stand.remove();
        }
        npc.remove();
    }

    public static void removeAuctionMaster(ArmorStand stand) {
        if (stand == null) {
            return;
        }
        if (stand.getPassengers().isEmpty()) {
            return;
        }
        Villager npc = (Villager)stand.getPassengers().getFirst();
        npc.remove();
        stand.remove();
    }
}

