/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.world.displays;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.TaskManager;
import me.elaineqheart.auctionHouse.data.StringUtils;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.ConfigManager;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import me.elaineqheart.auctionHouse.data.yml.SettingManager;
import me.elaineqheart.auctionHouse.world.displays.CreateDisplay;
import me.elaineqheart.auctionHouse.world.displays.DisplayNote;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Item;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class UpdateDisplay
implements Runnable {
    public static final HashMap<Integer, DisplayNote> displays = new HashMap();
    public static final HashMap<Location, Integer> locations = new HashMap();
    private static final ConfigurationSection ymlData = ConfigManager.displays.get().getConfigurationSection("displays");

    @Override
    public void run() {
        for (Integer display : displays.keySet()) {
            Sign south;
            Sign north;
            Sign west;
            Sign east;
            DisplayNote data = displays.get(display);
            Location loc = data.location;
            if (data.glassBlock == null) {
                UpdateDisplay.retrieveData(loc, data);
                continue;
            }
            if (data.glassBlock.isDead()) continue;
            int rank = (Integer)data.glassBlock.getPersistentDataContainer().get(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), data.type), PersistentDataType.INTEGER);
            ItemNote note = UpdateDisplay.getNote(data.type, rank);
            if (!loc.getBlock().getType().equals((Object)Material.CHISELED_TUFF_BRICKS)) {
                CreateDisplay.placeBlocks(loc);
            }
            Location signLoc = loc.clone();
            try {
                east = (Sign)signLoc.add(1.0, 0.0, 0.0).getBlock().getState();
                west = (Sign)signLoc.add(-2.0, 0.0, 0.0).getBlock().getState();
                north = (Sign)signLoc.add(1.0, 0.0, -1.0).getBlock().getState();
                south = (Sign)signLoc.add(0.0, 0.0, 2.0).getBlock().getState();
            }
            catch (ClassCastException e) {
                CreateDisplay.placeBlocks(loc);
                continue;
            }
            Sign[] signs = new Sign[]{east, west, north, south};
            if (note == null) {
                for (Sign sign : signs) {
                    sign.getSide(Side.FRONT).setLine(0, "");
                    sign.getSide(Side.FRONT).setLine(1, "");
                    sign.getSide(Side.FRONT).setLine(3, "");
                    sign.update(true, false);
                }
                if (data.text != null) {
                    data.text.remove();
                }
                if (data.itemEntity == null) continue;
                data.itemEntity.remove();
                data.itemStack = null;
                continue;
            }
            String price = note.getPriceTrimmed();
            String time = StringUtils.getTimeTrimmed(note.timeLeft());
            String playerName = note.getPlayerName();
            ItemStack item = note.getItem();
            for (Sign sign : signs) {
                if (SettingManager.currencyBeforeNumber) {
                    sign.getSide(Side.FRONT).setLine(0, String.valueOf(ChatColor.GOLD) + SettingManager.currencySymbol + price);
                } else {
                    sign.getSide(Side.FRONT).setLine(0, String.valueOf(ChatColor.GOLD) + price + SettingManager.currencySymbol);
                }
                sign.getSide(Side.FRONT).setLine(1, String.valueOf(ChatColor.YELLOW) + time);
                sign.getSide(Side.FRONT).setLine(3, Messages.getFormatted("world.displays.sign-interaction", new String[0]));
                sign.update(true, false);
            }
            World world = loc.getWorld();
            assert (world != null);
            if (data.itemEntity == null || data.itemEntity.isDead() || data.itemStack == null || data.itemStack.getType() != item.getType() || !Objects.equals(data.itemStack.getItemMeta(), item.getItemMeta())) {
                if (data.itemEntity != null) {
                    data.itemEntity.remove();
                }
                data.itemEntity = (Item)world.spawnEntity(loc.clone().add(0.5, 1.0, 0.5), EntityType.ITEM);
                data.itemEntity.setItemStack(item);
                data.itemEntity.setPickupDelay(Short.MAX_VALUE);
                data.itemEntity.setUnlimitedLifetime(true);
                data.itemEntity.setInvulnerable(true);
                data.itemEntity.setVelocity(new Vector(0, 0, 0));
                data.itemEntity.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "display_item"), PersistentDataType.BOOLEAN, (Object)true);
                data.itemStack = item;
            } else if (data.itemEntity.getLocation().distance(loc.clone().add(0.5, 1.0, 0.5)) > 0.1) {
                data.itemEntity.teleport(loc.clone().add(0.5, 1.0, 0.5));
            }
            Object name = data.itemEntity.getName();
            if (item.getItemMeta() != null && item.getItemMeta().hasDisplayName()) {
                name = String.valueOf(ChatColor.ITALIC) + item.getItemMeta().getDisplayName();
            }
            if (!data.reloaded) {
                if (data.text == null || !data.itemName.equals(name) || !data.playerName.equals(playerName)) {
                    if (data.text != null) {
                        data.text.remove();
                    }
                    data.text = (TextDisplay)world.spawnEntity(loc.clone().add(0.5, 1.9, 0.5), EntityType.TEXT_DISPLAY);
                    data.text.setVisibleByDefault(true);
                    if (data.type.equals("highest_price")) {
                        data.text.setText(String.valueOf(ChatColor.YELLOW) + "#" + rank + " " + String.valueOf(ChatColor.RESET) + (String)name + String.valueOf(ChatColor.GRAY) + "\n" + Messages.getFormatted("world.displays.by-player", new String[0]) + playerName);
                    } else if (data.type.equals("ending_soon")) {
                        data.text.setText(String.valueOf(ChatColor.GREEN) + "#" + rank + " " + String.valueOf(ChatColor.RESET) + (String)name + String.valueOf(ChatColor.GRAY) + "\n" + Messages.getFormatted("world.displays.by-player", new String[0]) + playerName);
                    }
                    data.text.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "display_text"), PersistentDataType.BOOLEAN, (Object)true);
                    data.text.setAlignment(TextDisplay.TextAlignment.CENTER);
                    data.text.setBillboard(Display.Billboard.CENTER);
                }
            } else {
                data.reloaded = false;
            }
            data.itemName = name;
            data.playerName = playerName;
        }
    }

    public static ConfigurationSection getYmlData() {
        if (ymlData != null) {
            return ymlData;
        }
        ConfigManager.displays.get().createSection("displays");
        ConfigManager.displays.save();
        return ConfigManager.displays.get().getConfigurationSection("displays");
    }

    public static void init() {
        UpdateDisplay.reload();
        TaskManager.addTaskID(UUID.randomUUID(), Bukkit.getScheduler().runTaskTimer((Plugin)AuctionHouse.getPlugin(), (Runnable)new UpdateDisplay(), 0L, 20L).getTaskId());
    }

    public static void reload() {
        for (String key : UpdateDisplay.getYmlData().getKeys(false)) {
            Location loc = UpdateDisplay.getYmlData().getLocation(key);
            assert (loc != null);
            DisplayNote data = new DisplayNote();
            data.location = loc;
            UpdateDisplay.retrieveData(loc, data);
            locations.put(loc, Integer.parseInt(key));
            displays.put(Integer.parseInt(key), data);
        }
    }

    private static void retrieveData(Location loc, DisplayNote data) {
        BlockDisplay entity = null;
        Item itemEntity = null;
        TextDisplay text = null;
        assert (loc.getWorld() != null);
        for (Entity test : loc.getWorld().getNearbyEntities(loc, 1.0, 1.0, 1.0)) {
            if (!UpdateDisplay.isDisplayGlass(test)) continue;
            entity = (BlockDisplay)test;
        }
        if (entity == null) {
            return;
        }
        data.glassBlock = entity;
        data.type = UpdateDisplay.getType(entity);
        for (Entity test : loc.getWorld().getNearbyEntities(loc.clone().add(0.5, 0.5, 0.5), 1.0, 1.0, 1.0)) {
            if (!UpdateDisplay.isDisplayItem(test)) continue;
            itemEntity = (Item)test;
        }
        if (itemEntity != null) {
            data.itemEntity = itemEntity;
            data.itemStack = itemEntity.getItemStack();
        }
        for (Entity test : loc.getWorld().getNearbyEntities(loc.clone().add(0.5, 1.9, 0.5), 1.0, 1.0, 1.0)) {
            if (!UpdateDisplay.isTextDisplay(test)) continue;
            text = (TextDisplay)test;
        }
        if (text != null) {
            data.text = text;
            data.itemName = "";
            data.playerName = "";
            data.reloaded = true;
        }
    }

    public static boolean isDisplayGlass(Entity entity) {
        if (entity instanceof BlockDisplay) {
            BlockDisplay display = (BlockDisplay)entity;
            return display.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "highest_price"), PersistentDataType.INTEGER) || display.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "ending_soon"), PersistentDataType.INTEGER);
        }
        return false;
    }

    public static boolean isDisplayInteraction(Entity entity) {
        if (entity instanceof Interaction) {
            Interaction interaction = (Interaction)entity;
            return interaction.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "rank"), PersistentDataType.INTEGER) && interaction.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "type"), PersistentDataType.STRING);
        }
        return false;
    }

    private static boolean isDisplayItem(Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            return item.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "display_item"), PersistentDataType.BOOLEAN);
        }
        return false;
    }

    private static boolean isTextDisplay(Entity entity) {
        if (entity instanceof TextDisplay) {
            TextDisplay text = (TextDisplay)entity;
            return text.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "display_text"), PersistentDataType.BOOLEAN);
        }
        return false;
    }

    private static String getType(BlockDisplay display) {
        if (display.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "highest_price"), PersistentDataType.INTEGER)) {
            return "highest_price";
        }
        if (display.getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "ending_soon"), PersistentDataType.INTEGER)) {
            return "ending_soon";
        }
        return null;
    }

    public static ItemNote getNote(String type, int rank) {
        if (type.equals("highest_price")) {
            int size = ItemNoteStorageUtil.sortedHighestPrice().size();
            if (rank > size) {
                return null;
            }
            Map.Entry entry = ItemNoteStorageUtil.sortedHighestPrice().entrySet().stream().skip(size - rank).findFirst().orElse(null);
            if (entry == null) {
                return null;
            }
            return (ItemNote)entry.getKey();
        }
        if (type.equals("ending_soon")) {
            Map.Entry entry = ItemNoteStorageUtil.sortedDateCreated().entrySet().stream().skip(rank - 1).findFirst().orElse(null);
            if (entry == null) {
                return null;
            }
            return (ItemNote)entry.getKey();
        }
        return null;
    }

    public static void removeDisplay(Location loc, boolean removeBlocks) {
        Integer displayID = locations.get(loc);
        if (removeBlocks) {
            loc.add(1.0, 0.0, 0.0).getBlock().setType(Material.AIR);
            loc.add(-2.0, 0.0, 0.0).getBlock().setType(Material.AIR);
            loc.add(1.0, 0.0, -1.0).getBlock().setType(Material.AIR);
            loc.add(0.0, 0.0, 2.0).getBlock().setType(Material.AIR);
            loc.add(0.0, 0.0, -1.0).getBlock().setType(Material.AIR);
        }
        if (displayID != null) {
            DisplayNote data = displays.get(displayID);
            UpdateDisplay.retrieveData(loc, data);
            UpdateDisplay.safeRemoveGlass(data.glassBlock);
            if (data.itemEntity != null) {
                data.itemEntity.remove();
            }
            if (data.text != null) {
                data.text.remove();
            }
            UpdateDisplay.safeRemoveInteraction(loc);
            locations.remove(loc);
            displays.remove(displayID);
            UpdateDisplay.getYmlData().set(String.valueOf(displayID), null);
            ConfigManager.displays.save();
            UpdateDisplay.reload();
        } else {
            AuctionHouse.getPlugin().getLogger().warning("Display at location " + String.valueOf(loc) + " not found. Failed to remove it.");
        }
    }

    public static void safeRemoveInteraction(Location loc) {
        assert (loc.getWorld() != null);
        for (Entity interaction : loc.getWorld().getNearbyEntities(loc.clone().add(0.2, 1.0, 0.2), 1.0, 1.0, 1.0)) {
            if (!UpdateDisplay.isDisplayInteraction(interaction)) continue;
            for (NamespacedKey key : interaction.getPersistentDataContainer().getKeys()) {
                interaction.getPersistentDataContainer().remove(key);
            }
            interaction.remove();
        }
    }

    public static void safeRemoveGlass(BlockDisplay glass) {
        if (glass != null) {
            for (NamespacedKey key : glass.getPersistentDataContainer().getKeys()) {
                glass.getPersistentDataContainer().remove(key);
            }
            glass.remove();
        }
    }
}

