/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.world.displays;

import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionViewGUI;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.yml.SettingManager;
import me.elaineqheart.auctionHouse.world.displays.UpdateDisplay;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DisplayListener
implements Listener {
    @EventHandler
    public void onDisplayBreak(BlockBreakEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.CHISELED_TUFF_BRICKS) && !event.getBlock().getType().equals((Object)Material.DARK_OAK_WALL_SIGN)) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        Player p = event.getPlayer();
        Location displayLoc = this.isProtected(loc);
        if (displayLoc == null) {
            return;
        }
        if (!p.getGameMode().equals((Object)GameMode.CREATIVE) || !p.hasPermission(SettingManager.permissionModerate)) {
            event.setCancelled(true);
            return;
        }
        UpdateDisplay.removeDisplay(displayLoc, true);
    }

    private Location isProtected(Location loc) {
        for (Location loc2 : UpdateDisplay.locations.keySet()) {
            if (loc.equals((Object)loc2) || loc.add(0.0, 0.0, 1.0).equals((Object)loc2) || loc.add(0.0, 0.0, -2.0).equals((Object)loc2) || loc.add(1.0, 0.0, 1.0).equals((Object)loc2) || loc.add(-2.0, 0.0, 0.0).equals((Object)loc2)) {
                loc.add(1.0, 0.0, 0.0);
                return loc2;
            }
            loc.add(1.0, 0.0, 0.0);
        }
        return null;
    }

    @EventHandler
    public void onItemPickup(InventoryPickupItemEvent event) {
        if (event.getItem().getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "display_item"), PersistentDataType.BOOLEAN)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDisplayClick(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked().getPersistentDataContainer().has(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "type"), PersistentDataType.STRING)) {
            Player p = event.getPlayer();
            String type = (String)event.getRightClicked().getPersistentDataContainer().get(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "type"), PersistentDataType.STRING);
            if (type == null) {
                throw new RuntimeException("The display type is null. This should never happen.");
            }
            int rank = (Integer)event.getRightClicked().getPersistentDataContainer().get(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "rank"), PersistentDataType.INTEGER);
            ItemNote note = UpdateDisplay.getNote(type, rank);
            if (note != null) {
                p.playSound((Entity)p, Sound.UI_STONECUTTER_SELECT_RECIPE, 0.2f, 1.0f);
                AuctionHouse.getGuiManager().openGUI(new AuctionViewGUI(note, p), p);
            }
        }
    }

    @EventHandler
    public void onPiston(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            Location loc = block.getLocation();
            for (Location loc2 : UpdateDisplay.locations.keySet()) {
                if (!loc.equals((Object)loc2)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onPiston(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            Location loc = block.getLocation();
            for (Location loc2 : UpdateDisplay.locations.keySet()) {
                if (!loc.equals((Object)loc2)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onExplosion(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> {
            Location loc = block.getLocation();
            return this.isProtected(loc) != null;
        });
    }

    @EventHandler
    public void onExplosion(BlockExplodeEvent event) {
        event.blockList().removeIf(block -> {
            Location loc = block.getLocation();
            return this.isProtected(loc) != null;
        });
    }

    @EventHandler
    public void onKill(EntityRemoveEvent event) {
        Location loc;
        Entity entity = event.getEntity();
        if (!entity.isValid()) {
            return;
        }
        if (entity.isDead()) {
            return;
        }
        if (UpdateDisplay.isDisplayGlass(entity)) {
            loc = entity.getLocation();
            UpdateDisplay.safeRemoveInteraction(loc);
            UpdateDisplay.removeDisplay(loc, false);
        }
        if (UpdateDisplay.isDisplayInteraction(entity)) {
            loc = entity.getLocation().add(-0.5, -1.0, -0.5);
            UpdateDisplay.removeDisplay(loc, false);
        }
    }

    @EventHandler
    public void onTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (UpdateDisplay.isDisplayGlass(entity) || UpdateDisplay.isDisplayInteraction(entity)) {
            event.setCancelled(true);
        }
    }
}

