/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.world.displays;

import java.util.Collections;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.data.yml.ConfigManager;
import me.elaineqheart.auctionHouse.world.displays.UpdateDisplay;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class CreateDisplay {
    public static void createDisplayHighestPrice(Location loc, int itemRank) {
        CreateDisplay.createDisplay(loc, itemRank, "highest_price");
    }

    public static void createDisplayEndingSoon(Location loc, int itemRank) {
        CreateDisplay.createDisplay(loc, itemRank, "ending_soon");
    }

    public static void createDisplay(Location loc, int rank, String sortType) {
        World world = loc.getWorld();
        if (world == null) {
            AuctionHouse.getPlugin().getLogger().severe("Creating an npc failed. The world is null.");
            return;
        }
        BlockDisplay glass = (BlockDisplay)world.spawnEntity(loc, EntityType.BLOCK_DISPLAY);
        glass.setBlock(Material.GLASS.createBlockData());
        Vector3f scale = new Vector3f(0.6f, 0.6f, 0.6f);
        Vector3f translation = new Vector3f(0.2f, 1.0f, 0.2f);
        AxisAngle4f zeroRotation = new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f);
        glass.setTransformation(new Transformation(translation, zeroRotation, scale, zeroRotation));
        glass.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), sortType), PersistentDataType.INTEGER, (Object)rank);
        Interaction interaction = (Interaction)world.spawnEntity(loc.clone().add(0.5, 1.0, 0.5), EntityType.INTERACTION);
        interaction.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "rank"), PersistentDataType.INTEGER, (Object)rank);
        interaction.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "type"), PersistentDataType.STRING, (Object)sortType);
        interaction.setInteractionHeight(0.8f);
        interaction.setInteractionWidth(0.6f);
        interaction.setResponsive(true);
        CreateDisplay.placeBlocks(loc);
        int displayID = 1;
        if (!UpdateDisplay.displays.isEmpty()) {
            displayID = Collections.max(UpdateDisplay.displays.keySet()) + 1;
        }
        assert (UpdateDisplay.getYmlData() != null);
        UpdateDisplay.getYmlData().set(String.valueOf(displayID), (Object)loc);
        ConfigManager.displays.save();
        UpdateDisplay.reload();
    }

    public static void placeBlocks(Location loc) {
        loc.getBlock().setType(Material.CHISELED_TUFF_BRICKS, false);
        loc.add(1.0, 0.0, 0.0).getBlock().setType(Material.DARK_OAK_WALL_SIGN);
        loc.add(-2.0, 0.0, 0.0).getBlock().setType(Material.DARK_OAK_WALL_SIGN);
        loc.add(1.0, 0.0, -1.0).getBlock().setType(Material.DARK_OAK_WALL_SIGN);
        loc.add(0.0, 0.0, 2.0).getBlock().setType(Material.DARK_OAK_WALL_SIGN);
        Sign east = (Sign)loc.add(1.0, 0.0, -1.0).getBlock().getState();
        east.setWaxed(true);
        east.update();
        Directional eastData = (Directional)east.getBlockData();
        eastData.setFacing(BlockFace.EAST);
        loc.getBlock().setBlockData((BlockData)eastData);
        Sign west = (Sign)loc.add(-2.0, 0.0, 0.0).getBlock().getState();
        west.setWaxed(true);
        west.update();
        Directional westData = (Directional)west.getBlockData();
        westData.setFacing(BlockFace.WEST);
        loc.getBlock().setBlockData((BlockData)westData);
        Sign north = (Sign)loc.add(1.0, 0.0, -1.0).getBlock().getState();
        north.setWaxed(true);
        north.update();
        Sign south = (Sign)loc.add(0.0, 0.0, 2.0).getBlock().getState();
        south.setWaxed(true);
        south.update();
        Directional southData = (Directional)south.getBlockData();
        southData.setFacing(BlockFace.SOUTH);
        loc.getBlock().setBlockData((BlockData)southData);
        loc.add(0.0, 0.0, -1.0);
    }
}

