/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.data.yml;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.elaineqheart.auctionHouse.data.yml.Config;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    public static Config displays = new Config();
    public static Config bannedPlayers = new Config();
    public static Config permissions = new Config();
    public static Config blacklist = new Config();

    public static void setupConfigs() {
        displays.setup("displays", false);
        ConfigManager.displaysBackwardsCompatibility();
        bannedPlayers.setup("bannedPlayers", false);
        permissions.setup("permissions", true);
        blacklist.setup("blacklist", false);
        ConfigManager.permissions();
    }

    public static void reloadConfigs() {
        displays.reload();
        bannedPlayers.reload();
        permissions.reload();
        blacklist.reload();
    }

    private static void permissions() {
        if (permissions.get().getConfigurationSection("auction-slots") == null) {
            permissions.get().createSection("auction-slots");
            permissions.save();
        }
        if (permissions.get().getConfigurationSection("auction-duration") == null) {
            permissions.get().createSection("auction-duration");
            permissions.save();
        }
    }

    private static void displaysBackwardsCompatibility() {
        Set oldSet = null;
        FileConfiguration customFile = displays.get();
        try {
            oldSet = customFile.getKeys(false).stream().map(Integer::parseInt).collect(Collectors.toSet());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (customFile.getConfigurationSection("displays") == null) {
            customFile.createSection("displays");
        }
        if (oldSet != null) {
            for (Integer displayID : oldSet) {
                Objects.requireNonNull(customFile.getConfigurationSection("displays")).set(String.valueOf(displayID), customFile.get(String.valueOf(displayID)));
                customFile.set(String.valueOf(displayID), null);
            }
        }
        displays.save();
    }
}

