/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.data.yml;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import me.elaineqheart.auctionHouse.AuctionHouse;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private File file;
    private FileConfiguration customFile;

    public void setup(String fileName, boolean copyDefaults) {
        this.file = new File(AuctionHouse.getPlugin().getDataFolder(), fileName + ".yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.customFile = YamlConfiguration.loadConfiguration((File)this.file);
        if (!copyDefaults) {
            return;
        }
        InputStream defConfigStream = AuctionHouse.getPlugin().getResource(fileName + ".yml");
        if (defConfigStream == null) {
            return;
        }
        this.customFile.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, Charsets.UTF_8)));
        this.customFile.options().copyDefaults(true);
        this.save();
    }

    public FileConfiguration get() {
        return this.customFile;
    }

    public void save() {
        try {
            this.customFile.save(this.file);
        }
        catch (IOException e) {
            AuctionHouse.getPlugin().getLogger().severe("Couldn't save displays.yml file");
        }
    }

    public void reload() {
        this.customFile = YamlConfiguration.loadConfiguration((File)this.file);
    }
}

