/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.data.items;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemStackConverter;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemNoteStorageUtil {
    private static ArrayList<ItemNote> itemNotes = new ArrayList();
    private static LinkedHashMap<ItemNote, Integer> sortedHighestPrice = new LinkedHashMap();
    private static LinkedHashMap<ItemNote, Long> sortedDateCreated = new LinkedHashMap();
    private static LinkedHashMap<ItemNote, String> sortedAlphabetical = new LinkedHashMap();

    public static void createNote(Player p, ItemStack item, int price) {
        String data = ItemStackConverter.encode(item);
        ItemNote itemNote = new ItemNote(p, data, price);
        itemNotes.add(itemNote);
        ItemNoteStorageUtil.updateSortedLists();
        try {
            ItemNoteStorageUtil.saveNotes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteNote(ItemNote note) {
        itemNotes.remove(note);
        ItemNoteStorageUtil.updateSortedLists();
        try {
            ItemNoteStorageUtil.saveNotes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean noteDoesNotExist(ItemNote note) {
        for (ItemNote n : itemNotes) {
            if (!n.getNoteID().equals(note.getNoteID())) continue;
            return false;
        }
        return true;
    }

    public static void saveNotes() throws IOException {
        Gson gson = new Gson();
        File file = new File(AuctionHouse.getPlugin().getDataFolder().getAbsolutePath() + "/notes.json");
        file.getParentFile().mkdir();
        file.createNewFile();
        FileWriter writer = new FileWriter(file, false);
        gson.toJson(itemNotes, (Appendable)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static void loadNotes() throws IOException {
        Gson gson = new Gson();
        File file = new File(AuctionHouse.getPlugin().getDataFolder().getAbsolutePath() + "/notes.json");
        if (file.exists()) {
            FileReader reader = new FileReader(file);
            ItemNote[] n = (ItemNote[])gson.fromJson((Reader)reader, ItemNote[].class);
            itemNotes = new ArrayList<ItemNote>(Arrays.asList(n));
            ItemNoteStorageUtil.updateSortedLists();
        }
    }

    public static ItemNote findNoteByID(String noteID) {
        for (ItemNote note : itemNotes) {
            if (!note.getNoteID().toString().equals(noteID)) continue;
            return note;
        }
        return null;
    }

    public static List<ItemNote> findAllNotes() {
        return itemNotes;
    }

    private static void updateSortedLists() {
        HashMap<ItemNote, Integer> map = new HashMap<ItemNote, Integer>();
        for (ItemNote itemNote : itemNotes) {
            if (itemNote.isSold() || itemNote.isExpired()) continue;
            map.put(itemNote, itemNote.getPrice());
        }
        sortedHighestPrice = map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        HashMap<ItemNote, Long> map2 = new HashMap<ItemNote, Long>();
        for (ItemNote note : itemNotes) {
            if (note.isSold() || note.isExpired()) continue;
            map2.put(note, note.getDateCreated().getTime());
        }
        sortedDateCreated = map2.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        HashMap<ItemNote, String> hashMap = new HashMap<ItemNote, String>();
        for (ItemNote note : itemNotes) {
            if (note.isSold() || note.isExpired()) continue;
            hashMap.put(note, note.getItem().getType().toString());
        }
        sortedAlphabetical = hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    public static LinkedHashMap<ItemNote, Integer> sortedHighestPrice() {
        LinkedHashMap<ItemNote, Integer> returnList = new LinkedHashMap<ItemNote, Integer>();
        for (ItemNote note : sortedHighestPrice.keySet()) {
            if (note.isSold() || note.isExpired() || note.isOnWaitingList()) continue;
            returnList.put(note, note.getPrice());
        }
        return returnList;
    }

    public static LinkedHashMap<ItemNote, Long> sortedDateCreated() {
        LinkedHashMap<ItemNote, Long> returnList = new LinkedHashMap<ItemNote, Long>();
        for (ItemNote note : sortedDateCreated.keySet()) {
            if (note.isSold() || note.isExpired() || note.isOnWaitingList()) continue;
            returnList.put(note, note.getDateCreated().getTime());
        }
        return returnList;
    }

    public static LinkedHashMap<ItemNote, String> sortedAlphabetical() {
        LinkedHashMap<ItemNote, String> returnList = new LinkedHashMap<ItemNote, String>();
        for (ItemNote note : sortedAlphabetical.keySet()) {
            if (note.isSold() || note.isExpired() || note.isOnWaitingList()) continue;
            returnList.put(note, note.getItem().getType().toString());
        }
        return returnList;
    }

    public static LinkedHashMap<ItemNote, Long> mySortedDateCreated() {
        LinkedHashMap newSortedDateCreated = new LinkedHashMap();
        for (ItemNote note : itemNotes) {
            newSortedDateCreated.put(note, note.getDateCreated().getTime());
        }
        newSortedDateCreated = newSortedDateCreated.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return newSortedDateCreated;
    }

    public static LinkedHashMap<ItemNote, Integer> hiPrSearch(String search) {
        LinkedHashMap newSortedMap = new LinkedHashMap();
        block0: for (ItemNote note : ItemNoteStorageUtil.sortedHighestPrice().keySet()) {
            for (String s : note.getSearchIndex()) {
                if (!s.contains(search.toLowerCase())) continue;
                newSortedMap.put(note, note.getPrice());
                continue block0;
            }
        }
        newSortedMap = newSortedMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return newSortedMap;
    }

    public static LinkedHashMap<ItemNote, Long> dateSearch(String search) {
        LinkedHashMap newSortedMap = new LinkedHashMap();
        block0: for (ItemNote note : ItemNoteStorageUtil.sortedDateCreated().keySet()) {
            for (String s : note.getSearchIndex()) {
                if (!s.contains(search.toLowerCase())) continue;
                newSortedMap.put(note, note.getDateCreated().getTime());
                continue block0;
            }
        }
        newSortedMap = newSortedMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return newSortedMap;
    }

    public static LinkedHashMap<ItemNote, String> alphaSearch(String search) {
        LinkedHashMap newSortedMap = new LinkedHashMap();
        block0: for (ItemNote note : ItemNoteStorageUtil.sortedAlphabetical().keySet()) {
            for (String s : note.getSearchIndex()) {
                if (!s.contains(search.toLowerCase())) continue;
                newSortedMap.put(note, note.getItem().getType().toString());
                continue block0;
            }
        }
        newSortedMap = newSortedMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        return newSortedMap;
    }

    public static int numberOfAuctions(Player p) {
        int count = 0;
        for (ItemNote note : itemNotes) {
            if (!Objects.equals(Bukkit.getPlayer((UUID)note.getPlayerUUID()), p)) continue;
            ++count;
        }
        return count;
    }
}

