/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.data.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import me.elaineqheart.auctionHouse.data.Permissions;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemStackConverter;
import me.elaineqheart.auctionHouse.data.yml.SettingManager;
import org.bukkit.Bukkit;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemNote {
    private final String playerName;
    private String buyerName;
    private final UUID playerUUID;
    private final int price;
    private Date dateCreated;
    private String itemData;
    private boolean isSold;
    private final UUID noteID = UUID.randomUUID();
    private String adminMessage;
    private long auctionTime;

    public ItemNote(Player player, String itemData, int price) {
        this.playerName = player.getDisplayName();
        this.buyerName = null;
        this.playerUUID = player.getUniqueId();
        this.dateCreated = new Date();
        this.itemData = itemData;
        this.price = price;
        this.isSold = false;
        this.auctionTime = Permissions.getAuctionDuration(player);
    }

    public ItemStack getItem() {
        return ItemStackConverter.decode(this.itemData);
    }

    public long timeLeft() {
        if (this.auctionTime == 0L) {
            this.auctionTime = Permissions.getAuctionDuration(Bukkit.getPlayer((UUID)this.playerUUID));
        }
        return this.auctionTime + SettingManager.auctionSetupTime - (new Date().getTime() - this.dateCreated.getTime()) / 1000L;
    }

    public boolean isExpired() {
        return this.timeLeft() < 0L;
    }

    public boolean isOnWaitingList() {
        if (this.auctionTime == 0L) {
            this.auctionTime = Permissions.getAuctionDuration(Bukkit.getPlayer((UUID)this.playerUUID));
        }
        return this.timeLeft() > this.auctionTime;
    }

    public boolean canAfford(double coins) {
        return coins >= (double)this.price;
    }

    public String[] getSearchIndex() {
        ItemStack item = this.getItem();
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> index = new ArrayList<String>(Collections.singleton(item.toString().toLowerCase()));
        if (meta != null && ItemManager.isShulkerBox(item)) {
            for (ItemStack itemStack : ((ShulkerBox)((BlockStateMeta)meta).getBlockState()).getInventory().getContents()) {
                if (itemStack == null) continue;
                index.add(itemStack.toString().toLowerCase());
            }
        }
        return (String[])index.toArray(String[]::new);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public int getPrice() {
        return this.price;
    }

    public String getPriceTrimmed() {
        if (this.price < 1000) {
            return String.valueOf(this.price);
        }
        if (this.price < 1000000) {
            return String.format("%.1fK", (double)this.price / 1000.0);
        }
        return String.format("%.1fM", (double)this.price / 1000000.0);
    }

    public boolean isSold() {
        return this.isSold;
    }

    public String getAdminMessage() {
        return this.adminMessage;
    }

    public UUID getNoteID() {
        return this.noteID;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public void setSold(boolean isSold) {
        this.isSold = isSold;
    }

    public void setAdminMessage(String adminMessage) {
        this.adminMessage = adminMessage;
    }

    public void setItem(ItemStack item) {
        this.itemData = ItemStackConverter.encode(item);
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }
}

