/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.data.items;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionHouseGUI;
import me.elaineqheart.auctionHouse.GUI.impl.MyAuctionsGUI;
import me.elaineqheart.auctionHouse.data.Permissions;
import me.elaineqheart.auctionHouse.data.StringUtils;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import me.elaineqheart.auctionHouse.data.yml.SettingManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemManager {
    public static ItemStack fillerItem;
    public static ItemStack lockedSlot;
    public static ItemStack refresh;
    public static ItemStack backToMainMenu;
    public static ItemStack backToMyAuctions;
    public static ItemStack info;
    public static ItemStack myAuction;
    public static ItemStack sortHighestPrice;
    public static ItemStack sortLowestPrice;
    public static ItemStack sortEndingSoon;
    public static ItemStack sortAlphabetical;
    public static ItemStack mySortAllAuctions;
    public static ItemStack mySortSoldItems;
    public static ItemStack mySortExpiredItems;
    public static ItemStack mySortActiveAuctions;
    public static ItemStack emptyPaper;
    public static ItemStack cancel;
    public static ItemStack collectExpiredItem;
    public static ItemStack cancelAuction;
    public static ItemStack commandBlockInfo;
    public static ItemStack adminCancelAuction;
    public static ItemStack adminExpireAuction;
    public static ItemStack confirm;

    private static void createFillerItem() {
        ItemStack item = new ItemStack(Material.matchMaterial((String)SettingManager.fillerItem));
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setHideTooltip(true);
        item.setItemMeta(meta);
        fillerItem = item;
    }

    private static void createLockedSlot() {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.locked-slot.name", new String[0]));
        item.setItemMeta(meta);
        lockedSlot = item;
    }

    private static void createRefresh() {
        ItemStack item = new ItemStack(Material.NETHER_STAR);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.refresh.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.refresh.lore", new String[0]));
        item.setItemMeta(meta);
        refresh = item;
    }

    private static void createBackToMainMenu() {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.back-main-menu.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.back-main-menu.lore", new String[0]));
        item.setItemMeta(meta);
        backToMainMenu = item;
    }

    private static void createBackToMyAuctions() {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.back-my-auctions.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.back-my-auctions.lore", new String[0]));
        item.setItemMeta(meta);
        backToMyAuctions = item;
    }

    private static void createInfo() {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.info.name", new String[0]));
        String tax = String.valueOf(ChatColor.GOLD) + (double)((int)(AuctionHouse.getPlugin().getConfig().getDouble("tax") * 1000.0)) / 10.0 + "%";
        meta.setLore(Messages.getLoreList("items.info.lore", "%tax%", tax));
        item.setItemMeta(meta);
        info = item;
    }

    private static void createMyAuction() {
        ItemStack item = new ItemStack(Material.ENDER_CHEST);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.my-auctions.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.my-auctions.lore", new String[0]));
        item.setItemMeta(meta);
        myAuction = item;
    }

    private static void createSortHighestPrice() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.sort-highest-price.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.sort-highest-price.lore", new String[0]));
        item.setItemMeta(meta);
        sortHighestPrice = item;
    }

    private static void createSortLowestPrice() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.sort-lowest-price.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.sort-lowest-price.lore", new String[0]));
        item.setItemMeta(meta);
        sortLowestPrice = item;
    }

    private static void createSortEndingSoon() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.sort-ending-soon.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.sort-ending-soon.lore", new String[0]));
        item.setItemMeta(meta);
        sortEndingSoon = item;
    }

    private static void createSortAlphabetical() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.sort-alphabetical.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.sort-alphabetical.lore", new String[0]));
        item.setItemMeta(meta);
        sortAlphabetical = item;
    }

    public static ItemStack getSort(AuctionHouseGUI.Sort sort) {
        if (sort.equals((Object)AuctionHouseGUI.Sort.LOWEST_PRICE)) {
            return sortLowestPrice;
        }
        if (sort.equals((Object)AuctionHouseGUI.Sort.ENDING_SOON)) {
            return sortEndingSoon;
        }
        if (sort.equals((Object)AuctionHouseGUI.Sort.ALPHABETICAL)) {
            return sortAlphabetical;
        }
        return sortHighestPrice;
    }

    public static ItemStack getMySort(MyAuctionsGUI.MySort sort) {
        if (sort.equals((Object)MyAuctionsGUI.MySort.ALL_AUCTIONS)) {
            return mySortAllAuctions;
        }
        if (sort.equals((Object)MyAuctionsGUI.MySort.SOLD_ITEMS)) {
            return mySortSoldItems;
        }
        if (sort.equals((Object)MyAuctionsGUI.MySort.EXPIRED_ITEMS)) {
            return mySortExpiredItems;
        }
        return mySortActiveAuctions;
    }

    private static void createMySortAllAuctions() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.my-sort-all.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.my-sort-all.lore", new String[0]));
        item.setItemMeta(meta);
        mySortAllAuctions = item;
    }

    private static void createMySortSoldItems() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.my-sort-sold.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.my-sort-sold.lore", new String[0]));
        item.setItemMeta(meta);
        mySortSoldItems = item;
    }

    private static void createMySortExpiredItems() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.my-sort-expired.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.my-sort-expired.lore", new String[0]));
        item.setItemMeta(meta);
        mySortExpiredItems = item;
    }

    private static void createMySortActiveAuctions() {
        ItemStack item = new ItemStack(Material.HOPPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.my-sort-active.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.my-sort-active.lore", new String[0]));
        item.setItemMeta(meta);
        mySortActiveAuctions = item;
    }

    private static void createEmptyPaper() {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(String.valueOf(ChatColor.GRAY));
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)AuctionHouse.getPlugin(), "AuctionHouseSearch"), PersistentDataType.BOOLEAN, (Object)true);
        item.setItemMeta(meta);
        emptyPaper = item;
    }

    private static void createCancel() {
        ItemStack item = new ItemStack(Material.RED_BANNER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.cancel.name", new String[0]));
        item.setItemMeta(meta);
        cancel = item;
    }

    private static void createCollectExpiredItem() {
        ItemStack item = new ItemStack(Material.RED_DYE);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.collect-expired.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.collect-expired.lore", new String[0]));
        item.setItemMeta(meta);
        collectExpiredItem = item;
    }

    private static void createCancelAuction() {
        ItemStack item = new ItemStack(Material.RED_CONCRETE);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.cancel-auction.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.cancel-auction.lore", new String[0]));
        item.setItemMeta(meta);
        cancelAuction = item;
    }

    private static void createCommandBlockInfo() {
        ItemStack item = new ItemStack(Material.STRUCTURE_BLOCK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.admin-info.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.admin-info.lore", new String[0]));
        item.setItemMeta(meta);
        commandBlockInfo = item;
    }

    private static void createAdminCancelAuction() {
        ItemStack item = new ItemStack(Material.RED_CONCRETE);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.admin-cancel-auction.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.admin-cancel-auction.lore", new String[0]));
        item.setItemMeta(meta);
        adminCancelAuction = item;
    }

    private static void createAdminExpireAuction() {
        ItemStack item = new ItemStack(Material.RED_DYE);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.admin-expire-auction.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.admin-expire-auction.lore", new String[0]));
        item.setItemMeta(meta);
        adminExpireAuction = item;
    }

    private static void createConfirmItem() {
        ItemStack item = new ItemStack(Material.GREEN_BANNER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.confirm.name", new String[0]));
        item.setItemMeta(meta);
        confirm = item;
    }

    public static ItemStack createDirt() {
        ItemStack item = new ItemStack(Material.DIRT);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.deleted.name", new String[0]));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItemFromNote(ItemNote note, Player p) {
        ItemStack item = note.getItem();
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        if (ItemManager.isShulkerBox(item)) {
            lore.addAll(Messages.getLoreList("items.auction.lore.shulker-preview", new String[0]));
        }
        lore.addAll(Messages.getLoreList("items.auction.lore.default", "%player%", note.getPlayerName(), "%price%", StringUtils.formatNumber(note.getPrice())));
        if (Objects.equals(Bukkit.getPlayer((UUID)note.getPlayerUUID()), p)) {
            lore.addAll(Messages.getLoreList("items.auction.lore.own-auction", new String[0]));
        }
        if (note.isExpired() && !note.isSold()) {
            if (note.getAdminMessage() != null) {
                if (note.getItem().equals((Object)ItemManager.createDirt())) {
                    lore.addAll(Messages.getLoreList("items.auction.lore.admin-deleted", new String[0]));
                } else {
                    lore.addAll(Messages.getLoreList("items.auction.lore.admin-expired", new String[0]));
                }
                lore.addAll(Messages.getLoreList("items.auction.lore.admin-message", "%reason%", note.getAdminMessage()));
            } else {
                lore.addAll(Messages.getLoreList("items.auction.lore.expired", new String[0]));
            }
        } else if (note.isSold()) {
            lore.addAll(Messages.getLoreList("items.auction.lore.sold", "%buyer%", note.getBuyerName()));
        } else if (note.isOnWaitingList()) {
            lore.addAll(Messages.getLoreList("items.auction.lore.waiting-list", "%time%", StringUtils.getTime(note.timeLeft() - Permissions.getAuctionDuration(p), false)));
        } else {
            lore.addAll(Messages.getLoreList("items.auction.lore.active", "%time%", StringUtils.getTime(note.timeLeft(), false)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createBuyingItemDisplay(ItemNote note) {
        ItemStack item = note.getItem();
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.addAll(Messages.getLoreList("items.auction.lore.buying-item", new String[0]));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createAdminExpireItem(ItemNote note, String reason) {
        ItemStack item = note.getItem();
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.addAll(Messages.getLoreList("items.admin-expire-item.lore", "%player%", note.getPlayerName(), "%price%", StringUtils.formatNumber(note.getPrice()), "%reason%", reason));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createAdminDeleteItem(ItemNote note, String reason) {
        ItemStack item = ItemManager.createDirt();
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.addAll(Messages.getLoreList("items.admin-delete-item.lore", "%player%", note.getPlayerName(), "%price%", StringUtils.formatNumber(note.getPrice()), "%reason%", reason));
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createTurtleScute(String price) {
        ItemStack item = new ItemStack(Material.TURTLE_SCUTE);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.buy-item.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.buy-item.lore", "%price%", price));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createArmadilloScute(String price) {
        ItemStack item = new ItemStack(Material.ARMADILLO_SCUTE);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.not-enough-money.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.not-enough-money.lore", "%price%", price));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createConfirm(String price) {
        ItemStack item = new ItemStack(Material.GREEN_BANNER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.confirm-buy.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.confirm-buy.lore", "%price%", price));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack collectSoldItem(String price) {
        ItemStack item = new ItemStack(Material.DIAMOND);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.collect-sold.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.collect-sold.lore", "%price%", price));
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isShulkerBox(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type == Material.SHULKER_BOX || type == Material.WHITE_SHULKER_BOX || type == Material.ORANGE_SHULKER_BOX || type == Material.MAGENTA_SHULKER_BOX || type == Material.LIGHT_BLUE_SHULKER_BOX || type == Material.YELLOW_SHULKER_BOX || type == Material.LIME_SHULKER_BOX || type == Material.PINK_SHULKER_BOX || type == Material.GRAY_SHULKER_BOX || type == Material.LIGHT_GRAY_SHULKER_BOX || type == Material.CYAN_SHULKER_BOX || type == Material.PURPLE_SHULKER_BOX || type == Material.BLUE_SHULKER_BOX || type == Material.BROWN_SHULKER_BOX || type == Material.GREEN_SHULKER_BOX || type == Material.RED_SHULKER_BOX || type == Material.BLACK_SHULKER_BOX;
    }

    static {
        ItemManager.createFillerItem();
        ItemManager.createLockedSlot();
        ItemManager.createRefresh();
        ItemManager.createBackToMainMenu();
        ItemManager.createBackToMyAuctions();
        ItemManager.createInfo();
        ItemManager.createMyAuction();
        ItemManager.createSortHighestPrice();
        ItemManager.createSortLowestPrice();
        ItemManager.createSortEndingSoon();
        ItemManager.createSortAlphabetical();
        ItemManager.createMySortAllAuctions();
        ItemManager.createMySortSoldItems();
        ItemManager.createMySortExpiredItems();
        ItemManager.createMySortActiveAuctions();
        ItemManager.createEmptyPaper();
        ItemManager.createCancel();
        ItemManager.createCollectExpiredItem();
        ItemManager.createCancelAuction();
        ItemManager.createCommandBlockInfo();
        ItemManager.createAdminCancelAuction();
        ItemManager.createAdminExpireAuction();
        ItemManager.createConfirmItem();
    }
}

