/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.data.items;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.elaineqheart.auctionHouse.data.yml.ConfigManager;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Blacklist {
    public static boolean isBlacklisted(ItemStack item) {
        boolean blacklisted = false;
        for (Map<?, ?> entry : Blacklist.getData()) {
            Object keyObj = entry.get("key");
            String string = entry.get("type").toString();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"exact", "material", "lore", "name"}, (Object)string, n)) {
                case 0: {
                    blacklisted = Blacklist.isExact(item, (ItemStack)keyObj);
                    break;
                }
                case 1: {
                    blacklisted = Blacklist.isMaterial(item, keyObj.toString());
                    break;
                }
                case 2: {
                    blacklisted = Blacklist.loreContains(item, keyObj.toString());
                    break;
                }
                case 3: {
                    blacklisted = Blacklist.nameContains(item, keyObj.toString());
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(keyObj));
                }
            }
            if (!blacklisted) continue;
            return true;
        }
        return false;
    }

    private static boolean isExact(ItemStack item, ItemStack key) {
        key.setAmount(item.getAmount());
        return item.equals((Object)key);
    }

    private static boolean isMaterial(ItemStack item, String key) {
        return item.getType() == Material.getMaterial((String)key);
    }

    private static boolean loreContains(ItemStack item, String key) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return false;
        }
        return meta.getLore().contains(key);
    }

    private static boolean nameContains(ItemStack item, String key) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getDisplayName().contains(key) || meta.getItemName().contains(key);
    }

    public static void addExact(ItemStack item) {
        List<Map<?, ?>> blacklist = Blacklist.getData();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("type", "exact");
        entry1.put("key", (String)item);
        blacklist.add(entry1);
        Blacklist.save(blacklist);
    }

    public static void addMaterial(String material) {
        List<Map<?, ?>> blacklist = Blacklist.getData();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("type", "material");
        entry1.put("key", material);
        blacklist.add(entry1);
        Blacklist.save(blacklist);
    }

    public static void addLoreContains(String lore) {
        List<Map<?, ?>> blacklist = Blacklist.getData();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("type", "lore");
        entry1.put("key", lore);
        blacklist.add(entry1);
        Blacklist.save(blacklist);
    }

    public static void addNameContains(String itemName) {
        List<Map<?, ?>> blacklist = Blacklist.getData();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("type", "name");
        entry1.put("key", itemName);
        blacklist.add(entry1);
        Blacklist.save(blacklist);
    }

    public static boolean undo() {
        List<Map<?, ?>> blacklist = Blacklist.getData();
        if (!blacklist.isEmpty()) {
            blacklist.removeLast();
            Blacklist.save(blacklist);
            return true;
        }
        return false;
    }

    public static boolean exists(String name) {
        return ConfigManager.blacklist.get().get(name) != null;
    }

    private static List<Map<?, ?>> getData() {
        ArrayList blacklist = ConfigManager.blacklist.get().getMapList("blacklist");
        if (blacklist.isEmpty()) {
            blacklist = new ArrayList();
            Blacklist.save(blacklist);
        }
        return blacklist;
    }

    private static void save(List<Map<?, ?>> blacklist) {
        ConfigManager.blacklist.get().set("blacklist", blacklist);
        ConfigManager.blacklist.save();
        ConfigManager.blacklist.reload();
    }
}

