/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionHouseGUI;
import me.elaineqheart.auctionHouse.GUI.impl.CollectSoldItemGUI;
import me.elaineqheart.auctionHouse.GUI.impl.MyAuctionsGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.data.Permissions;
import me.elaineqheart.auctionHouse.data.StringUtils;
import me.elaineqheart.auctionHouse.data.items.Blacklist;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.BannedPlayersUtil;
import me.elaineqheart.auctionHouse.data.yml.ConfigManager;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import me.elaineqheart.auctionHouse.data.yml.SettingManager;
import me.elaineqheart.auctionHouse.world.displays.CreateDisplay;
import me.elaineqheart.auctionHouse.world.displays.UpdateDisplay;
import me.elaineqheart.auctionHouse.world.npc.CreateNPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuctionHouseCommands
implements CommandExecutor,
TabCompleter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        String key;
        String path;
        String playerName;
        ConfigurationSection section;
        String input;
        ItemStack item;
        if (commandSender instanceof ConsoleCommandSender && strings.length == 1 && strings[0].equals(Messages.getFormatted("commands.reload", new String[0]))) {
            AuctionHouseCommands.reload();
            AuctionHouse.getPlugin().getLogger().info("reloaded files");
            return true;
        }
        if (!(commandSender instanceof Player)) return true;
        Player p = (Player)commandSender;
        if (strings.length == 0) {
            if (BannedPlayersUtil.checkIsBannedSendMessage(p)) {
                return true;
            }
            AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(p), p);
        }
        if (strings.length == 1 && strings[0].equals(Messages.getFormatted("commands.sell", new String[0]))) {
            p.sendMessage(Messages.getFormatted("command-feedback.usage", new String[0]));
        }
        if ((strings.length == 2 || strings.length == 3) && strings[0].equals(Messages.getFormatted("commands.sell", new String[0]))) {
            int price;
            if (BannedPlayersUtil.checkIsBannedSendMessage(p)) {
                return true;
            }
            if (ItemNoteStorageUtil.numberOfAuctions(p) >= Permissions.getAuctionSlots(p)) {
                p.sendMessage(Messages.getFormatted("command-feedback.reached-max-auctions", "%limit%", String.valueOf(Permissions.getAuctionSlots(p))));
                return true;
            }
            item = p.getInventory().getItemInMainHand();
            if (item.getType().equals((Object)Material.AIR)) {
                p.sendMessage(Messages.getFormatted("command-feedback.no-item-in-hand", new String[0]));
                return true;
            }
            try {
                price = Integer.parseInt(strings[1]);
            }
            catch (Exception e) {
                try {
                    price = Integer.parseInt(strings[1].substring(0, strings[1].length() - 1));
                    String suffix = strings[1].substring(strings[1].length() - 1).toLowerCase();
                    switch (suffix) {
                        case "k": {
                            price *= 1000;
                            break;
                        }
                        case "m": {
                            price *= 1000000;
                            break;
                        }
                        default: {
                            p.sendMessage(Messages.getFormatted("command-feedback.invalid-number", new String[0]));
                            return true;
                        }
                    }
                }
                catch (Exception f) {
                    p.sendMessage(Messages.getFormatted("command-feedback.invalid-number", new String[0]));
                    return true;
                }
            }
            if (price <= 0) {
                p.sendMessage(Messages.getFormatted("command-feedback.invalid-number2", new String[0]));
                return true;
            }
            int amount = item.getAmount();
            if (strings.length == 3) {
                try {
                    amount = Integer.parseInt(strings[2]);
                    if (amount < 1) throw new RuntimeException();
                    if (amount > item.getAmount()) {
                        throw new RuntimeException();
                    }
                }
                catch (Exception e) {
                    p.sendMessage(Messages.getFormatted("command-feedback.invalid-number7", new String[0]));
                    return true;
                }
            }
            if (Blacklist.isBlacklisted(item)) {
                p.sendMessage(Messages.getFormatted("command-feedback.item-blacklisted", new String[0]));
                p.playSound((Entity)p, Sound.ENTITY_ENDERMAN_TELEPORT, 0.7f, 0.1f);
                return true;
            }
            ItemStack inputItem = item.clone();
            inputItem.setAmount(amount);
            ItemNoteStorageUtil.createNote(p, inputItem, price);
            item.setAmount(item.getAmount() - amount);
            p.sendMessage(Messages.getFormatted("command-feedback.auction", "%price%", StringUtils.formatPrice(price)));
        }
        if (strings.length == 2 && strings[0].equals("view")) {
            String noteId = strings[1];
            ItemNote note = ItemNoteStorageUtil.findNoteByID(noteId);
            if (note == null) return true;
            if (!note.getPlayerUUID().equals(p.getUniqueId())) return true;
            if (note.getBuyerName() == null) {
                return true;
            }
            Sounds.click(p);
            AuctionHouse.getGuiManager().openGUI(new CollectSoldItemGUI(note, MyAuctionsGUI.MySort.ALL_AUCTIONS), p);
        }
        if (!p.hasPermission(SettingManager.permissionModerate)) return true;
        if (strings.length <= 0) return true;
        if (strings.length == 1 && strings[0].equals(Messages.getFormatted("commands.admin", new String[0]))) {
            AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(0, AuctionHouseGUI.Sort.HIGHEST_PRICE, "", p, true), p);
            return true;
        }
        if (strings.length < 4 && strings[0].equals(Messages.getFormatted("commands.ban", new String[0]))) {
            p.sendMessage(Messages.getFormatted("command-feedback.ban-usage", new String[0]));
            return true;
        }
        if (strings.length != 2 && strings[0].equals(Messages.getFormatted("commands.pardon", new String[0]))) {
            p.sendMessage(Messages.getFormatted("command-feedback.pardon-usage", new String[0]));
            return true;
        }
        if (strings.length > 3 && strings[0].equals(Messages.getFormatted("commands.ban", new String[0]))) {
            Player targetPlayer = Bukkit.getPlayer((String)strings[1]);
            if (targetPlayer == null) {
                p.sendMessage(Messages.getFormatted("command-feedback.player-not-found", new String[0]));
                return true;
            }
            try {
                int duration = Integer.parseInt(strings[2]);
                if (duration <= 0) {
                    p.sendMessage(Messages.getFormatted("command-feedback.invalid-number3", new String[0]));
                    return true;
                }
                StringBuilder reason = new StringBuilder();
                int i = 3;
                while (true) {
                    if (i >= strings.length) {
                        BannedPlayersUtil.saveBannedPlayer(targetPlayer, duration, reason.toString());
                        p.sendMessage(Messages.getFormatted("command-feedback.ban", "%player%", targetPlayer.getDisplayName(), "%duration%", String.valueOf(duration), "%reason%", reason.toString()));
                        return true;
                    }
                    reason.append(strings[i]);
                    if (i != strings.length - 1) {
                        reason.append(" ");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                p.sendMessage(Messages.getFormatted("command-feedback.invalid-number4", new String[0]));
                return true;
            }
        }
        if (strings.length == 2 && strings[0].equals(Messages.getFormatted("commands.pardon", new String[0]))) {
            input = strings[1];
            section = ConfigManager.bannedPlayers.get().getConfigurationSection("BannedPlayers");
            if (section == null) {
                p.sendMessage(Messages.getFormatted("command-feedback.no-banned-players", new String[0]));
                return true;
            }
        } else {
            if (strings[0].equals(Messages.getFormatted("commands.reload", new String[0]))) {
                AuctionHouseCommands.reload();
                p.sendMessage(Messages.getFormatted("command-feedback.reload", new String[0]));
                AuctionHouse.getPlugin().getLogger().info("reloaded");
                return true;
            }
            if (strings[0].equals(Messages.getFormatted("commands.summon", new String[0]))) {
                int itemNumber;
                if (strings.length < 2) {
                    p.sendMessage(Messages.getFormatted("command-feedback.summon-usage", new String[0]));
                    return true;
                }
                Location loc = p.getLocation();
                Location middleBlockLoc = new Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY(), (double)loc.getBlockZ() + 0.5);
                Location blockLoc = new Location(loc.getWorld(), (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ());
                if (strings[1].equals(Messages.getFormatted("commands.npc", new String[0]))) {
                    if (strings.length < 4) {
                        p.sendMessage(Messages.getFormatted("command-feedback.npc-usage", new String[0]));
                        return true;
                    }
                    CreateNPC.createAuctionMaster(middleBlockLoc, strings[3]);
                    return true;
                }
                if (!strings[1].equals(Messages.getFormatted("commands.display", new String[0]))) return true;
                if (strings.length < 4) {
                    p.sendMessage(Messages.getFormatted("command-feedback.display-usage", new String[0]));
                    return true;
                }
                try {
                    itemNumber = Integer.parseInt(strings[3]);
                    if (itemNumber < 1) {
                        p.sendMessage(Messages.getFormatted("command-feedback.invalid-number5", new String[0]));
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    p.sendMessage(Messages.getFormatted("command-feedback.invalid-number6", new String[0]));
                    return true;
                }
                for (Location displayLoc : UpdateDisplay.locations.keySet()) {
                    if (!Objects.equals(blockLoc.getWorld(), displayLoc.getWorld()) || !(blockLoc.distance(displayLoc) < 2.1)) continue;
                    p.sendMessage(Messages.getFormatted("command-feedback.no-space-for-display", new String[0]));
                    return true;
                }
                if (strings[2].equals(Messages.getFormatted("commands.highest_price", new String[0]))) {
                    CreateDisplay.createDisplayHighestPrice(blockLoc, itemNumber);
                    return true;
                }
                if (strings[2].equals(Messages.getFormatted("commands.ending_soon", new String[0]))) {
                    CreateDisplay.createDisplayEndingSoon(blockLoc, itemNumber);
                    return true;
                }
                p.sendMessage(Messages.getFormatted("command-feedback.display-usage", new String[0]));
                return true;
            }
            if (strings.length == 2 && strings[1].equals(Messages.getFormatted("commands.undo", new String[0]))) {
                if (Blacklist.undo()) {
                    p.sendMessage(Messages.getFormatted("command-feedback.blacklist-undo", new String[0]));
                    return true;
                }
                p.sendMessage(Messages.getFormatted("command-feedback.blacklist-undo-error", new String[0]));
                return true;
            }
            if (strings.length < 3 && strings[0].equals(Messages.getFormatted("commands.blacklist", new String[0]))) {
                p.sendMessage(Messages.getFormatted("command-feedback.blacklist-usage", new String[0]));
                return true;
            }
            if (strings.length == 3 && strings[0].equals(Messages.getFormatted("commands.blacklist", new String[0])) && strings[1].equals(Messages.getFormatted("commands.add", new String[0]))) {
                if (!strings[2].equals(Messages.getFormatted("commands.exact", new String[0])) && !strings[2].equals(Messages.getFormatted("commands.material", new String[0]))) {
                    p.sendMessage(Messages.getFormatted("command-feedback.blacklist-usage", new String[0]));
                    return true;
                }
                item = p.getInventory().getItemInMainHand();
                if (item.getType().equals((Object)Material.AIR)) {
                    p.sendMessage(Messages.getFormatted("command-feedback.blacklist-no-item-in-hand", new String[0]));
                    return true;
                }
                ItemMeta meta = item.getItemMeta();
                assert (meta != null);
                if (strings[2].equals(Messages.getFormatted("commands.exact", new String[0]))) {
                    Blacklist.addExact(item);
                } else {
                    Blacklist.addMaterial(item.getType().toString());
                }
                p.sendMessage(Messages.getFormatted("command-feedback.blacklist-success", "%item%", item.getType().name()));
                return true;
            }
            if (strings.length != 4) return true;
            if (!strings[0].equals(Messages.getFormatted("commands.blacklist", new String[0]))) return true;
            if (!strings[1].equals(Messages.getFormatted("commands.add", new String[0]))) return true;
            if (strings[2].equals(Messages.getFormatted("commands.exact", new String[0]))) return true;
            if (strings[2].equals(Messages.getFormatted("commands.material", new String[0]))) {
                return true;
            }
            if (strings[2].equals(Messages.getFormatted("commands.contains_lore", new String[0]))) {
                Blacklist.addLoreContains(strings[3]);
            } else if (strings[2].equals(Messages.getFormatted("commands.name_contains", new String[0]))) {
                Blacklist.addNameContains(strings[3]);
            }
            p.sendMessage(Messages.getFormatted("command-feedback.blacklist-name-success", "%name%", strings[3]));
            return true;
        }
        Iterator reason = section.getKeys(false).iterator();
        do {
            if (!reason.hasNext()) {
                p.sendMessage(Messages.getFormatted("command-feedback.not-banned", new String[0]));
                return true;
            }
            key = (String)reason.next();
            path = "BannedPlayers." + key + ".PlayerName";
        } while ((playerName = ConfigManager.bannedPlayers.get().getString(path)) == null || !playerName.equals(input));
        ConfigManager.bannedPlayers.get().set("BannedPlayers." + key, null);
        ConfigManager.bannedPlayers.save();
        p.sendMessage(Messages.getFormatted("command-feedback.pardon", "%player%", playerName));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        ArrayList<String> params;
        block23: {
            block24: {
                block22: {
                    params = new ArrayList<String>();
                    if (strings.length == 1) {
                        ArrayList<String> assetParams = new ArrayList<String>(List.of(new String[]{Messages.getFormatted("commands.sell", new String[0])}));
                        if (commandSender.hasPermission(SettingManager.permissionModerate)) {
                            assetParams.add(Messages.getFormatted("commands.admin", new String[0]));
                            assetParams.add(Messages.getFormatted("commands.ban", new String[0]));
                            assetParams.add(Messages.getFormatted("commands.pardon", new String[0]));
                            assetParams.add(Messages.getFormatted("commands.reload", new String[0]));
                            assetParams.add(Messages.getFormatted("commands.summon", new String[0]));
                            assetParams.add(Messages.getFormatted("commands.blacklist", new String[0]));
                        }
                        Iterator iterator = assetParams.iterator();
                        while (iterator.hasNext()) {
                            String p = (String)iterator.next();
                            if (p.indexOf(strings[0]) != 0) continue;
                            params.add(p);
                        }
                    }
                    if (strings.length != 2 || !strings[0].equals(Messages.getFormatted("commands.ban", new String[0]))) break block22;
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        params.add(p.getDisplayName());
                    }
                    break block23;
                }
                if (strings.length != 2 || !strings[0].equals(Messages.getFormatted("commands.pardon", new String[0]))) break block24;
                ConfigurationSection section = ConfigManager.bannedPlayers.get().getConfigurationSection("BannedPlayers");
                if (section == null) break block23;
                for (String key : section.getKeys(false)) {
                    String path = "BannedPlayers." + key + ".PlayerName";
                    params.add(ConfigManager.bannedPlayers.get().getString(path));
                }
                break block23;
            }
            if (strings.length == 2 && strings[0].equals(Messages.getFormatted("commands.summon", new String[0]))) {
                summonTypes = new ArrayList<String>(List.of(new String[]{Messages.getFormatted("commands.npc", new String[0]), Messages.getFormatted("commands.display", new String[0])}));
                for (String p : summonTypes) {
                    if (p.indexOf(strings[1]) != 0) continue;
                    params.add(p);
                }
            } else if (strings.length == 2 && strings[0].equals(Messages.getFormatted("commands.blacklist", new String[0]))) {
                summonTypes = new ArrayList<String>(List.of(new String[]{Messages.getFormatted("commands.add", new String[0]), Messages.getFormatted("commands.undo", new String[0])}));
                for (String p : summonTypes) {
                    if (p.indexOf(strings[1]) != 0) continue;
                    params.add(p);
                }
            } else if (strings.length == 3 && strings[0].equals(Messages.getFormatted("commands.summon", new String[0])) && strings[1].equals(Messages.getFormatted("commands.display", new String[0]))) {
                displayTypes = new ArrayList<String>(List.of(new String[]{Messages.getFormatted("commands.highest_price", new String[0]), Messages.getFormatted("commands.ending_soon", new String[0])}));
                for (String p : displayTypes) {
                    if (p.indexOf(strings[2]) != 0) continue;
                    params.add(p);
                }
            } else if (strings.length == 3 && strings[0].equals(Messages.getFormatted("commands.summon", new String[0])) && strings[1].equals(Messages.getFormatted("commands.npc", new String[0]))) {
                displayTypes = new ArrayList<String>(List.of(new String[]{Messages.getFormatted("commands.facing", new String[0])}));
                for (String p : displayTypes) {
                    if (p.indexOf(strings[2]) != 0) continue;
                    params.add(p);
                }
            } else if (strings.length == 3 && strings[0].equals(Messages.getFormatted("commands.blacklist", new String[0])) && strings[1].equals(Messages.getFormatted("commands.add", new String[0]))) {
                displayTypes = new ArrayList<String>(List.of(new String[]{Messages.getFormatted("commands.exact", new String[0]), Messages.getFormatted("commands.material", new String[0]), Messages.getFormatted("commands.name_contains", new String[0]), Messages.getFormatted("commands.contains_lore", new String[0])}));
                for (String p : displayTypes) {
                    if (p.indexOf(strings[2]) != 0) continue;
                    params.add(p);
                }
            } else if (strings.length == 4 && strings[0].equals(Messages.getFormatted("commands.summon", new String[0])) && strings[1].equals(Messages.getFormatted("commands.npc", new String[0]))) {
                displayTypes = new ArrayList<String>(List.of(new String[]{Messages.getFormatted("commands.north", new String[0]), Messages.getFormatted("commands.east", new String[0]), Messages.getFormatted("commands.south", new String[0]), Messages.getFormatted("commands.west", new String[0])}));
                for (String p : displayTypes) {
                    if (p.indexOf(strings[3]) != 0) continue;
                    params.add(p);
                }
            }
        }
        return params;
    }

    private static void reload() {
        try {
            ItemNoteStorageUtil.loadNotes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        AuctionHouse.getPlugin().reloadConfig();
        SettingManager.loadData();
        ConfigManager.reloadConfigs();
        UpdateDisplay.reload();
        Messages.reload();
    }
}

