/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.other;

import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.impl.AdminConfirmGUI;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionHouseGUI;
import me.elaineqheart.auctionHouse.GUI.other.AnvilSearchGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;

public class AnvilGUIListener
implements Listener {
    @EventHandler
    public void handleClick(InventoryClickEvent event) {
        if (event.getInventory().getType() != InventoryType.ANVIL) {
            return;
        }
        ItemStack paperItem = event.getInventory().getItem(0);
        if (paperItem == null || !paperItem.equals((Object)ItemManager.emptyPaper)) {
            return;
        }
        event.setCancelled(true);
        AnvilView view = (AnvilView)event.getView();
        view.setRepairCost(0);
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() != 2) {
            return;
        }
        ItemStack resultItem = event.getCurrentItem();
        if (resultItem == null) {
            return;
        }
        ItemMeta meta = resultItem.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            player.getOpenInventory().getTopInventory().remove(ItemManager.emptyPaper);
            String typedText = meta.getDisplayName();
            Sounds.click(event);
            if (view.getTitle().equals(Messages.getFormatted("inventory-titles.anvil-search", new String[0]))) {
                AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(0, AuctionHouseGUI.Sort.HIGHEST_PRICE, typedText, player, false), player);
            } else if (view.getTitle().equals(Messages.getFormatted("inventory-titles.anvil-admin-search", new String[0]))) {
                AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(0, AuctionHouseGUI.Sort.HIGHEST_PRICE, typedText, player, true), player);
            } else if (view.getTitle().equals(Messages.getFormatted("anvil-admin-expire-message", new String[0]))) {
                AuctionHouse.getGuiManager().openGUI(new AdminConfirmGUI(typedText, AnvilSearchGUI.currentAdminNoteMap.get(player), AnvilSearchGUI.SearchType.ITEM_EXPIRE_MESSAGE), player);
            } else if (view.getTitle().equals(Messages.getFormatted("anvil-admin-delete-message", new String[0]))) {
                AuctionHouse.getGuiManager().openGUI(new AdminConfirmGUI(typedText, AnvilSearchGUI.currentAdminNoteMap.get(player), AnvilSearchGUI.SearchType.ITEM_DELETE_MESSAGE), player);
            }
        }
    }

    @EventHandler
    public void onType(PrepareAnvilEvent event) {
        ItemStack paperItem = event.getInventory().getItem(0);
        if (paperItem == null || !paperItem.equals((Object)ItemManager.emptyPaper)) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)AuctionHouse.getPlugin(), () -> event.getView().setRepairCost(0), 1L);
    }

    @EventHandler
    public void onAnvilClose(InventoryCloseEvent event) {
        if (event.getInventory().getType() != InventoryType.ANVIL) {
            return;
        }
        ItemStack paperItem = event.getInventory().getItem(0);
        if (paperItem == null || !paperItem.equals((Object)ItemManager.emptyPaper)) {
            return;
        }
        Player p = (Player)event.getPlayer();
        p.getOpenInventory().getTopInventory().remove(ItemManager.emptyPaper);
        if (event.getInventory().getItem(2) != null) {
            return;
        }
        AnvilView view = (AnvilView)event.getView();
        if (view.getTitle().equals(Messages.getFormatted("inventory-titles.anvil-search", new String[0]))) {
            Bukkit.getScheduler().runTaskLater((Plugin)AuctionHouse.getPlugin(), () -> AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(0, AuctionHouseGUI.Sort.HIGHEST_PRICE, "", p, false), p), 1L);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)AuctionHouse.getPlugin(), () -> AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(0, AuctionHouseGUI.Sort.HIGHEST_PRICE, "", p, true), p), 1L);
        }
    }
}

