/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.InventoryButton;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionHouseGUI;
import me.elaineqheart.auctionHouse.GUI.impl.CancelAuctionGUI;
import me.elaineqheart.auctionHouse.GUI.impl.CollectExpiredItemGUI;
import me.elaineqheart.auctionHouse.GUI.impl.CollectSoldItemGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.TaskManager;
import me.elaineqheart.auctionHouse.data.Permissions;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MyAuctionsGUI
extends InventoryGUI
implements Runnable {
    private final int currentPage;
    private final MySort currentSort;
    private final Player currentPlayer;
    private final UUID invID = UUID.randomUUID();

    @Override
    public void run() {
        this.decorate(this.currentPlayer);
    }

    public MyAuctionsGUI(int page, MySort sort, Player p) {
        this.currentPage = page;
        this.currentSort = sort;
        this.currentPlayer = p;
        TaskManager.addTaskID(this.invID, Bukkit.getScheduler().runTaskTimer((Plugin)AuctionHouse.getPlugin(), (Runnable)this, 0L, 20L).getTaskId());
    }

    public MyAuctionsGUI(Player p) {
        this.currentPage = 0;
        this.currentSort = MySort.ALL_AUCTIONS;
        this.currentPlayer = p;
        TaskManager.addTaskID(this.invID, Bukkit.getScheduler().runTaskTimer((Plugin)AuctionHouse.getPlugin(), (Runnable)this, 0L, 20L).getTaskId());
    }

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)54, (String)Messages.getFormatted("inventory-titles.my-auctions", new String[0]));
    }

    @Override
    public void decorate(Player player) {
        this.fillOutPlaces(new String[]{"# # # # # # # # #", "# . . . . . . . #", "# . . . . . . . #", "# . . . . . . . #", "# # # # # # # # #", ". . # # . # # # ."}, this.fillerItem());
        this.fillOutBarriers(this.currentPage, Permissions.getAuctionSlots(player));
        int auctionItems = this.fillOutItems(this.currentPage, this.currentSort, player.getUniqueId());
        this.addButton(45, this.back());
        this.addButton(46, this.sortButton(ItemManager.getMySort(this.currentSort)));
        this.addButton(49, this.refresh());
        if (Permissions.getAuctionSlots(player) > 21) {
            this.addButton(48, this.previousPage(auctionItems));
            this.addButton(50, this.nextPage(auctionItems));
        }
        this.addButton(53, this.info());
        super.decorate(player);
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        TaskManager.cancelTask(this.invID);
    }

    private int fillOutItems(int page, MySort sort, UUID playerID) {
        switch (sort.ordinal()) {
            case 0: {
                return this.fillOutAllAuctions(playerID, page);
            }
            case 1: {
                return this.fillOutSoldItems(playerID, page);
            }
            case 2: {
                return this.fillOutExpiredItems(playerID, page);
            }
            case 3: {
                return this.fillOutActiveAuctions(playerID, page);
            }
        }
        return 0;
    }

    private int fillOutAllAuctions(UUID id, int page) {
        LinkedHashMap<ItemNote, Long> myAuctions = new LinkedHashMap<ItemNote, Long>();
        LinkedHashMap<ItemNote, Long> sortedDateCreated = ItemNoteStorageUtil.mySortedDateCreated();
        for (ItemNote key : sortedDateCreated.keySet()) {
            if (Bukkit.getPlayer((UUID)key.getPlayerUUID()) != Bukkit.getPlayer((UUID)id)) continue;
            myAuctions.put(key, (Long)sortedDateCreated.get(key));
        }
        this.createButtonsForAuctionItems(myAuctions, page);
        return myAuctions.size();
    }

    private int fillOutSoldItems(UUID id, int page) {
        LinkedHashMap<ItemNote, Long> myAuctions = new LinkedHashMap<ItemNote, Long>();
        LinkedHashMap<ItemNote, Long> sortedDateCreated = ItemNoteStorageUtil.mySortedDateCreated();
        for (ItemNote key : sortedDateCreated.keySet()) {
            if (Bukkit.getPlayer((UUID)key.getPlayerUUID()) != Bukkit.getPlayer((UUID)id) || !key.isSold()) continue;
            myAuctions.put(key, (Long)sortedDateCreated.get(key));
        }
        this.createButtonsForAuctionItems(myAuctions, page);
        return myAuctions.size();
    }

    private int fillOutExpiredItems(UUID id, int page) {
        LinkedHashMap<ItemNote, Long> myAuctions = new LinkedHashMap<ItemNote, Long>();
        LinkedHashMap<ItemNote, Long> sortedDateCreated = ItemNoteStorageUtil.mySortedDateCreated();
        for (ItemNote key : sortedDateCreated.keySet()) {
            if (Bukkit.getPlayer((UUID)key.getPlayerUUID()) != Bukkit.getPlayer((UUID)id) || !key.isExpired() || key.isSold()) continue;
            myAuctions.put(key, (Long)sortedDateCreated.get(key));
        }
        this.createButtonsForAuctionItems(myAuctions, page);
        return myAuctions.size();
    }

    private int fillOutActiveAuctions(UUID id, int page) {
        LinkedHashMap<ItemNote, Long> myAuctions = new LinkedHashMap<ItemNote, Long>();
        LinkedHashMap<ItemNote, Long> sortedDateCreated = ItemNoteStorageUtil.mySortedDateCreated();
        for (ItemNote key : sortedDateCreated.keySet()) {
            if (Bukkit.getPlayer((UUID)key.getPlayerUUID()) != Bukkit.getPlayer((UUID)id) || key.isExpired() || key.isSold()) continue;
            myAuctions.put(key, (Long)sortedDateCreated.get(key));
        }
        this.createButtonsForAuctionItems(myAuctions, page);
        return myAuctions.size();
    }

    private void createButtonsForAuctionItems(LinkedHashMap<ItemNote, Long> myAuctions, int page) {
        int startPage = page * 21;
        int size = myAuctions.size();
        for (int i = startPage; i < startPage + 21 && size - 1 >= i; ++i) {
            Map.Entry entry = myAuctions.entrySet().stream().skip(size - i - 1).findFirst().orElse(null);
            if (entry == null) continue;
            int j = i % 21 + 10 + i % 21 / 7 + i % 21 / 7;
            this.addButton(j, this.auctionItem((ItemNote)entry.getKey()));
        }
    }

    private InventoryButton auctionItem(ItemNote note) {
        ItemStack item = ItemManager.createItemFromNote(note, this.currentPlayer);
        return new InventoryButton().creator(player -> item).consumer(event -> {
            Sounds.click(event);
            if (note.isSold()) {
                AuctionHouse.getGuiManager().openGUI(new CollectSoldItemGUI(note, this.currentSort), this.currentPlayer);
            } else if (note.isExpired()) {
                AuctionHouse.getGuiManager().openGUI(new CollectExpiredItemGUI(note, this.currentSort), this.currentPlayer);
            } else {
                AuctionHouse.getGuiManager().openGUI(new CancelAuctionGUI(note, this.currentSort), this.currentPlayer);
            }
        });
    }

    private void fillOutPlaces(String[] places, InventoryButton fillerItem) {
        for (int i = 0; i < places.length; ++i) {
            for (int j = 0; j < places[i].length(); j += 2) {
                if (places[i].charAt(j) != '#') continue;
                this.addButton(i * 9 + j / 2, fillerItem);
            }
        }
    }

    private void fillOutBarriers(int currentPage, int auctions) {
        int startPage = currentPage * 21 + 21;
        int barriers = startPage - auctions;
        for (int i = 0; i < barriers; ++i) {
            int j = 34 - i;
            int k = i / 7 * 2;
            this.addButton(j - k, this.barrier());
        }
    }

    private InventoryButton fillerItem() {
        return new InventoryButton().creator(player -> ItemManager.fillerItem).consumer(event -> {});
    }

    private InventoryButton barrier() {
        return new InventoryButton().creator(player -> ItemManager.lockedSlot).consumer(event -> {});
    }

    private InventoryButton refresh() {
        return new InventoryButton().creator(player -> ItemManager.refresh).consumer(event -> {
            Sounds.click(event);
            AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(this.currentPage, this.currentSort, this.currentPlayer), this.currentPlayer);
        });
    }

    private InventoryButton sortButton(ItemStack item) {
        return new InventoryButton().creator(player -> item).consumer(event -> {
            Sounds.click(event);
            if (event.isRightClick()) {
                AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(this.currentPage, this.previousSort(this.currentSort), this.currentPlayer), this.currentPlayer);
            } else {
                AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(this.currentPage, this.nextSort(this.currentSort), this.currentPlayer), this.currentPlayer);
            }
        });
    }

    private InventoryButton back() {
        return new InventoryButton().creator(player -> ItemManager.backToMainMenu).consumer(event -> {
            Sounds.closeEnderChest(event);
            AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(this.currentPlayer), this.currentPlayer);
        });
    }

    private InventoryButton info() {
        return new InventoryButton().creator(player -> ItemManager.info).consumer(event -> {});
    }

    private MySort nextSort(MySort input) {
        if (input.equals((Object)MySort.ALL_AUCTIONS)) {
            return MySort.SOLD_ITEMS;
        }
        if (input.equals((Object)MySort.SOLD_ITEMS)) {
            return MySort.EXPIRED_ITEMS;
        }
        if (input.equals((Object)MySort.EXPIRED_ITEMS)) {
            return MySort.ACTIVE_AUCTIONS;
        }
        return MySort.ALL_AUCTIONS;
    }

    private MySort previousSort(MySort input) {
        if (input.equals((Object)MySort.ACTIVE_AUCTIONS)) {
            return MySort.EXPIRED_ITEMS;
        }
        if (input.equals((Object)MySort.EXPIRED_ITEMS)) {
            return MySort.SOLD_ITEMS;
        }
        if (input.equals((Object)MySort.SOLD_ITEMS)) {
            return MySort.ALL_AUCTIONS;
        }
        return MySort.ACTIVE_AUCTIONS;
    }

    private InventoryButton nextPage(int auctionItemsAmount) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.next-page.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.next-page.lore", "%page%", String.valueOf(this.currentPage), "%pages%", String.valueOf(auctionItemsAmount / 21)));
        item.setItemMeta(meta);
        return new InventoryButton().creator(player -> item).consumer(event -> {
            Sounds.click(event);
            if (event.isRightClick()) {
                if (this.currentPage != auctionItemsAmount / 21) {
                    AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(auctionItemsAmount / 21, this.currentSort, this.currentPlayer), this.currentPlayer);
                }
            } else if (this.currentPage < auctionItemsAmount / 21) {
                AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(this.currentPage + 1, this.currentSort, this.currentPlayer), this.currentPlayer);
            }
        });
    }

    private InventoryButton previousPage(int auctionItemsAmount) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.previous-page.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.previous-page.lore", "%page%", String.valueOf(this.currentPage), "%pages%", String.valueOf(auctionItemsAmount / 21)));
        item.setItemMeta(meta);
        return new InventoryButton().creator(player -> item).consumer(event -> {
            Sounds.click(event);
            if (event.isRightClick()) {
                if (this.currentPage != 0) {
                    AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(0, this.currentSort, this.currentPlayer), this.currentPlayer);
                }
            } else if (this.currentPage > 0) {
                AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(this.currentPage - 1, this.currentSort, this.currentPlayer), this.currentPlayer);
            }
        });
    }

    public static enum MySort {
        ALL_AUCTIONS,
        SOLD_ITEMS,
        EXPIRED_ITEMS,
        ACTIVE_AUCTIONS;

    }
}

