/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.impl;

import java.io.IOException;
import me.elaineqheart.auctionHouse.GUI.InventoryButton;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.data.StringUtils;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import me.elaineqheart.auctionHouse.data.yml.SettingManager;
import me.elaineqheart.auctionHouse.vault.VaultHook;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ConfirmBuyGUI
extends InventoryGUI {
    private final ItemNote note;

    public ConfirmBuyGUI(ItemNote note) {
        this.note = note;
    }

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)27, (String)Messages.getFormatted("inventory-titles.auction-house", new String[0]));
    }

    @Override
    public void decorate(Player player) {
        this.fillOutPlaces(new String[]{"# # # # # # # # #", "# # . # . # . # #", "# # # # # # # # #"}, this.fillerItem());
        this.addButton(11, this.confirm());
        this.addButton(13, this.buyingItem());
        this.addButton(15, this.cancel());
        super.decorate(player);
    }

    private void fillOutPlaces(String[] places, InventoryButton fillerItem) {
        for (int i = 0; i < places.length; ++i) {
            for (int j = 0; j < places[i].length(); j += 2) {
                if (places[i].charAt(j) != '#') continue;
                this.addButton(i * 9 + j / 2, fillerItem);
            }
        }
    }

    private InventoryButton fillerItem() {
        return new InventoryButton().creator(player -> ItemManager.fillerItem).consumer(event -> {});
    }

    private InventoryButton buyingItem() {
        return new InventoryButton().creator(player -> ItemManager.createBuyingItemDisplay(this.note)).consumer(event -> {});
    }

    private InventoryButton confirm() {
        return new InventoryButton().creator(player -> ItemManager.createConfirm(StringUtils.formatNumber(this.note.getPrice()))).consumer(event -> {
            Player p = (Player)event.getWhoClicked();
            if (p.getInventory().firstEmpty() == -1) {
                p.sendMessage(Messages.getFormatted("chat.inventory-full", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            if (this.note.isSold()) {
                p.sendMessage(Messages.getFormatted("chat.already-sold2", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            if (ItemNoteStorageUtil.noteDoesNotExist(this.note)) {
                p.sendMessage(Messages.getFormatted("chat.non-existent2", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            Economy eco = VaultHook.getEconomy();
            double price = this.note.getPrice();
            p.closeInventory();
            if (!this.note.canAfford(eco.getBalance((OfflinePlayer)p))) {
                p.sendMessage(Messages.getFormatted("chat.not-enough-money", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            eco.withdrawPlayer((OfflinePlayer)p, price);
            Sounds.experience(event);
            p.getInventory().addItem(new ItemStack[]{this.note.getItem()});
            this.note.setSold(true);
            this.note.setBuyerName(p.getName());
            try {
                ItemNoteStorageUtil.saveNotes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            p.sendMessage(Messages.getFormatted("chat.purchase-auction", "%player%", this.note.getPlayerName()));
            Player seller = Bukkit.getPlayer((String)this.note.getPlayerName());
            if (SettingManager.soldMessageEnabled && seller != null && Bukkit.getOnlinePlayers().contains(seller)) {
                TextComponent component = new TextComponent(Messages.getFormatted("chat.sold-message.prefix", "%player%", p.getName(), "%item%", StringUtils.getItemName(this.note.getItem(), p.getWorld()), "%price%", StringUtils.formatPrice(price)));
                TextComponent click = new TextComponent(Messages.getFormatted("chat.sold-message.interaction", new String[0]));
                click.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ah view " + this.note.getNoteID().toString()));
                seller.spigot().sendMessage(new BaseComponent[]{component, click});
            }
        });
    }

    private InventoryButton cancel() {
        return new InventoryButton().creator(player -> ItemManager.cancel).consumer(event -> {
            Sounds.click(event);
            event.getWhoClicked().closeInventory();
        });
    }
}

