/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.impl;

import java.io.IOException;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.InventoryButton;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.impl.MyAuctionsGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CollectExpiredItemGUI
extends InventoryGUI {
    private final ItemNote note;
    private final MyAuctionsGUI.MySort currentSort;

    public CollectExpiredItemGUI(ItemNote note, MyAuctionsGUI.MySort sort) {
        this.note = note;
        this.currentSort = sort;
    }

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)54, (String)Messages.getFormatted("inventory-titles.collect-expired", new String[0]));
    }

    @Override
    public void decorate(Player player) {
        this.fillOutPlaces(new String[]{"# # # # # # # # #", "# # # # . # # # #", "# # # # # # # # #", "# # # # . # # # #", "# # # # # # # # #", "# # # # . # # # #"}, this.fillerItem());
        this.addButton(13, this.Item());
        this.addButton(31, this.collectItem());
        this.addButton(49, this.back());
        super.decorate(player);
    }

    private void fillOutPlaces(String[] places, InventoryButton fillerItem) {
        for (int i = 0; i < places.length; ++i) {
            for (int j = 0; j < places[i].length(); j += 2) {
                if (places[i].charAt(j) != '#') continue;
                this.addButton(i * 9 + j / 2, fillerItem);
            }
        }
    }

    private InventoryButton fillerItem() {
        return new InventoryButton().creator(player -> ItemManager.fillerItem).consumer(event -> {});
    }

    private InventoryButton Item() {
        return new InventoryButton().creator(player -> ItemManager.createItemFromNote(this.note, player)).consumer(Sounds::click);
    }

    private InventoryButton back() {
        return new InventoryButton().creator(player -> ItemManager.backToMyAuctions).consumer(event -> {
            Player p = (Player)event.getWhoClicked();
            Sounds.click(event);
            AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(0, this.currentSort, p), p);
        });
    }

    private InventoryButton collectItem() {
        return new InventoryButton().creator(player -> ItemManager.collectExpiredItem).consumer(event -> {
            Player p = (Player)event.getWhoClicked();
            if (p.getInventory().firstEmpty() == -1) {
                p.sendMessage(Messages.getFormatted("chat.inventory-full", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            Sounds.experience(event);
            if (this.note.getAdminMessage() != null) {
                if (this.note.getItem().equals((Object)ItemManager.createDirt())) {
                    p.sendMessage(Messages.getFormatted("chat.deleted-auction-by-admin", "%reason%", this.note.getAdminMessage()));
                    p.closeInventory();
                } else {
                    p.sendMessage(Messages.getFormatted("chat.expired-auction-by-admin", "%reason%", this.note.getAdminMessage()));
                    p.getInventory().addItem(new ItemStack[]{this.note.getItem()});
                    ItemNoteStorageUtil.deleteNote(this.note);
                    p.closeInventory();
                }
            } else {
                p.getInventory().addItem(new ItemStack[]{this.note.getItem()});
                ItemNoteStorageUtil.deleteNote(this.note);
                Bukkit.getScheduler().runTaskLater((Plugin)AuctionHouse.getPlugin(), () -> AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(0, this.currentSort, p), p), 1L);
            }
            try {
                ItemNoteStorageUtil.saveNotes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

