/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.impl;

import java.util.UUID;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.InventoryButton;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionHouseGUI;
import me.elaineqheart.auctionHouse.GUI.impl.ConfirmBuyGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.TaskManager;
import me.elaineqheart.auctionHouse.data.StringUtils;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import me.elaineqheart.auctionHouse.vault.VaultHook;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class AuctionViewGUI
extends InventoryGUI
implements Runnable {
    private final ItemNote note;
    private final Player currentPlayer;
    private final UUID invID = UUID.randomUUID();

    @Override
    public void run() {
        this.decorate(this.currentPlayer);
    }

    public AuctionViewGUI(ItemNote note, Player player) {
        this.note = note;
        this.currentPlayer = player;
        TaskManager.addTaskID(this.invID, Bukkit.getScheduler().runTaskTimer((Plugin)AuctionHouse.getPlugin(), (Runnable)this, 0L, 20L).getTaskId());
    }

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)54, (String)Messages.getFormatted("inventory-titles.auction-house", new String[0]));
    }

    @Override
    public void decorate(Player player) {
        this.fillOutPlaces(new String[]{"# # # # # # # # #", "# # # # . # # # #", "# # # # # # # # #", "# # # # . # # # #", "# # # # # # # # #", "# # # # . # # # #"}, this.fillerItem());
        this.addButton(13, this.buyingItem());
        if (this.note.canAfford(VaultHook.getEconomy().getBalance((OfflinePlayer)player))) {
            this.addButton(31, this.turtleScute());
        } else {
            this.addButton(31, this.armadilloScute());
        }
        this.addButton(49, this.back());
        super.decorate(player);
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        TaskManager.cancelTask(this.invID);
    }

    private void fillOutPlaces(String[] places, InventoryButton fillerItem) {
        for (int i = 0; i < places.length; ++i) {
            for (int j = 0; j < places[i].length(); j += 2) {
                if (places[i].charAt(j) != '#') continue;
                this.addButton(i * 9 + j / 2, fillerItem);
            }
        }
    }

    private InventoryButton fillerItem() {
        return new InventoryButton().creator(player -> ItemManager.fillerItem).consumer(event -> {});
    }

    private InventoryButton buyingItem() {
        return new InventoryButton().creator(player -> ItemManager.createItemFromNote(this.note, player)).consumer(event -> {});
    }

    private InventoryButton back() {
        return new InventoryButton().creator(player -> ItemManager.backToMainMenu).consumer(event -> {
            Player p = (Player)event.getWhoClicked();
            Sounds.click(event);
            AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(p), p);
        });
    }

    private InventoryButton armadilloScute() {
        return new InventoryButton().creator(player -> ItemManager.createArmadilloScute(StringUtils.formatNumber(this.note.getPrice()))).consumer(Sounds::villagerDeny);
    }

    private InventoryButton turtleScute() {
        return new InventoryButton().creator(player -> ItemManager.createTurtleScute(StringUtils.formatNumber(this.note.getPrice()))).consumer(event -> {
            Sounds.click(event);
            if (this.note.getPlayerName().equals(event.getWhoClicked().getName())) {
                event.getWhoClicked().sendMessage(Messages.getFormatted("chat.own-auction", new String[0]));
                return;
            }
            AuctionHouse.getGuiManager().openGUI(new ConfirmBuyGUI(this.note), (Player)event.getWhoClicked());
        });
    }
}

