/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.InventoryButton;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.impl.AdminManageItemGUI;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionViewGUI;
import me.elaineqheart.auctionHouse.GUI.impl.MyAuctionsGUI;
import me.elaineqheart.auctionHouse.GUI.impl.ShulkerViewGUI;
import me.elaineqheart.auctionHouse.GUI.other.AnvilSearchGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.TaskManager;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AuctionHouseGUI
extends InventoryGUI
implements Runnable {
    private final int currentPage;
    private final Sort currentSort;
    private final String currentSearch;
    private final Player currentPlayer;
    private final UUID invID = UUID.randomUUID();
    private final boolean isAdmin;

    @Override
    public void run() {
        this.decorate(this.currentPlayer);
    }

    public AuctionHouseGUI(int page, Sort sort, String search, Player p, boolean isAdmin) {
        this.currentPage = page;
        this.currentSort = sort;
        this.currentSearch = search;
        this.currentPlayer = p;
        this.isAdmin = isAdmin;
        TaskManager.addTaskID(this.invID, Bukkit.getScheduler().runTaskTimer((Plugin)AuctionHouse.getPlugin(), (Runnable)this, 0L, 20L).getTaskId());
    }

    public AuctionHouseGUI(Player p) {
        this.currentPage = 0;
        this.currentSort = Sort.HIGHEST_PRICE;
        this.currentSearch = "";
        this.currentPlayer = p;
        this.isAdmin = false;
        TaskManager.addTaskID(this.invID, Bukkit.getScheduler().runTaskTimer((Plugin)AuctionHouse.getPlugin(), (Runnable)this, 0L, 20L).getTaskId());
    }

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)54, (String)Messages.getFormatted("inventory-titles.auction-house", new String[0]));
    }

    @Override
    public void decorate(Player player) {
        this.fillOutPlaces(new String[]{"# # # # # # # # #", "# . . . . . . . #", "# . . . . . . . #", "# . . . . . . . #", "# # # # # # # # #", ". . # . . . # # ."});
        this.fillOutItems(this.currentPage, this.currentSort);
        this.addButton(45, this.searchOption());
        this.addButton(46, this.sortButton(ItemManager.getSort(this.currentSort)));
        this.addButton(48, this.previousPage());
        this.addButton(49, this.refresh());
        this.addButton(50, this.nextPage());
        if (!this.isAdmin) {
            this.addButton(53, this.myAuctions());
        } else {
            this.addButton(53, this.commandBlockInfo());
        }
        super.decorate(player);
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        TaskManager.cancelTask(this.invID);
    }

    private void fillOutItems(int page, Sort sort) {
        switch (sort.ordinal()) {
            case 0: {
                this.fillOutAuctionItemsHighestPrice(page);
                break;
            }
            case 1: {
                this.fillOutAuctionItemsLowestPrice(page);
                break;
            }
            case 2: {
                this.fillOutAuctionItemsEndingSoon(page);
                break;
            }
            case 3: {
                this.fillOutAuctionItemsAlphabetical(page);
            }
        }
    }

    private void fillOutAuctionItemsHighestPrice(int page) {
        int startPage = page * 21;
        LinkedHashMap<ItemNote, Integer> sortedHighestPrice = ItemNoteStorageUtil.sortedHighestPrice();
        if (!this.currentSearch.isEmpty()) {
            sortedHighestPrice = ItemNoteStorageUtil.hiPrSearch(this.currentSearch);
        }
        int size = sortedHighestPrice.size();
        for (int i = startPage; i < startPage + 21 && size - 1 >= i; ++i) {
            Map.Entry entry = sortedHighestPrice.entrySet().stream().skip(size - i - 1).findFirst().orElse(null);
            if (entry == null) continue;
            int j = i % 21 + 10 + i % 21 / 7 + i % 21 / 7;
            this.addButton(j, this.auctionItem((ItemNote)entry.getKey()));
        }
    }

    private void fillOutAuctionItemsLowestPrice(int page) {
        int startPage = page * 21;
        LinkedHashMap<ItemNote, Integer> sortedHighestPrice = ItemNoteStorageUtil.sortedHighestPrice();
        if (!this.currentSearch.isEmpty()) {
            sortedHighestPrice = ItemNoteStorageUtil.hiPrSearch(this.currentSearch);
        }
        int size = sortedHighestPrice.size();
        for (int i = startPage; i < startPage + 21 && size - 1 >= i; ++i) {
            Map.Entry entry = sortedHighestPrice.entrySet().stream().skip(i).findFirst().orElse(null);
            if (entry == null) continue;
            int j = i % 21 + 10 + i % 21 / 7 + i % 21 / 7;
            this.addButton(j, this.auctionItem((ItemNote)entry.getKey()));
        }
    }

    private void fillOutAuctionItemsEndingSoon(int page) {
        int startPage = page * 21;
        LinkedHashMap<ItemNote, Long> sortedDateCreated = ItemNoteStorageUtil.sortedDateCreated();
        if (!this.currentSearch.isEmpty()) {
            sortedDateCreated = ItemNoteStorageUtil.dateSearch(this.currentSearch);
        }
        int size = sortedDateCreated.size();
        for (int i = startPage; i < startPage + 21 && size - 1 >= i; ++i) {
            Map.Entry entry = sortedDateCreated.entrySet().stream().skip(i).findFirst().orElse(null);
            if (entry == null) continue;
            int j = i % 21 + 10 + i % 21 / 7 + i % 21 / 7;
            this.addButton(j, this.auctionItem((ItemNote)entry.getKey()));
        }
    }

    private void fillOutAuctionItemsAlphabetical(int page) {
        int startPage = page * 21;
        LinkedHashMap<ItemNote, String> sortedAlphabetical = ItemNoteStorageUtil.sortedAlphabetical();
        if (!this.currentSearch.isEmpty()) {
            sortedAlphabetical = ItemNoteStorageUtil.alphaSearch(this.currentSearch);
        }
        int size = sortedAlphabetical.size();
        for (int i = startPage; i < startPage + 21 && size - 1 >= i; ++i) {
            Map.Entry entry = sortedAlphabetical.entrySet().stream().skip(i).findFirst().orElse(null);
            if (entry == null) continue;
            int j = i % 21 + 10 + i % 21 / 7 + i % 21 / 7;
            this.addButton(j, this.auctionItem((ItemNote)entry.getKey()));
        }
    }

    private InventoryButton auctionItem(ItemNote note) {
        ItemStack item = ItemManager.createItemFromNote(note, this.currentPlayer);
        return new InventoryButton().creator(player -> item).consumer(event -> {
            if (ItemManager.isShulkerBox(item) && event.isRightClick()) {
                Sounds.openShulker(event);
                AuctionHouse.getGuiManager().openGUI(new ShulkerViewGUI(note, this.currentPage, this.currentSort, this.currentSearch, this.isAdmin), this.currentPlayer);
                return;
            }
            Sounds.click(event);
            if (!Objects.equals(Bukkit.getPlayer((UUID)note.getPlayerUUID()), this.currentPlayer)) {
                if (this.isAdmin) {
                    AuctionHouse.getGuiManager().openGUI(new AdminManageItemGUI(note, this.currentPlayer), this.currentPlayer);
                } else {
                    AuctionHouse.getGuiManager().openGUI(new AuctionViewGUI(note, this.currentPlayer), this.currentPlayer);
                }
            }
        });
    }

    private void fillOutPlaces(String[] places) {
        for (int i = 0; i < places.length; ++i) {
            for (int j = 0; j < places[i].length(); j += 2) {
                if (places[i].charAt(j) != '#') continue;
                this.addButton(i * 9 + j / 2, this.fillerItem());
            }
        }
    }

    private InventoryButton fillerItem() {
        return new InventoryButton().creator(player -> ItemManager.fillerItem).consumer(event -> {});
    }

    private InventoryButton commandBlockInfo() {
        return new InventoryButton().creator(player -> ItemManager.commandBlockInfo).consumer(event -> {});
    }

    private InventoryButton refresh() {
        return new InventoryButton().creator(player -> ItemManager.refresh).consumer(event -> {
            AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(this.currentPage, this.currentSort, this.currentSearch, this.currentPlayer, this.isAdmin), this.currentPlayer);
            Sounds.click(event);
        });
    }

    private InventoryButton nextPage() {
        List<ItemNote> notes = ItemNoteStorageUtil.findAllNotes();
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.next-page.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.next-page.lore", "%page%", String.valueOf(this.currentPage), "%pages%", String.valueOf(notes.size() / 21)));
        item.setItemMeta(meta);
        return new InventoryButton().creator(player -> item).consumer(event -> {
            Sounds.click(event);
            if (event.isRightClick()) {
                if (this.currentPage != notes.size() / 21) {
                    AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(notes.size() / 21, this.currentSort, this.currentSearch, this.currentPlayer, this.isAdmin), this.currentPlayer);
                }
            } else if (this.currentPage < notes.size() / 21) {
                AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(this.currentPage + 1, this.currentSort, this.currentSearch, this.currentPlayer, this.isAdmin), this.currentPlayer);
            }
        });
    }

    private InventoryButton previousPage() {
        List<ItemNote> notes = ItemNoteStorageUtil.findAllNotes();
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.previous-page.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.previous-page.lore", "%page%", String.valueOf(this.currentPage), "%pages%", String.valueOf(notes.size() / 21)));
        item.setItemMeta(meta);
        return new InventoryButton().creator(player -> item).consumer(event -> {
            Sounds.click(event);
            if (event.isRightClick()) {
                if (this.currentPage != 0) {
                    AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(0, this.currentSort, this.currentSearch, this.currentPlayer, this.isAdmin), this.currentPlayer);
                }
            } else if (this.currentPage > 0) {
                AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(this.currentPage - 1, this.currentSort, this.currentSearch, this.currentPlayer, this.isAdmin), this.currentPlayer);
            }
        });
    }

    private InventoryButton searchOption() {
        ItemStack item = new ItemStack(Material.OAK_SIGN);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setItemName(Messages.getFormatted("items.search.name", new String[0]));
        meta.setLore(Messages.getLoreList("items.search.lore", "%filter%", this.currentSearch));
        item.setItemMeta(meta);
        return new InventoryButton().creator(player -> item).consumer(event -> {
            if (event.isRightClick()) {
                Sounds.breakWood(event);
                AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(this.currentPage, this.currentSort, "", this.currentPlayer, this.isAdmin), this.currentPlayer);
            } else {
                Sounds.click(event);
                if (this.isAdmin) {
                    new AnvilSearchGUI((Player)event.getWhoClicked(), AnvilSearchGUI.SearchType.ADMIN_AH, null);
                } else {
                    new AnvilSearchGUI((Player)event.getWhoClicked(), AnvilSearchGUI.SearchType.AH, null);
                }
            }
        });
    }

    private InventoryButton sortButton(ItemStack item) {
        return new InventoryButton().creator(player -> item).consumer(event -> {
            Sounds.click(event);
            if (event.isRightClick()) {
                AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(this.currentPage, this.previousSort(this.currentSort), this.currentSearch, this.currentPlayer, this.isAdmin), this.currentPlayer);
            } else {
                AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(this.currentPage, this.nextSort(this.currentSort), this.currentSearch, this.currentPlayer, this.isAdmin), this.currentPlayer);
            }
        });
    }

    private InventoryButton myAuctions() {
        return new InventoryButton().creator(player -> ItemManager.myAuction).consumer(event -> {
            Sounds.openEnderChest(event);
            AuctionHouse.getGuiManager().openGUI(new MyAuctionsGUI(this.currentPlayer), (Player)event.getWhoClicked());
        });
    }

    private Sort nextSort(Sort input) {
        if (input.equals((Object)Sort.HIGHEST_PRICE)) {
            return Sort.LOWEST_PRICE;
        }
        if (input.equals((Object)Sort.LOWEST_PRICE)) {
            return Sort.ENDING_SOON;
        }
        if (input.equals((Object)Sort.ENDING_SOON)) {
            return Sort.ALPHABETICAL;
        }
        return Sort.HIGHEST_PRICE;
    }

    private Sort previousSort(Sort input) {
        if (input.equals((Object)Sort.ALPHABETICAL)) {
            return Sort.ENDING_SOON;
        }
        if (input.equals((Object)Sort.ENDING_SOON)) {
            return Sort.LOWEST_PRICE;
        }
        if (input.equals((Object)Sort.LOWEST_PRICE)) {
            return Sort.HIGHEST_PRICE;
        }
        return Sort.ALPHABETICAL;
    }

    public static enum Sort {
        HIGHEST_PRICE,
        LOWEST_PRICE,
        ENDING_SOON,
        ALPHABETICAL;

    }
}

