/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.impl;

import java.util.UUID;
import me.elaineqheart.auctionHouse.AuctionHouse;
import me.elaineqheart.auctionHouse.GUI.InventoryButton;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.impl.AuctionHouseGUI;
import me.elaineqheart.auctionHouse.GUI.other.AnvilSearchGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.TaskManager;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class AdminManageItemGUI
extends InventoryGUI
implements Runnable {
    private final ItemNote note;
    private final Player currentPlayer;
    private final UUID invID = UUID.randomUUID();

    @Override
    public void run() {
        this.decorate(this.currentPlayer);
    }

    public AdminManageItemGUI(ItemNote note, Player p) {
        this.note = note;
        this.currentPlayer = p;
        TaskManager.addTaskID(this.invID, Bukkit.getScheduler().runTaskTimer((Plugin)AuctionHouse.getPlugin(), (Runnable)this, 0L, 20L).getTaskId());
    }

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)54, (String)Messages.getFormatted("inventory-titles.admin-menu", new String[0]));
    }

    @Override
    public void decorate(Player player) {
        this.fillOutPlaces(new String[]{"# # # # # # # # #", "# # # # . # # # #", "# # # # # # # # #", "# # # . # . # # #", "# # # # # # # # #", "# # # # . # # # #"}, this.fillerItem());
        this.addButton(13, this.item());
        this.addButton(30, this.expireAuction());
        this.addButton(32, this.deleteAuction());
        this.addButton(49, this.back());
        super.decorate(player);
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        TaskManager.cancelTask(this.invID);
    }

    private void fillOutPlaces(String[] places, InventoryButton fillerItem) {
        for (int i = 0; i < places.length; ++i) {
            for (int j = 0; j < places[i].length(); j += 2) {
                if (places[i].charAt(j) != '#') continue;
                this.addButton(i * 9 + j / 2, fillerItem);
            }
        }
    }

    private InventoryButton fillerItem() {
        return new InventoryButton().creator(player -> ItemManager.fillerItem).consumer(event -> {});
    }

    private InventoryButton item() {
        return new InventoryButton().creator(player -> ItemManager.createItemFromNote(this.note, player)).consumer(event -> {});
    }

    private InventoryButton back() {
        return new InventoryButton().creator(player -> ItemManager.backToMainMenu).consumer(event -> {
            Player p = (Player)event.getWhoClicked();
            Sounds.click(event);
            AuctionHouse.getGuiManager().openGUI(new AuctionHouseGUI(0, AuctionHouseGUI.Sort.HIGHEST_PRICE, "", this.currentPlayer, true), p);
        });
    }

    private InventoryButton deleteAuction() {
        return new InventoryButton().creator(player -> ItemManager.adminCancelAuction).consumer(event -> {
            Sounds.click(event);
            new AnvilSearchGUI(this.currentPlayer, AnvilSearchGUI.SearchType.ITEM_DELETE_MESSAGE, this.note);
        });
    }

    private InventoryButton expireAuction() {
        return new InventoryButton().creator(player -> ItemManager.adminExpireAuction).consumer(event -> {
            Sounds.click(event);
            new AnvilSearchGUI(this.currentPlayer, AnvilSearchGUI.SearchType.ITEM_EXPIRE_MESSAGE, this.note);
        });
    }
}

