/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI.impl;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import me.elaineqheart.auctionHouse.GUI.InventoryButton;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.other.AnvilSearchGUI;
import me.elaineqheart.auctionHouse.GUI.other.Sounds;
import me.elaineqheart.auctionHouse.data.items.ItemManager;
import me.elaineqheart.auctionHouse.data.items.ItemNote;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AdminConfirmGUI
extends InventoryGUI {
    private final ItemNote note;
    private final String reason;
    private final AnvilSearchGUI.SearchType type;

    public AdminConfirmGUI(String reason, ItemNote note, AnvilSearchGUI.SearchType type) {
        this.note = note;
        this.reason = reason;
        this.type = type;
    }

    @Override
    protected Inventory createInventory() {
        return Bukkit.createInventory(null, (int)27, (String)Messages.getFormatted("inventory-titles.admin-confirm-gui", new String[0]));
    }

    @Override
    public void decorate(Player player) {
        this.fillOutPlaces(new String[]{"# # # # # # # # #", "# # . # . # . # #", "# # # # # # # # #"}, this.fillerItem());
        if (this.type == AnvilSearchGUI.SearchType.ITEM_EXPIRE_MESSAGE) {
            this.addButton(11, this.confirmExpireItem());
            this.addButton(13, this.expireItem());
        } else if (this.type == AnvilSearchGUI.SearchType.ITEM_DELETE_MESSAGE) {
            this.addButton(11, this.confirmDeleteItem());
            this.addButton(13, this.deleteItem());
        }
        this.addButton(15, this.cancel());
        super.decorate(player);
    }

    private void fillOutPlaces(String[] places, InventoryButton fillerItem) {
        for (int i = 0; i < places.length; ++i) {
            for (int j = 0; j < places[i].length(); j += 2) {
                if (places[i].charAt(j) != '#') continue;
                this.addButton(i * 9 + j / 2, fillerItem);
            }
        }
    }

    private InventoryButton fillerItem() {
        return new InventoryButton().creator(player -> ItemManager.fillerItem).consumer(event -> {});
    }

    private InventoryButton deleteItem() {
        return new InventoryButton().creator(player -> ItemManager.createAdminDeleteItem(this.note, this.reason)).consumer(event -> {});
    }

    private InventoryButton expireItem() {
        return new InventoryButton().creator(player -> ItemManager.createAdminExpireItem(this.note, this.reason)).consumer(event -> {});
    }

    private InventoryButton confirmExpireItem() {
        return new InventoryButton().creator(player -> ItemManager.confirm).consumer(event -> {
            Player p = (Player)event.getWhoClicked();
            if (this.note.isSold()) {
                p.sendMessage(Messages.getFormatted("chat.already-sold", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            if (ItemNoteStorageUtil.noteDoesNotExist(this.note)) {
                p.sendMessage(Messages.getFormatted("chat.non-existent", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            Sounds.experience(event);
            Sounds.breakWood(event);
            p.closeInventory();
            Date expireDate = new GregorianCalendar(2000, 0, 1).getTime();
            this.note.setDateCreated(expireDate);
            this.note.setAdminMessage(this.reason);
            try {
                ItemNoteStorageUtil.saveNotes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            p.sendMessage(Messages.getFormatted("chat.admin-expire-auction", "%reason%", this.note.getAdminMessage()));
        });
    }

    private InventoryButton confirmDeleteItem() {
        return new InventoryButton().creator(player -> ItemManager.confirm).consumer(event -> {
            Player p = (Player)event.getWhoClicked();
            if (p.getInventory().firstEmpty() == -1) {
                p.sendMessage(Messages.getFormatted("chat.inventory-full", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            if (this.note.isSold()) {
                p.sendMessage(Messages.getFormatted("chat.already-sold", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            if (ItemNoteStorageUtil.noteDoesNotExist(this.note)) {
                p.sendMessage(Messages.getFormatted("chat.non-existent", new String[0]));
                Sounds.villagerDeny(event);
                return;
            }
            p.closeInventory();
            p.getInventory().addItem(new ItemStack[]{this.note.getItem()});
            Sounds.experience(event);
            Sounds.breakWood(event);
            Date expireDate = new GregorianCalendar(2000, 0, 1).getTime();
            this.note.setDateCreated(expireDate);
            this.note.setAdminMessage(this.reason);
            this.note.setItem(ItemManager.createDirt());
            try {
                ItemNoteStorageUtil.saveNotes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            p.sendMessage(Messages.getFormatted("chat.admin-delete-auction", "%reason%", this.note.getAdminMessage()));
        });
    }

    private InventoryButton cancel() {
        return new InventoryButton().creator(player -> ItemManager.cancel).consumer(event -> {
            Sounds.click(event);
            event.getWhoClicked().closeInventory();
        });
    }
}

