/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse.GUI;

import java.util.HashMap;
import java.util.Map;
import me.elaineqheart.auctionHouse.GUI.InventoryGUI;
import me.elaineqheart.auctionHouse.GUI.InventoryHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;

public class GUIManager {
    private final Map<Inventory, InventoryHandler> activeInventories = new HashMap<Inventory, InventoryHandler>();

    public void openGUI(InventoryGUI gui, Player player) {
        this.registerHandledInventory(gui.getInventory(), gui);
        player.openInventory(gui.getInventory());
    }

    public void registerHandledInventory(Inventory inventory, InventoryHandler handler) {
        this.activeInventories.put(inventory, handler);
    }

    public void unregisterInventory(Inventory inventory) {
        this.activeInventories.remove(inventory);
    }

    public void handleClick(InventoryClickEvent event) {
        InventoryHandler handler = this.activeInventories.get(event.getInventory());
        if (handler == null) {
            return;
        }
        if (event.getCurrentItem() != null && event.getCurrentItem().getType() == Material.PAPER && event.getSlot() == 2) {
            return;
        }
        handler.onClick(event);
    }

    public void handleOpen(InventoryOpenEvent event) {
        InventoryHandler handler = this.activeInventories.get(event.getInventory());
        if (handler != null) {
            handler.onOpen(event);
        }
    }

    public void handleClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHandler handler = this.activeInventories.get(inventory);
        if (handler != null) {
            handler.onClose(event);
            this.unregisterInventory(inventory);
        }
    }

    public void forceCloseAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.activeInventories.containsKey(player.getOpenInventory().getTopInventory())) continue;
            player.closeInventory();
        }
    }
}

