/*
 * Decompiled with CFR 0.152.
 */
package me.elaineqheart.auctionHouse;

import java.io.IOException;
import me.elaineqheart.auctionHouse.GUI.GUIListener;
import me.elaineqheart.auctionHouse.GUI.GUIManager;
import me.elaineqheart.auctionHouse.GUI.other.AnvilGUIListener;
import me.elaineqheart.auctionHouse.commands.AuctionHouseCommands;
import me.elaineqheart.auctionHouse.data.items.ItemNoteStorageUtil;
import me.elaineqheart.auctionHouse.data.yml.ConfigManager;
import me.elaineqheart.auctionHouse.data.yml.Messages;
import me.elaineqheart.auctionHouse.world.displays.DisplayListener;
import me.elaineqheart.auctionHouse.world.displays.UpdateDisplay;
import me.elaineqheart.auctionHouse.world.npc.NPCListener;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class AuctionHouse
extends JavaPlugin {
    private static AuctionHouse instance;
    private static GUIManager guiManager;

    public static AuctionHouse getPlugin() {
        return instance;
    }

    public static GUIManager getGuiManager() {
        return guiManager;
    }

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        guiManager = new GUIManager();
        GUIListener guiListener = new GUIListener(guiManager);
        Bukkit.getPluginManager().registerEvents((Listener)guiListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AnvilGUIListener(), (Plugin)this);
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            Bukkit.getLogger().severe("No registered Vault provider found!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.getCommand("ah").setExecutor((CommandExecutor)new AuctionHouseCommands());
        this.getCommand("ah").setTabCompleter((TabCompleter)new AuctionHouseCommands());
        Bukkit.getPluginManager().registerEvents((Listener)new NPCListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DisplayListener(), (Plugin)this);
        this.reloadConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        ConfigManager.setupConfigs();
        Messages.setup();
        Messages.get().options().copyDefaults(true);
        Messages.save();
        try {
            ItemNoteStorageUtil.loadNotes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        UpdateDisplay.init();
        this.getLogger().info("AuctionHouse enabled in " + (System.currentTimeMillis() - start) + "ms");
    }

    public void onDisable() {
        guiManager.forceCloseAll();
    }
}

