/*
 * Decompiled with CFR 0.152.
 */
package dev.echonine.kite;

import com.google.gson.Gson;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.annotations.NotNull;

public final class PluginLibrariesLoader
implements PluginLoader {
    public void classloader(@NotNull PluginClasspathBuilder classpathBuilder) throws IllegalStateException {
        MavenLibraryResolver resolver = new MavenLibraryResolver();
        try (InputStream in = this.getClass().getResourceAsStream("/paper-libraries.json");){
            PluginLibraries libraries = (PluginLibraries)new Gson().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), PluginLibraries.class);
            libraries.asRepositories().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addRepository(arg_0));
            libraries.asDependencies().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addDependency(arg_0));
            classpathBuilder.addLibrary((ClassPathLibrary)resolver);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private record PluginLibraries(Map<String, String> repositories, List<String> dependencies) {
        public Stream<RemoteRepository> asRepositories() {
            return this.repositories.entrySet().stream().map(entry -> {
                try {
                    String MAVEN_CENTRAL_DEFAULT_MIRROR = (String)MavenLibraryResolver.class.getField("MAVEN_CENTRAL_DEFAULT_MIRROR").get(null);
                    if (((String)entry.getValue()).contains("maven.org") || ((String)entry.getValue()).contains("maven.apache.org")) {
                        return new RemoteRepository.Builder((String)entry.getKey(), "default", MAVEN_CENTRAL_DEFAULT_MIRROR).build();
                    }
                    return new RemoteRepository.Builder((String)entry.getKey(), "default", (String)entry.getValue()).build();
                }
                catch (IllegalAccessException | NoSuchFieldError | NoSuchFieldException e) {
                    return new RemoteRepository.Builder((String)entry.getKey(), "default", "https://maven-central.storage-download.googleapis.com/maven2").build();
                }
            });
        }

        public Stream<Dependency> asDependencies() {
            return this.dependencies.stream().map(value -> new Dependency((Artifact)new DefaultArtifact(value), null));
        }
    }
}

