/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iotrails;

import com.interordi.iotrails.IOTrails;
import com.interordi.iotrails.Trail;
import com.interordi.iotrails.Trails;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class Players {
    private static Map<UUID, Trail> activeTrails;
    private static IOTrails plugin;

    public static void init(IOTrails plugin) {
        Players.plugin = plugin;
        activeTrails = new HashMap<UUID, Trail>();
    }

    public static void add(Player player) {
        if (!player.hasPermission("iotrails.enable")) {
            return;
        }
        final UUID uuid = player.getUniqueId();
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                String trailName = plugin.db.getPlayerTrail(uuid);
                Trail trail = Trails.get(trailName);
                if (trail != null) {
                    activeTrails.put(uuid, trail);
                }
            }
        });
    }

    public static void remove(Player player) {
        activeTrails.remove(player.getUniqueId());
    }

    public static void move(Player player) {
        Particle particle;
        Trail trail = activeTrails.get(player.getUniqueId());
        if (trail == null || player.hasPotionEffect(PotionEffectType.INVISIBILITY) || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (trail.high < trail.low) {
            return;
        }
        Random random = new Random();
        if (trail.particle != null) {
            particle = trail.particle;
        } else {
            int pos = random.nextInt(trail.mix.size());
            particle = trail.mix.get(pos);
        }
        player.getWorld().spawnParticle(particle, player.getLocation(), random.nextInt(trail.high - trail.low) + trail.low, (double)random.nextFloat(), (double)random.nextFloat(), (double)random.nextFloat(), 0.0);
    }

    public static void setTrail(Player player, Trail trail) {
        activeTrails.put(player.getUniqueId(), trail);
    }
}

