/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iotrails;

import com.interordi.iotrails.Players;
import com.interordi.iotrails.Trails;
import com.interordi.iotrails.bstats.bukkit.Metrics;
import com.interordi.iotrails.listeners.PlayerListener;
import com.interordi.iotrails.utilities.CommandTargets;
import com.interordi.iotrails.utilities.Commands;
import com.interordi.iotrails.utilities.Database;
import java.util.Iterator;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class IOTrails
extends JavaPlugin {
    public Database db = null;
    public boolean init = false;
    private PlayerListener thisPlayerListener;

    public void onEnable() {
        this.saveDefaultConfig();
        String dbHost = this.getConfig().getString("database.host", null);
        int dbPort = this.getConfig().getInt("database.port", 0);
        String dbUsername = this.getConfig().getString("database.username", null);
        String dbPassword = this.getConfig().getString("database.password", null);
        String dbBase = this.getConfig().getString("database.base", null);
        if (dbHost == null) {
            dbHost = this.getConfig().getString("mysql.host");
        }
        if (dbPort == 0) {
            dbPort = this.getConfig().getInt("mysql.port");
        }
        if (dbUsername == null) {
            dbUsername = this.getConfig().getString("mysql.user");
        }
        if (dbPassword == null) {
            dbPassword = this.getConfig().getString("mysql.pass");
        }
        if (dbBase == null) {
            dbBase = this.getConfig().getString("mysql.database");
        }
        this.db = new Database(dbHost, dbPort, dbUsername, dbPassword, dbBase);
        if (!this.db.init()) {
            Bukkit.getLogger().severe("---------------------------------");
            Bukkit.getLogger().severe("Failed to initialize the database");
            Bukkit.getLogger().severe("Make sure to configure config.yml");
            Bukkit.getLogger().severe("---------------------------------");
            return;
        }
        this.thisPlayerListener = new PlayerListener(this);
        Trails.init(this.db);
        Players.init(this);
        this.init = true;
        Metrics metrics = new Metrics(this, 27603);
        this.getLogger().info("IOTrails enabled");
    }

    public void onDisable() {
        this.getLogger().info("IOTrails disabled");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.init) {
            return false;
        }
        CommandTargets results = Commands.findTargets(this.getServer(), sender, cmd, label, args);
        boolean result = false;
        if (results.position != -1) {
            Iterator<String> iterator = results.targets.iterator();
            while (iterator.hasNext()) {
                String target;
                args[results.position] = target = iterator.next();
                result = this.runCommand(sender, cmd, label, args);
            }
        } else {
            result = this.runCommand(sender, cmd, label, args);
        }
        return result;
    }

    public boolean runCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!this.init) {
            return false;
        }
        if (cmd.getName().equalsIgnoreCase("trail") || cmd.getName().equalsIgnoreCase("trails")) {
            if (!sender.hasPermission("iotrails.enable")) {
                sender.sendMessage(ChatColor.RED + "You are not allowed to use this command.");
                return true;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "This command can only be run by a player.");
                return true;
            }
            Player player = (Player)sender;
            String option = null;
            if (args.length > 0) {
                option = args[0];
            }
            if (sender.hasPermission("iotrails.custom") && args.length > 2 && args[0].equalsIgnoreCase("custom")) {
                int min = 2;
                int max = 4;
                String particle = args[1];
                if (args.length > 3) {
                    min = Integer.parseInt(args[2]);
                    max = Integer.parseInt(args[3]);
                }
                Trails.createCustom(particle, min, max);
            }
            Trails.select(player, option);
            return true;
        }
        return false;
    }
}

