/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iosync;

import com.interordi.iosync.IOSync;
import com.interordi.iosync.nbtapi.NBTCompound;
import com.interordi.iosync.nbtapi.NBTFile;
import com.interordi.iosync.nbtapi.NBTList;
import com.interordi.iosync.nbtapi.iface.ReadWriteNBTList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Players
implements Runnable {
    private IOSync plugin;
    private String storagePath;
    private String serverPath;
    private String playerPermissions;
    private String configPath = "plugins/IOSync/";
    private String positionsFile = "positions.yml";
    private String spawnsFile = "spawns.yml";
    private String bedsFile = "beds.yml";
    private Map<UUID, Location> posPlayers;
    private Map<UUID, Location> spawnsPlayers;
    private Map<UUID, Location> bedsPlayers;
    private Map<UUID, Location> backupPosPlayers;
    private Map<UUID, Location> backupSpawnsPlayers;
    private boolean saving = false;

    public Players(IOSync plugin, String storagePath, String serverPath, String playerPermissions) {
        this.plugin = plugin;
        this.storagePath = storagePath;
        this.serverPath = serverPath;
        this.playerPermissions = playerPermissions;
        this.backupPosPlayers = new HashMap<UUID, Location>();
        this.backupSpawnsPlayers = new HashMap<UUID, Location>();
        this.loadAllData();
    }

    public void loadAllData() {
        this.posPlayers = this.loadPositions(this.positionsFile);
        this.spawnsPlayers = this.loadPositions(this.spawnsFile);
        this.bedsPlayers = this.loadPositions(this.bedsFile);
    }

    public void saveAllPositions() {
        this.saveAllPositions(false);
    }

    public void saveAllPositions(boolean instant) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        HashMap<UUID, Location> posPlayersCopy = new HashMap<UUID, Location>();
        posPlayersCopy.putAll(this.posPlayers);
        HashMap<UUID, Location> spawnsPlayersCopy = new HashMap<UUID, Location>();
        spawnsPlayersCopy.putAll(this.spawnsPlayers);
        HashMap<UUID, Location> bedsPlayersCopy = new HashMap<UUID, Location>();
        bedsPlayersCopy.putAll(this.bedsPlayers);
        if (instant) {
            this.savePositions(this.positionsFile, posPlayersCopy);
            this.savePositions(this.spawnsFile, spawnsPlayersCopy);
            this.savePositions(this.bedsFile, bedsPlayersCopy);
            this.saving = false;
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    this.savePositions(this.positionsFile, posPlayersCopy);
                    this.savePositions(this.spawnsFile, spawnsPlayersCopy);
                    this.savePositions(this.bedsFile, bedsPlayersCopy);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                this.saving = false;
            });
        }
    }

    public void loadPlayer(UUID playerUuid) {
        this.loadPlayer(playerUuid, false);
    }

    public void loadPlayer(UUID playerUuid, boolean enablePositionSaving) {
        if (this.storagePath.isEmpty() || this.serverPath.isEmpty()) {
            return;
        }
        File source = new File(String.valueOf(this.storagePath) + playerUuid + ".dat");
        File dest = new File(String.valueOf(this.serverPath) + playerUuid + ".dat");
        if (Files.exists(source.toPath(), new LinkOption[0])) {
            try {
                Location bed;
                NBTFile playerData;
                String version = this.getProcessVersion();
                Location serverSpawn = ((World)Bukkit.getServer().getWorlds().get(0)).getSpawnLocation();
                if (dest.exists() && !dest.isDirectory()) {
                    World world;
                    ReadWriteNBTList rotTag;
                    Location playerSpawn = serverSpawn.clone();
                    playerData = new NBTFile(dest);
                    ReadWriteNBTList posTag = playerData.getDoubleList("Pos");
                    if (posTag != null) {
                        playerSpawn.setX(((Double)posTag.get(0)).doubleValue());
                        playerSpawn.setY(((Double)posTag.get(1)).doubleValue());
                        playerSpawn.setZ(((Double)posTag.get(2)).doubleValue());
                    }
                    if ((rotTag = playerData.getFloatList("Rotation")) != null) {
                        playerSpawn.setYaw(((Float)rotTag.get(0)).floatValue());
                        playerSpawn.setPitch(((Float)rotTag.get(1)).floatValue());
                    }
                    if ((world = this.getWorldFromId(playerData.getString("Dimension"))) != null) {
                        playerSpawn.setWorld(world);
                    }
                    this.backupPosPlayers.put(playerUuid, playerSpawn);
                    Location playerRespawn = serverSpawn.clone();
                    if (playerData.hasTag("respawn")) {
                        NBTCompound respawnGroup = playerData.getCompound("respawn");
                        int[] pos = respawnGroup.getIntArray("pos");
                        playerRespawn.setX((double)pos[0]);
                        playerRespawn.setY((double)pos[1]);
                        playerRespawn.setZ((double)pos[2]);
                        world = this.getWorldFromId(respawnGroup.getString("dimension"));
                        if (world != null) {
                            playerRespawn.setWorld(world);
                        }
                        playerRespawn.setYaw(respawnGroup.getFloat("yaw").floatValue());
                        playerRespawn.setPitch(respawnGroup.getFloat("pitch").floatValue());
                        this.backupSpawnsPlayers.put(playerUuid, playerRespawn);
                    } else if (playerData.hasTag("SpawnX") && playerData.hasTag("SpawnY") && playerData.hasTag("SpawnZ") && playerData.hasTag("SpawnDimension")) {
                        playerRespawn.setX((double)playerData.getFloat("SpawnX").floatValue());
                        playerRespawn.setY((double)playerData.getFloat("SpawnY").floatValue());
                        playerRespawn.setZ((double)playerData.getFloat("SpawnZ").floatValue());
                        world = this.getWorldFromId(playerData.getString("SpawnDimension"));
                        if (world != null) {
                            playerRespawn.setWorld(world);
                        }
                        this.backupSpawnsPlayers.put(playerUuid, playerRespawn);
                    }
                }
                Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (serverSpawn != null) {
                    NBTFile playerData2 = new NBTFile(dest);
                    ReadWriteNBTList posTag = playerData2.getDoubleList("Pos");
                    ((NBTList)posTag).clear();
                    ((NBTList)posTag).add(serverSpawn.getX());
                    ((NBTList)posTag).add(serverSpawn.getY());
                    ((NBTList)posTag).add(serverSpawn.getZ());
                    ReadWriteNBTList rotTag = playerData2.getFloatList("Rotation");
                    ((NBTList)rotTag).clear();
                    ((NBTList)rotTag).add(Float.valueOf(serverSpawn.getYaw()));
                    ((NBTList)rotTag).add(Float.valueOf(serverSpawn.getPitch()));
                    playerData2.setString("Dimension", "minecraft:overworld");
                    playerData2.save();
                }
                if ((bed = this.plugin.getPlayersInst().getPlayerBed(playerUuid)) != null) {
                    playerData = new NBTFile(dest);
                    String dimension = null;
                    dimension = bed.getWorld() != null ? bed.getWorld().getEnvironment().toString() : ((World)Bukkit.getServer().getWorlds().get(0)).getSpawnLocation().getWorld().getEnvironment().toString();
                    if ((dimension = dimension.toLowerCase()).equals("normal")) {
                        dimension = "overworld";
                    }
                    if (version.equals("1.21.5+")) {
                        NBTCompound respawnGroup = playerData.addCompound("respawn");
                        int[] pos = new int[]{bed.getBlockX(), bed.getBlockY(), bed.getBlockZ()};
                        float zero = 0.0f;
                        respawnGroup.setIntArray("pos", pos);
                        respawnGroup.setFloat("yaw", Float.valueOf(zero));
                        respawnGroup.setFloat("pitch", Float.valueOf(zero));
                        respawnGroup.setString("dimension", this.getIdFromWorld(bed.getWorld()));
                    } else {
                        playerData.setString("SpawnDimension", "minecraft:" + dimension);
                        playerData.setInteger("SpawnX", bed.getBlockX());
                        playerData.setInteger("SpawnY", bed.getBlockY());
                        playerData.setInteger("SpawnZ", bed.getBlockZ());
                    }
                    playerData.save();
                } else {
                    playerData = new NBTFile(dest);
                    playerData.removeKey("respawn");
                    playerData.removeKey("SpawnDimension");
                    playerData.removeKey("SpawnX");
                    playerData.removeKey("SpawnY");
                    playerData.removeKey("SpawnZ");
                    playerData.save();
                }
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("ERROR: Failed to copy file from storage");
                Bukkit.getLogger().severe("Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void savePlayerData(Player player) {
        if (this.storagePath.isEmpty() || this.serverPath.isEmpty()) {
            return;
        }
        this.plugin.getServer().savePlayers();
        this.saveAllPositions();
        this.savePlayerInventory(player);
    }

    public void saveAllPlayers() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.setPlayerPosition(player);
        }
        this.saveAllPositions();
        if (this.storagePath.isEmpty() || this.serverPath.isEmpty()) {
            return;
        }
        this.plugin.getServer().savePlayers();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.savePlayerInventory(player);
        }
    }

    public void savePlayerInventory(Player player) {
        File source = new File(String.valueOf(this.serverPath) + player.getUniqueId() + ".dat");
        File dest = new File(String.valueOf(this.storagePath) + player.getUniqueId() + ".dat");
        if (Files.exists(source.toPath(), new LinkOption[0])) {
            try {
                World world;
                String version = this.getProcessVersion();
                Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (this.playerPermissions != null && !this.playerPermissions.isEmpty()) {
                    try {
                        Set<PosixFilePermission> othersRead = PosixFilePermissions.fromString(this.playerPermissions);
                        Files.setPosixFilePermissions(dest.toPath(), othersRead);
                    }
                    catch (UnsupportedOperationException othersRead) {
                        // empty catch block
                    }
                }
                NBTFile playerData = new NBTFile(dest);
                Location bed = null;
                if (playerData.hasTag("respawn")) {
                    NBTCompound respawnGroup = playerData.getCompound("respawn");
                    int[] pos = respawnGroup.getIntArray("pos");
                    World world2 = this.getWorldFromId(respawnGroup.getString("dimension"));
                    if (world2 != null) {
                        bed = new Location(world2, (double)pos[0], (double)pos[1], (double)pos[2]);
                    }
                    bed.setYaw((float)respawnGroup.getInteger("yaw").intValue());
                    bed.setPitch((float)respawnGroup.getInteger("pitch").intValue());
                } else if (playerData.hasTag("SpawnX") && playerData.hasTag("SpawnY") && playerData.hasTag("SpawnZ") && playerData.hasTag("SpawnDimension") && (world = this.getWorldFromId(playerData.getString("SpawnDimension"))) != null) {
                    bed = new Location(world, (double)playerData.getInteger("SpawnX").intValue(), (double)playerData.getInteger("SpawnY").intValue(), (double)playerData.getInteger("SpawnZ").intValue());
                }
                if (bed != null && this.plugin.getServer().getWorlds().contains(bed.getWorld())) {
                    this.plugin.getPlayersInst().setPlayerBed(player, bed);
                }
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("ERROR: Failed to write file to storage");
                Bukkit.getLogger().severe("Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public Map<UUID, Location> loadPositions(String filename) {
        HashMap<UUID, Location> positions = new HashMap<UUID, Location>();
        File statsFile = new File(String.valueOf(this.configPath) + filename);
        YamlConfiguration statsAccess = YamlConfiguration.loadConfiguration((File)statsFile);
        ConfigurationSection posData = statsAccess.getConfigurationSection("positions");
        if (posData == null) {
            this.plugin.getLogger().info("ERROR: Positions YML section in " + filename + " not found");
            return positions;
        }
        Set cs = posData.getKeys(false);
        if (cs == null) {
            this.plugin.getLogger().info("ERROR: Couldn't get player keys");
            return positions;
        }
        for (String key : cs) {
            UUID uuid = UUID.fromString(key);
            ConfigurationSection raw = posData.getConfigurationSection(key);
            Location pos = new Location(Bukkit.getServer().getWorld(raw.getString("world")), raw.getDouble("x"), raw.getDouble("y"), raw.getDouble("z"), Float.parseFloat(raw.getString("yaw")), Float.parseFloat(raw.getString("pitch")));
            positions.put(uuid, pos);
        }
        return positions;
    }

    public void savePositions(String filename, Map<UUID, Location> positions) throws ConcurrentModificationException {
        File statsFile = new File(String.valueOf(this.configPath) + filename);
        YamlConfiguration statsAccess = YamlConfiguration.loadConfiguration((File)statsFile);
        statsAccess.set("positions", (Object)"");
        for (Map.Entry<UUID, Location> entry : positions.entrySet()) {
            UUID uuid = entry.getKey();
            Location pos = entry.getValue();
            if (pos != null) {
                try {
                    String world = ((World)Bukkit.getServer().getWorlds().get(0)).getSpawnLocation().getWorld().getName();
                    if (pos.getWorld() != null) {
                        world = pos.getWorld().getName();
                    }
                    statsAccess.set("positions." + uuid + ".world", (Object)world);
                    statsAccess.set("positions." + uuid + ".x", (Object)pos.getX());
                    statsAccess.set("positions." + uuid + ".y", (Object)pos.getY());
                    statsAccess.set("positions." + uuid + ".z", (Object)pos.getZ());
                    statsAccess.set("positions." + uuid + ".yaw", (Object)Float.valueOf(pos.getYaw()));
                    statsAccess.set("positions." + uuid + ".pitch", (Object)Float.valueOf(pos.getPitch()));
                }
                catch (NullPointerException e) {
                    Bukkit.getLogger().severe("Failed to save the position in  " + filename + " for " + uuid.toString());
                    e.printStackTrace();
                }
                continue;
            }
            statsAccess.set("positions." + uuid, null);
        }
        try {
            statsAccess.save(statsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public World getWorldFromId(String worldName) {
        World world = (World)Bukkit.getWorlds().get(0);
        world = worldName.equalsIgnoreCase("minecraft:overworld") ? (World)Bukkit.getWorlds().get(0) : (worldName.equalsIgnoreCase("minecraft:the_nether") ? (World)Bukkit.getWorlds().get(1) : (worldName.equalsIgnoreCase("minecraft:the_end") ? (World)Bukkit.getWorlds().get(2) : Bukkit.getWorld((String)worldName.substring("minecraft:".length()))));
        if (world == null) {
            Bukkit.getLogger().info("World NOT found as backup: " + worldName);
        }
        return world;
    }

    public String getIdFromWorld(World world) {
        String worldName = world.getName();
        worldName = worldName.equalsIgnoreCase(((World)Bukkit.getWorlds().get(0)).getName()) ? "minecraft:overworld" : (worldName.equalsIgnoreCase(((World)Bukkit.getWorlds().get(1)).getName()) ? "minecraft:the_nether" : (worldName.equalsIgnoreCase(((World)Bukkit.getWorlds().get(2)).getName()) ? "minecraft:the_end" : "minecraft:" + worldName));
        return worldName;
    }

    public String getProcessVersion() {
        String gameVersion = Bukkit.getVersion().split("-")[0];
        List subVersion = null;
        String process = "1.21.5+";
        if (gameVersion.contains(".")) {
            subVersion = Arrays.asList(gameVersion.split("\\.")).stream().map(x -> Integer.parseInt(x)).collect(Collectors.toList());
            if ((Integer)subVersion.get(0) <= 1 && (Integer)subVersion.get(1) <= 21 && (Integer)subVersion.get(2) < 5) {
                process = "1.21.4-";
            }
        } else {
            Bukkit.getLogger().severe("Unreadable game version: " + gameVersion + " from " + Bukkit.getVersion() + ", assuming latest");
        }
        return process;
    }

    public void setPlayerPosition(Player player) {
        this.posPlayers.put(player.getUniqueId(), player.getLocation());
    }

    public Location getPlayerPosition(UUID uuid) {
        return this.posPlayers.get(uuid);
    }

    public Location getBackupPlayerPosition(UUID uuid) {
        return this.backupPosPlayers.get(uuid);
    }

    public void setPlayerSpawn(Player player, Location loc) {
        this.spawnsPlayers.put(player.getUniqueId(), loc);
    }

    public Location getPlayerSpawn(UUID uuid) {
        return this.spawnsPlayers.get(uuid);
    }

    public void setPlayerBed(Player player, Location bed) {
        this.bedsPlayers.put(player.getUniqueId(), bed);
    }

    public Location getPlayerBed(UUID uuid) {
        return this.bedsPlayers.get(uuid);
    }

    @Override
    public void run() {
        this.saveAllPlayers();
    }
}

