/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iosync.listeners;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.interordi.iosync.IOSync;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class LoginListener
implements Listener {
    IOSync plugin;
    boolean enablePositionSaving = false;

    public LoginListener(IOSync plugin, boolean enablePositionSaving) {
        HandlerList handlerList;
        EventExecutor executor;
        Class<?> playerLogin;
        this.plugin = plugin;
        this.enablePositionSaving = enablePositionSaving;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getLogger().info("Testing for login event support:");
        boolean found = false;
        try {
            if (!found) {
                playerLogin = Class.forName("io.papermc.paper.event.player.PlayerServerFullCheckEvent");
                Bukkit.getLogger().info("- PlayerServerFullCheckEvent found");
                executor = (listener, event) -> {
                    if (playerLogin.isInstance(event)) {
                        try {
                            Method getPlayerProfileMethod = event.getClass().getMethod("getPlayerProfile", new Class[0]);
                            PlayerProfile player = (PlayerProfile)getPlayerProfileMethod.invoke((Object)event, new Object[0]);
                            plugin.getPlayersInst().loadPlayer(player.getId(), enablePositionSaving);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                };
                handlerList = (HandlerList)playerLogin.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
                handlerList.register(new RegisteredListener(new Listener(){}, executor, EventPriority.NORMAL, (Plugin)plugin, false));
                found = true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().info("- PlayerServerFullCheckEvent not found");
        }
        try {
            if (!found) {
                playerLogin = Class.forName("org.bukkit.event.player.PlayerLoginEvent");
                Bukkit.getLogger().info("- PlayerLoginEvent found");
                executor = (listener, event) -> {
                    if (playerLogin.isInstance(event)) {
                        try {
                            Method getPlayerMethod = event.getClass().getMethod("getPlayer", new Class[0]);
                            Player player = (Player)getPlayerMethod.invoke((Object)event, new Object[0]);
                            plugin.getPlayersInst().loadPlayer(player.getUniqueId(), enablePositionSaving);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                };
                handlerList = (HandlerList)playerLogin.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
                handlerList.register(new RegisteredListener(new Listener(){}, executor, EventPriority.NORMAL, (Plugin)plugin, false));
                found = true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().info("- PlayerLoginEvent not found");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Location pos = event.getPlayer().getBedSpawnLocation();
        this.plugin.getPlayersInst().setPlayerSpawn(event.getPlayer(), pos);
        this.plugin.getPlayersInst().saveAllPlayers();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerSpawnLocationEvent(PlayerSpawnLocationEvent event) {
        Location pos = this.plugin.getPlayersInst().getPlayerPosition(event.getPlayer().getUniqueId());
        if (pos != null && this.plugin.getServer().getWorlds().contains(pos.getWorld())) {
            event.setSpawnLocation(pos);
        } else if (this.enablePositionSaving) {
            event.setSpawnLocation(event.getPlayer().getWorld().getSpawnLocation());
        }
    }
}

