/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iosync;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.interordi.iosync.IOSync;
import com.interordi.iosync.structs.ServerLoading;
import com.interordi.iosync.utilities.Http;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Switch
implements Runnable {
    private IOSync plugin = null;
    private boolean bungeeInit = false;
    private int timerTask = -1;
    private Map<String, ServerLoading> serversLoading;
    private int loadDuration = 20;

    public Switch(IOSync plugin, int loadDuration) {
        this.plugin = plugin;
        this.loadDuration = loadDuration;
        this.serversLoading = new HashMap<String, ServerLoading>();
    }

    public boolean requestSwitch(Player target, String destination) {
        if (this.isAlreadySwitching(target)) {
            target.sendMessage(ChatColor.RED + "You already have a move underway, please wait.");
            return true;
        }
        if (this.serversLoading.containsKey(destination)) {
            this.serversLoading.get(destination).addPlayer(target);
            target.sendMessage(ChatColor.YELLOW + "This world is being prepared, you will be moved automatically when ready.");
            target.sendTitle(ChatColor.WHITE + "Loading...", ChatColor.WHITE + "Please wait!", 10, 100, 10);
            return true;
        }
        String finalUrl = String.valueOf(this.plugin.getApiServer()) + "servers/start/?id=" + destination;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String responseRaw = Http.readUrl(finalUrl);
            if (responseRaw.trim().equals("[]")) {
                responseRaw = "{}";
            }
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonRoot = null;
            try {
                jsonRoot = jsonParser.parse(responseRaw);
            }
            catch (JsonSyntaxException e) {
                Bukkit.getLogger().warning("Invalid JSON: " + responseRaw);
            }
            if (jsonRoot == null) {
                this.executeSwitch(target, destination);
                return;
            }
            JsonObject jsonObject = jsonRoot.getAsJsonObject();
            if (jsonObject.has("success")) {
                String message = jsonObject.get("success").getAsString();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (message.equalsIgnoreCase("Ready")) {
                        this.executeSwitch(target, destination);
                    } else if (message.equalsIgnoreCase("Loading")) {
                        target.sendMessage(ChatColor.YELLOW + "This world is being prepared, you will be moved automatically when ready.");
                        target.sendTitle(ChatColor.WHITE + "Loading...", ChatColor.WHITE + "Please wait!", 10, 100, 10);
                        this.prepareSwitch(target, destination);
                    }
                });
            } else if (jsonObject.has("error")) {
                String message = jsonObject.get("error").getAsString();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (message.equalsIgnoreCase("Full")) {
                        target.sendMessage(ChatColor.YELLOW + "This world is not currently available due to a high server load, try another one and come back later!");
                    } else if (message.equalsIgnoreCase("Unknown server")) {
                        this.executeSwitch(target, destination);
                    } else if (message.equalsIgnoreCase("Undefined group")) {
                        this.executeSwitch(target, destination);
                    }
                });
            }
        });
        return true;
    }

    public boolean executeSwitch(Player target, String destination) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("Connect");
            out.writeUTF(destination);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.bungeeInit) {
            Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, "BungeeCord");
            this.bungeeInit = true;
        }
        this.plugin.getPlayersInst().savePlayerData(target);
        target.sendPluginMessage((Plugin)this.plugin, "BungeeCord", b.toByteArray());
        return true;
    }

    public void prepareSwitch(Player target, String destination) {
        if (this.timerTask == -1) {
            this.timerTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 20L, 20L);
        }
        this.serversLoading.put(destination, new ServerLoading(target, destination));
    }

    public boolean isAlreadySwitching(Player player) {
        for (ServerLoading serverData : this.serversLoading.values()) {
            if (!serverData.players.contains(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        Instant now = Instant.now();
        HashSet<String> serversLoadingCopy = new HashSet<String>();
        serversLoadingCopy.addAll(this.serversLoading.keySet());
        for (String server : serversLoadingCopy) {
            ServerLoading serverData = this.serversLoading.get(server);
            double elapsed = now.getEpochSecond() - serverData.loading.getEpochSecond();
            if (elapsed >= (double)this.loadDuration) {
                serverData.bar.removeAll();
                this.serversLoading.remove(server);
                if (this.serversLoading.isEmpty()) {
                    Bukkit.getScheduler().cancelTask(this.timerTask);
                    this.timerTask = -1;
                }
                for (Player player : serverData.players) {
                    if (!player.isOnline()) continue;
                    player.sendTitle(ChatColor.WHITE + "Switching...", ChatColor.WHITE + "Please wait!", 10, 100, 10);
                    this.executeSwitch(player, server);
                }
                continue;
            }
            double progress = elapsed / (double)this.loadDuration;
            if (!(progress >= 0.0) || serverData.bar == null) continue;
            serverData.bar.setProgress(progress);
        }
    }
}

