/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iosync;

import com.interordi.iosync.IOSync;
import com.interordi.iosync.nbtapi.NBTFile;
import com.interordi.iosync.nbtapi.NBTList;
import com.interordi.iosync.nbtapi.iface.ReadWriteNBTList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Players
implements Runnable {
    private IOSync plugin;
    private String storagePath;
    private String serverPath;
    private String playerPermissions;
    private String configPath = "plugins/IOSync/";
    private String positionsFile = "positions.yml";
    private String spawnsFile = "spawns.yml";
    private String bedsFile = "beds.yml";
    private Map<UUID, Location> posPlayers;
    private Map<UUID, Location> spawnsPlayers;
    private Map<UUID, Location> bedsPlayers;
    private boolean saving = false;

    public Players(IOSync plugin, String storagePath, String serverPath, String playerPermissions) {
        this.plugin = plugin;
        this.storagePath = storagePath;
        this.serverPath = serverPath;
        this.playerPermissions = playerPermissions;
        this.loadAllData();
    }

    public void loadAllData() {
        this.posPlayers = this.loadPositions(this.positionsFile);
        this.spawnsPlayers = this.loadPositions(this.spawnsFile);
        this.bedsPlayers = this.loadPositions(this.bedsFile);
    }

    public void saveAllPositions() {
        this.saveAllPositions(false);
    }

    public void saveAllPositions(boolean instant) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        HashMap<UUID, Location> posPlayersCopy = new HashMap<UUID, Location>();
        posPlayersCopy.putAll(this.posPlayers);
        HashMap<UUID, Location> spawnsPlayersCopy = new HashMap<UUID, Location>();
        spawnsPlayersCopy.putAll(this.spawnsPlayers);
        HashMap<UUID, Location> bedsPlayersCopy = new HashMap<UUID, Location>();
        bedsPlayersCopy.putAll(this.bedsPlayers);
        if (instant) {
            this.savePositions(this.positionsFile, posPlayersCopy);
            this.savePositions(this.spawnsFile, spawnsPlayersCopy);
            this.savePositions(this.bedsFile, bedsPlayersCopy);
            this.saving = false;
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    this.savePositions(this.positionsFile, posPlayersCopy);
                    this.savePositions(this.spawnsFile, spawnsPlayersCopy);
                    this.savePositions(this.bedsFile, bedsPlayersCopy);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                this.saving = false;
            });
        }
    }

    public void loadPlayer(UUID playerUuid) {
        this.loadPlayer(playerUuid, false);
    }

    public void loadPlayer(UUID playerUuid, boolean enablePositionSaving) {
        if (this.storagePath.isEmpty() || this.serverPath.isEmpty()) {
            return;
        }
        File source = new File(String.valueOf(this.storagePath) + playerUuid + ".dat");
        File dest = new File(String.valueOf(this.serverPath) + playerUuid + ".dat");
        if (Files.exists(source.toPath(), new LinkOption[0])) {
            try {
                Location bed;
                Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Location posPlayer = ((World)Bukkit.getServer().getWorlds().get(0)).getSpawnLocation();
                if (posPlayer != null) {
                    NBTFile playerData = new NBTFile(dest);
                    ReadWriteNBTList posTag = playerData.getDoubleList("Pos");
                    ((NBTList)posTag).clear();
                    ((NBTList)posTag).add(posPlayer.getX());
                    ((NBTList)posTag).add(posPlayer.getY());
                    ((NBTList)posTag).add(posPlayer.getZ());
                    ReadWriteNBTList rotTag = playerData.getFloatList("Rotation");
                    ((NBTList)rotTag).clear();
                    ((NBTList)rotTag).add(Float.valueOf(posPlayer.getYaw()));
                    ((NBTList)rotTag).add(Float.valueOf(posPlayer.getPitch()));
                    playerData.setString("Dimension", "minecraft:overworld");
                    playerData.save();
                }
                if ((bed = this.plugin.getPlayersInst().getPlayerBed(playerUuid)) != null) {
                    NBTFile playerData = new NBTFile(dest);
                    String dimension = null;
                    dimension = bed.getWorld() != null ? bed.getWorld().getEnvironment().toString() : ((World)Bukkit.getServer().getWorlds().get(0)).getSpawnLocation().getWorld().getEnvironment().toString();
                    if ((dimension = dimension.toLowerCase()).equals("normal")) {
                        dimension = "overworld";
                    }
                    playerData.setString("SpawnDimension", "minecraft:" + dimension);
                    playerData.setInteger("SpawnX", bed.getBlockX());
                    playerData.setInteger("SpawnY", bed.getBlockY());
                    playerData.setInteger("SpawnZ", bed.getBlockZ());
                    playerData.save();
                }
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("ERROR: Failed to copy file from storage");
                Bukkit.getLogger().severe("Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void savePlayerData(Player player) {
        if (this.storagePath.isEmpty() || this.serverPath.isEmpty()) {
            return;
        }
        this.plugin.getServer().savePlayers();
        this.saveAllPositions();
        this.savePlayerInventory(player);
    }

    public void saveAllPlayers() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.setPlayerPosition(player);
        }
        this.saveAllPositions();
        if (this.storagePath.isEmpty() || this.serverPath.isEmpty()) {
            return;
        }
        this.plugin.getServer().savePlayers();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.savePlayerInventory(player);
        }
    }

    public void savePlayerInventory(Player player) {
        File source = new File(String.valueOf(this.serverPath) + player.getUniqueId() + ".dat");
        File dest = new File(String.valueOf(this.storagePath) + player.getUniqueId() + ".dat");
        if (Files.exists(source.toPath(), new LinkOption[0])) {
            try {
                Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (this.playerPermissions != null && !this.playerPermissions.isEmpty()) {
                    try {
                        Set<PosixFilePermission> othersRead = PosixFilePermissions.fromString(this.playerPermissions);
                        Files.setPosixFilePermissions(dest.toPath(), othersRead);
                    }
                    catch (UnsupportedOperationException othersRead) {
                        // empty catch block
                    }
                }
                NBTFile playerData = new NBTFile(dest);
                World world = this.plugin.getServer().getWorld(playerData.getString("SpawnDimension"));
                int spawnX = playerData.getInteger("SpawnX");
                int spawnY = playerData.getInteger("SpawnY");
                int spawnZ = playerData.getInteger("SpawnZ");
                Location bed = new Location(world, (double)spawnX, (double)spawnY, (double)spawnZ);
                if (this.plugin.getServer().getWorlds().contains(bed.getWorld())) {
                    this.plugin.getPlayersInst().setPlayerBed(player, bed);
                }
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("ERROR: Failed to write file to storage");
                Bukkit.getLogger().severe("Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public Map<UUID, Location> loadPositions(String filename) {
        HashMap<UUID, Location> positions = new HashMap<UUID, Location>();
        File statsFile = new File(String.valueOf(this.configPath) + filename);
        YamlConfiguration statsAccess = YamlConfiguration.loadConfiguration((File)statsFile);
        ConfigurationSection posData = statsAccess.getConfigurationSection("positions");
        if (posData == null) {
            this.plugin.getLogger().info("ERROR: Positions YML section in " + filename + " not found");
            return positions;
        }
        Set cs = posData.getKeys(false);
        if (cs == null) {
            this.plugin.getLogger().info("ERROR: Couldn't get player keys");
            return positions;
        }
        for (String key : cs) {
            UUID uuid = UUID.fromString(key);
            ConfigurationSection raw = posData.getConfigurationSection(key);
            Location pos = new Location(Bukkit.getServer().getWorld(raw.getString("world")), raw.getDouble("x"), raw.getDouble("y"), raw.getDouble("z"), Float.parseFloat(raw.getString("yaw")), Float.parseFloat(raw.getString("pitch")));
            positions.put(uuid, pos);
        }
        return positions;
    }

    public void savePositions(String filename, Map<UUID, Location> positions) throws ConcurrentModificationException {
        File statsFile = new File(String.valueOf(this.configPath) + filename);
        YamlConfiguration statsAccess = YamlConfiguration.loadConfiguration((File)statsFile);
        statsAccess.set("positions", (Object)"");
        for (Map.Entry<UUID, Location> entry : positions.entrySet()) {
            UUID uuid = entry.getKey();
            Location pos = entry.getValue();
            if (pos != null) {
                try {
                    String world = ((World)Bukkit.getServer().getWorlds().get(0)).getSpawnLocation().getWorld().getName();
                    if (pos.getWorld() != null) {
                        world = pos.getWorld().getName();
                    }
                    statsAccess.set("positions." + uuid + ".world", (Object)world);
                    statsAccess.set("positions." + uuid + ".x", (Object)pos.getX());
                    statsAccess.set("positions." + uuid + ".y", (Object)pos.getY());
                    statsAccess.set("positions." + uuid + ".z", (Object)pos.getZ());
                    statsAccess.set("positions." + uuid + ".yaw", (Object)Float.valueOf(pos.getYaw()));
                    statsAccess.set("positions." + uuid + ".pitch", (Object)Float.valueOf(pos.getPitch()));
                }
                catch (NullPointerException e) {
                    Bukkit.getLogger().severe("Failed to save the position in  " + filename + " for " + uuid.toString());
                    e.printStackTrace();
                }
                continue;
            }
            statsAccess.set("positions." + uuid, null);
        }
        try {
            statsAccess.save(statsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPlayerPosition(Player player) {
        this.posPlayers.put(player.getUniqueId(), player.getLocation());
    }

    public Location getPlayerPosition(UUID uuid) {
        return this.posPlayers.get(uuid);
    }

    public void setPlayerSpawn(Player player, Location loc) {
        this.spawnsPlayers.put(player.getUniqueId(), loc);
    }

    public Location getPlayerSpawn(UUID uuid) {
        return this.spawnsPlayers.get(uuid);
    }

    public void setPlayerBed(Player player, Location bed) {
        this.bedsPlayers.put(player.getUniqueId(), bed);
    }

    public Location getPlayerBed(UUID uuid) {
        return this.bedsPlayers.get(uuid);
    }

    @Override
    public void run() {
        this.saveAllPlayers();
    }
}

