/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iosync;

import com.interordi.iosync.Players;
import com.interordi.iosync.Switch;
import com.interordi.iosync.bstats.bukkit.Metrics;
import com.interordi.iosync.listeners.LoginListener;
import com.interordi.iosync.utilities.CommandTargets;
import com.interordi.iosync.utilities.Commands;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class IOSync
extends JavaPlugin {
    private LoginListener thisLoginListener;
    private Players thisPlayers;
    private Switch switchSupport;
    private String apiService;
    private String playerPermissions;

    public void onEnable() {
        this.saveDefaultConfig();
        String storagePath = this.getConfig().getString("storage-path", "");
        if (storagePath.equalsIgnoreCase("null")) {
            storagePath = "";
        }
        if (!(storagePath.endsWith("/") || storagePath.endsWith("\\") || storagePath.isEmpty())) {
            storagePath = String.valueOf(storagePath) + "/";
        }
        this.apiService = this.getConfig().getString("api-service", "");
        this.playerPermissions = this.getConfig().getString("player-permissions", null);
        int serverLoadTime = this.getConfig().getInt("server-load-time", 20);
        String serverPath = "";
        try {
            BufferedReader is = new BufferedReader(new FileReader("server.properties"));
            Properties props = new Properties();
            props.load(is);
            is.close();
            serverPath = props.getProperty("level-name");
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("ERROR: Couldn't read level-name, defaulting to 'world'");
            serverPath = "world";
        }
        serverPath = "./" + serverPath + "/playerdata/";
        this.thisLoginListener = new LoginListener(this, !storagePath.isEmpty() && !serverPath.isEmpty());
        this.thisPlayers = new Players(this, storagePath, serverPath, this.playerPermissions);
        this.switchSupport = new Switch(this, serverLoadTime);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this.thisPlayers, 6000L, 6000L);
        Metrics metrics = new Metrics(this, 27484);
        this.getLogger().info("IOSync enabled");
    }

    public void onDisable() {
        this.thisPlayers.saveAllPositions(true);
        this.getLogger().info("IOSync disabled");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        CommandTargets results = Commands.findTargets(this.getServer(), sender, cmd, label, args);
        boolean result = false;
        if (results.position != -1) {
            Iterator<String> iterator = results.targets.iterator();
            while (iterator.hasNext()) {
                String target;
                args[results.position] = target = iterator.next();
                result = this.runCommand(sender, cmd, label, args);
            }
        } else {
            result = this.runCommand(sender, cmd, label, args);
        }
        return result;
    }

    public boolean runCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("switch") || cmd.getName().equalsIgnoreCase("sswitch")) {
            if (!sender.hasPermission("iosync.switch")) {
                sender.sendMessage("\u00a7cYou are not allowed to use this command.");
                return true;
            }
            Player target = null;
            String destination = "";
            if (args.length >= 2) {
                destination = args[0];
                target = this.getServer().getPlayer(args[1]);
                if (target == null) {
                    target = this.getServer().getPlayer(args[0]);
                    destination = args[1];
                }
            } else if (args.length == 1) {
                if (!(sender instanceof Player)) {
                    return false;
                }
                destination = args[0];
                target = (Player)sender;
            } else {
                sender.sendMessage("\u00a7cMissing parameter: destination server");
                return true;
            }
            if (target == null) {
                sender.sendMessage("\u00a7cTarget player not found!");
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("sswitch")) {
                this.getLogger().info("|IOCMD|sswitch " + target.getDisplayName());
            }
            if (!this.apiService.isEmpty()) {
                return this.switchSupport.requestSwitch(target, destination);
            }
            return this.switchSupport.executeSwitch(target, destination);
        }
        if (cmd.getName().equalsIgnoreCase("lobby")) {
            Player target = (Player)sender;
            String lobby = "lobby";
            return this.switchSupport.executeSwitch(target, lobby);
        }
        return false;
    }

    public String getApiServer() {
        return this.apiService;
    }

    public Players getPlayersInst() {
        return this.thisPlayers;
    }
}

