/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats.utilities;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class Heads {
    public static ItemStack getCustomSkull(OfflinePlayer target, int amount) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD, amount);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(target);
            meta.setDisplayName(ChatColor.RESET + target.getName());
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    public static ItemStack getCustomSkull(OfflinePlayer target) {
        return Heads.getCustomSkull(target, 1);
    }

    public static CompletableFuture<String> fetchUUIDAsync(String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + username);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (connection.getResponseCode() == 200) {
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    reader.close();
                    return json.get("id").getAsString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public static void giveToPlayer(Plugin plugin, String target, Player user, int amount) {
        Player headOf = Bukkit.getServer().getPlayer(target);
        if (headOf != null) {
            UUID uuid = headOf.getUniqueId();
            OfflinePlayer targetOffline = Bukkit.getOfflinePlayer((UUID)uuid);
            ItemStack head = Heads.getCustomSkull(targetOffline, amount);
            PlayerInventory inv = user.getInventory();
            inv.addItem(new ItemStack[]{head});
        } else {
            Heads.fetchUUIDAsync(target).thenAccept(rawUuid -> {
                if (rawUuid != null) {
                    Bukkit.getScheduler().runTask(plugin, () -> {
                        UUID uuid = UUID.fromString(rawUuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
                        OfflinePlayer targetOffline = Bukkit.getOfflinePlayer((UUID)uuid);
                        ItemStack head = Heads.getCustomSkull(targetOffline, amount);
                        PlayerInventory inv = user.getInventory();
                        inv.addItem(new ItemStack[]{head});
                    });
                } else {
                    Bukkit.getScheduler().runTask(plugin, () -> user.sendMessage(ChatColor.RED + "Failed to get the player's UUID."));
                }
            });
        }
    }
}

