/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats.listeners;

import com.interordi.iobattlestats.IOBattleStats;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PlayersMove
implements Runnable,
Listener {
    IOBattleStats plugin = null;

    public PlayersMove(IOBattleStats plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    @Override
    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            double movement;
            if (!player.hasPermission("iobattlestats.track")) {
                return;
            }
            Location newPos = player.getLocation();
            Location oldPos = this.plugin.tracker.getLastPosition(player);
            if (oldPos != null && newPos != null && oldPos.getWorld() == newPos.getWorld() && (movement = oldPos.distance(newPos)) > 0.5 && (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE)) {
                Entity vehicle;
                String type = "";
                type = player.isFlying() ? "flight" : (player.isInsideVehicle() ? ((vehicle = player.getVehicle()).getType() == EntityType.HORSE || vehicle.getType() == EntityType.SKELETON_HORSE || vehicle.getType() == EntityType.ZOMBIE_HORSE || vehicle.getType() == EntityType.MULE || vehicle.getType() == EntityType.DONKEY ? "horse" : (vehicle.getType() == EntityType.PIG ? "pig" : (vehicle.getType() == EntityType.LLAMA ? "llama" : (vehicle.getType() == EntityType.STRIDER ? "strider" : (vehicle.getType() == EntityType.BOAT ? "boat" : (vehicle.getType() == EntityType.MINECART ? "minecart" : vehicle.getType().name().toLowerCase())))))) : "walk");
                this.plugin.data.recordItemStat("move", player.getUniqueId(), type, (int)Math.round(movement), player.getWorld().getName());
            }
            this.plugin.tracker.setPosition(player, newPos);
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        this.plugin.tracker.setPosition(e.getPlayer(), e.getTo());
    }
}

