/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats.listeners;

import com.interordi.iobattlestats.IOBattleStats;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerInteractionsListener
implements Listener {
    IOBattleStats plugin;

    public PlayerInteractionsListener(IOBattleStats plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("iobattlestats.track")) {
            return;
        }
        ItemStack sourceItem = event.getItem();
        Material sourceMaterial = event.getMaterial();
        if (sourceMaterial == Material.FLINT_AND_STEEL) {
            String itemName = "";
            if (sourceItem != null && sourceItem.getItemMeta() != null && sourceItem.getItemMeta().hasDisplayName()) {
                itemName = sourceItem.getItemMeta().getDisplayName();
            }
            this.plugin.data.recordItemNamedStat("lighters", player.getUniqueId(), sourceMaterial.toString(), itemName, 1, player.getWorld().getName());
        } else if (sourceMaterial == Material.ENDER_PEARL) {
            String itemName = "";
            if (sourceItem != null && sourceItem.getItemMeta() != null && sourceItem.getItemMeta().hasDisplayName()) {
                itemName = sourceItem.getItemMeta().getDisplayName();
            }
            this.plugin.data.recordItemNamedStat("enderpearls", player.getUniqueId(), sourceMaterial.toString(), itemName, 1, player.getWorld().getName());
        }
    }

    @EventHandler
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("iobattlestats.track")) {
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        Entity target = event.getRightClicked();
        if (!(target.getType() != EntityType.COW && target.getType() != EntityType.MOOSHROOM || mainHand.getType() != Material.BUCKET && offHand.getType() != Material.BUCKET)) {
            this.plugin.data.recordItemStat("milk", player.getUniqueId(), target.getType().toString(), 1, player.getWorld().getName());
        }
    }
}

