/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats.listeners;

import com.interordi.iobattlestats.IOBattleStats;
import com.interordi.iobattlestats.utilities.Utilities;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DamageListener
implements Listener {
    IOBattleStats plugin;

    public DamageListener(IOBattleStats plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event instanceof EntityDamageByEntityEvent) {
            this.onEntityDamage((EntityDamageByEntityEvent)event);
        } else if (event instanceof EntityDamageByBlockEvent) {
            this.onBlockDamage((EntityDamageByBlockEvent)event);
        } else {
            this.onOtherDamage(event);
        }
    }

    public void onEntityDamage(EntityDamageByEntityEvent event) {
        boolean projectileSource;
        float damage = Math.round(event.getFinalDamage() * 10.0) / 10L;
        if (damage == 0.0f) {
            return;
        }
        boolean playerSource = event.getDamager() != null && event.getDamager() instanceof Player;
        boolean playerTarget = event.getEntity() != null && event.getEntity() instanceof Player;
        boolean bl = projectileSource = event.getDamager() != null && event.getDamager() instanceof Projectile;
        if (!(playerSource || playerTarget || projectileSource)) {
            return;
        }
        Entity attacker = event.getDamager();
        Entity target = event.getEntity();
        String damageSource = event.getCause().toString();
        String weaponName = "";
        String attackerName = attacker.getType().toString();
        String targetName = target.getType().toString();
        if (playerSource) {
            attackerName = attacker.getUniqueId().toString();
            if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK || event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
                ItemStack held = ((Player)attacker).getInventory().getItemInMainHand();
                if (held != null && held.getType() != Material.AIR) {
                    damageSource = held.getType().toString();
                    if (held.getItemMeta() != null) {
                        weaponName = held.getItemMeta().getDisplayName();
                    }
                } else {
                    held = ((Player)attacker).getInventory().getItemInOffHand();
                    if (held != null) {
                        damageSource = held.getType().toString();
                        if (held.getItemMeta() != null) {
                            weaponName = held.getItemMeta().getDisplayName();
                        }
                    }
                }
            }
        }
        if (playerTarget) {
            targetName = target.getUniqueId().toString();
        }
        if (event.getDamager() instanceof Projectile) {
            Projectile projectile = (Projectile)event.getDamager();
            attacker = (Entity)projectile.getShooter();
            if (attacker instanceof Player) {
                playerSource = true;
            }
            if (playerSource) {
                attackerName = attacker.getUniqueId().toString();
            }
            damageSource = Utilities.getDamagerType(event.getDamager());
        }
        if (!playerSource && !playerTarget) {
            return;
        }
        if (weaponName == null) {
            weaponName = "";
        }
        if (playerSource && attacker.hasPermission("iobattlestats.track") || playerTarget && target.hasPermission("iobattlestats.track")) {
            this.plugin.data.recordDamage(attackerName, targetName, attacker.getWorld().getName(), damage, damageSource, weaponName, playerSource, playerTarget);
        }
    }

    public void onBlockDamage(EntityDamageByBlockEvent event) {
        float damage = Math.round(event.getFinalDamage() * 10.0) / 10L;
        if (damage == 0.0f) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player target = (Player)event.getEntity();
        String targetName = target.getUniqueId().toString();
        if (target.hasPermission("iobattlestats.track")) {
            this.plugin.data.recordDamage("BLOCK", targetName, target.getWorld().getName(), damage, event.getCause().toString(), "", false, true);
        }
    }

    public void onOtherDamage(EntityDamageEvent event) {
        float damage = Math.round(event.getFinalDamage() * 10.0) / 10L;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player target = (Player)event.getEntity();
        String targetName = target.getUniqueId().toString();
        if (target.hasPermission("iobattlestats.track")) {
            this.plugin.data.recordDamage("OTHER", targetName, target.getWorld().getName(), damage, event.getCause().toString(), "", false, true);
        }
    }
}

