/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iobattlestats;

import com.interordi.iobattlestats.DataAccess;
import com.interordi.iobattlestats.PlayersTracking;
import com.interordi.iobattlestats.bukkit.Metrics;
import com.interordi.iobattlestats.listeners.BasicListener;
import com.interordi.iobattlestats.listeners.BlockListener;
import com.interordi.iobattlestats.listeners.ChatListener;
import com.interordi.iobattlestats.listeners.DamageListener;
import com.interordi.iobattlestats.listeners.DeathListener;
import com.interordi.iobattlestats.listeners.LoginListener;
import com.interordi.iobattlestats.listeners.PlayerInteractionsListener;
import com.interordi.iobattlestats.listeners.PlayersMove;
import com.interordi.iobattlestats.utilities.CommandTargets;
import com.interordi.iobattlestats.utilities.Commands;
import com.interordi.iobattlestats.utilities.Heads;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class IOBattleStats
extends JavaPlugin {
    public DataAccess data;
    public PlayersTracking tracker;

    public void onEnable() {
        this.saveDefaultConfig();
        boolean enable = true;
        String dbHost = this.getConfig().getString("database.host", null);
        int dbPort = this.getConfig().getInt("database.port", 3306);
        String dbUsername = this.getConfig().getString("database.username", null);
        String dbPassword = this.getConfig().getString("database.password", null);
        String dbBase = this.getConfig().getString("database.base", null);
        if (dbHost == null) {
            dbHost = this.getConfig().getString("mysql.server");
        }
        if (dbUsername == null) {
            dbUsername = this.getConfig().getString("mysql.username");
        }
        if (dbPassword == null) {
            dbPassword = this.getConfig().getString("mysql.password");
        }
        if (dbBase == null) {
            dbBase = this.getConfig().getString("mysql.base");
        }
        if (this.getConfig().contains("enable")) {
            enable = this.getConfig().getBoolean("enable");
        }
        this.data = new DataAccess(this, dbHost, dbPort, dbUsername, dbPassword, dbBase);
        if (!this.data.init()) {
            Bukkit.getLogger().severe("---------------------------------");
            Bukkit.getLogger().severe("Failed to initialize the database");
            Bukkit.getLogger().severe("Make sure to configure config.yml");
            Bukkit.getLogger().severe("---------------------------------");
            enable = false;
            return;
        }
        new LoginListener(this, enable);
        if (enable) {
            new BasicListener(this);
            new BlockListener(this);
            new ChatListener(this);
            new DamageListener(this);
            new DeathListener(this);
            new PlayerInteractionsListener(this);
            PlayersMove playersMove = new PlayersMove(this);
            this.tracker = new PlayersTracking(this);
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)playersMove, 200L, 200L);
        }
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)this.data, 1200L, 1200L);
        Metrics metrics = new Metrics(this, 27485);
        this.getLogger().info("IOBattleStats enabled");
    }

    public void onDisable() {
        this.data.run();
        this.getLogger().info("IOBattleStats disabled");
    }

    public void addPlayer(Player player) {
        if (this.tracker == null) {
            return;
        }
        this.tracker.add(player);
        this.data.loadStats(player);
    }

    public void removePlayer(Player player) {
        if (this.tracker == null) {
            return;
        }
        this.data.saveStats(player);
        this.tracker.remove(player);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        CommandTargets results = Commands.findTargets(Bukkit.getServer(), sender, cmd, label, args);
        boolean result = false;
        if (results.position != -1) {
            Iterator<String> iterator = results.targets.iterator();
            while (iterator.hasNext()) {
                String target;
                args[results.position] = target = iterator.next();
                result = this.runCommand(sender, cmd, label, args);
            }
        } else {
            result = this.runCommand(sender, cmd, label, args);
        }
        return result;
    }

    public boolean runCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("givehead")) {
            boolean isConsole = !(sender instanceof Player);
            Player user = null;
            if (!isConsole) {
                user = (Player)sender;
            }
            if (!isConsole && !user.hasPermission("iobattlestats.givehead")) {
                user.sendMessage(ChatColor.RED + "You don't have permission to use this command.");
                return true;
            }
            Object headOf = null;
            Player giveTo = user;
            String targetName = "";
            int amount = 1;
            if (args.length >= 3) {
                giveTo = Bukkit.getServer().getPlayer(args[0]);
                targetName = args[1];
                try {
                    amount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.RED + args[2] + " is not a valid number.");
                    return true;
                }
            } else if (args.length >= 2) {
                giveTo = Bukkit.getServer().getPlayer(args[0]);
                try {
                    amount = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    targetName = args[1];
                }
            } else if (args.length >= 1) {
                targetName = args[0];
            } else {
                sender.sendMessage(ChatColor.RED + "You need to specify a player name.");
                return true;
            }
            if (giveTo == null) {
                sender.sendMessage(ChatColor.RED + "The target player is offline.");
                return true;
            }
            Heads.giveToPlayer((Plugin)this, targetName, giveTo, amount);
            return true;
        }
        return false;
    }
}

