/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.util.display;

import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.Objects;
import java.util.StringJoiner;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.ComponentStyleBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultStyle {
    private static final boolean CHAT_COLOR_HAS_GET_COLOR = ReflectionUtil.hasMethod(ChatColor.class, "getColor", new Class[0]);
    private static final boolean BASE_COMPONENT_HAS_FONT = ReflectionUtil.hasMethod(BaseComponent.class, "setFont", new Class[0]);
    private static final boolean COMPONENT_STYLE_CLASS_EXISTS = ReflectionUtil.classExists("net.md_5.bungee.api.chat.ComponentStyle");
    private static final boolean COMPONENT_STYLE_HAS_SHADOW_COLOR = COMPONENT_STYLE_CLASS_EXISTS && ReflectionUtil.hasMethod(ComponentStyle.class, "getShadowColor", new Class[0]);
    @NotNull
    public static final DefaultStyle MINECRAFT_DEFAULTS = new DefaultStyle();
    @Nullable
    private final ChatColor color;
    @Nullable
    private final Color shadowColor;
    @Nullable
    private final String font;
    @Nullable
    private final Boolean bold;
    @Nullable
    private final Boolean italic;
    @Nullable
    private final Boolean underlined;
    @Nullable
    private final Boolean strikethrough;
    @Nullable
    private final Boolean obfuscated;

    public DefaultStyle() {
        this(null, null, null, null, null, null, null, null);
    }

    public DefaultStyle(@NotNull ChatColor color) {
        this(DefaultStyle.validateColor(Objects.requireNonNull(color, "ChatColor is null.")), null, null, null, null, null, null, null);
    }

    public DefaultStyle(@NotNull ComponentStyle style) {
        this(DefaultStyle.validateColor(Objects.requireNonNull(style, "ComponentStyle is null.").getColor()), COMPONENT_STYLE_HAS_SHADOW_COLOR ? style.getShadowColor() : null, style.getFont(), style.isBoldRaw(), style.isItalicRaw(), style.isUnderlinedRaw(), style.isStrikethroughRaw(), style.isObfuscatedRaw());
    }

    private DefaultStyle(@Nullable ChatColor color, @Nullable Color shadowColor, @Nullable String font, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated) {
        this.color = color;
        this.shadowColor = shadowColor;
        this.font = font;
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.strikethrough = strikethrough;
        this.obfuscated = obfuscated;
    }

    @NotNull
    public DefaultStyle color(@Nullable ChatColor color) {
        return new DefaultStyle(DefaultStyle.validateColor(color), this.shadowColor, this.font, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated);
    }

    @NotNull
    public DefaultStyle shadowColor(@Nullable Color shadowColor) {
        return new DefaultStyle(this.color, shadowColor, this.font, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated);
    }

    @NotNull
    public DefaultStyle font(@Nullable String font) {
        return new DefaultStyle(this.color, this.shadowColor, font, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated);
    }

    @NotNull
    public DefaultStyle bold(@Nullable Boolean bold) {
        return new DefaultStyle(this.color, this.shadowColor, this.font, bold, this.italic, this.underlined, this.strikethrough, this.obfuscated);
    }

    @NotNull
    public DefaultStyle italic(@Nullable Boolean italic) {
        return new DefaultStyle(this.color, this.shadowColor, this.font, this.bold, italic, this.underlined, this.strikethrough, this.obfuscated);
    }

    @NotNull
    public DefaultStyle underlined(@Nullable Boolean underlined) {
        return new DefaultStyle(this.color, this.shadowColor, this.font, this.bold, this.italic, underlined, this.strikethrough, this.obfuscated);
    }

    @NotNull
    public DefaultStyle strikethrough(@Nullable Boolean strikethrough) {
        return new DefaultStyle(this.color, this.shadowColor, this.font, this.bold, this.italic, this.underlined, strikethrough, this.obfuscated);
    }

    @NotNull
    public DefaultStyle obfuscated(@Nullable Boolean obfuscated) {
        return new DefaultStyle(this.color, this.shadowColor, this.font, this.bold, this.italic, this.underlined, this.strikethrough, obfuscated);
    }

    @NotNull
    public DefaultStyle mergeWith(@NotNull DefaultStyle baseStyle) {
        Preconditions.checkNotNull((Object)baseStyle, (Object)"DefaultStyle is null.");
        if (this == MINECRAFT_DEFAULTS) {
            return baseStyle;
        }
        return new DefaultStyle(this.color != null ? this.color : baseStyle.color, this.shadowColor != null ? this.shadowColor : baseStyle.shadowColor, this.font != null ? this.font : baseStyle.font, this.bold != null ? this.bold : baseStyle.bold, this.italic != null ? this.italic : baseStyle.italic, this.underlined != null ? this.underlined : baseStyle.underlined, this.strikethrough != null ? this.strikethrough : baseStyle.strikethrough, this.obfuscated != null ? this.obfuscated : baseStyle.obfuscated);
    }

    public void applyTo(@NotNull BaseComponent component) {
        Preconditions.checkNotNull((Object)component, (Object)"BaseComponent is null.");
        if (this == MINECRAFT_DEFAULTS) {
            return;
        }
        if (this.color != null) {
            component.setColor(this.color);
        }
        if (COMPONENT_STYLE_HAS_SHADOW_COLOR && this.shadowColor != null) {
            component.setShadowColor(this.shadowColor);
        }
        if (BASE_COMPONENT_HAS_FONT && this.font != null) {
            component.setFont(this.font);
        }
        if (this.bold != null) {
            component.setBold(this.bold);
        }
        if (this.italic != null) {
            component.setItalic(this.italic);
        }
        if (this.underlined != null) {
            component.setUnderlined(this.underlined);
        }
        if (this.strikethrough != null) {
            component.setStrikethrough(this.strikethrough);
        }
        if (this.obfuscated != null) {
            component.setObfuscated(this.obfuscated);
        }
    }

    public void applyTo(@NotNull ComponentBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"ComponentBuilder is null.");
        if (this == MINECRAFT_DEFAULTS) {
            return;
        }
        if (COMPONENT_STYLE_HAS_SHADOW_COLOR && this.shadowColor != null) {
            builder.style(this.toComponentStyle());
            return;
        }
        if (this.color != null) {
            builder.color(this.color);
        }
        if (BASE_COMPONENT_HAS_FONT && this.font != null) {
            builder.font(this.font);
        }
        if (this.bold != null) {
            builder.bold(this.bold.booleanValue());
        }
        if (this.italic != null) {
            builder.italic(this.italic.booleanValue());
        }
        if (this.underlined != null) {
            builder.underlined(this.underlined.booleanValue());
        }
        if (this.strikethrough != null) {
            builder.strikethrough(this.strikethrough.booleanValue());
        }
        if (this.obfuscated != null) {
            builder.obfuscated(this.obfuscated.booleanValue());
        }
    }

    @NotNull
    public ComponentStyle toComponentStyle() {
        ComponentStyleBuilder builder = ComponentStyle.builder().color(this.color).font(this.font).bold(this.bold).italic(this.italic).underlined(this.underlined).strikethrough(this.strikethrough).obfuscated(this.obfuscated);
        if (COMPONENT_STYLE_HAS_SHADOW_COLOR) {
            builder.shadowColor(this.shadowColor);
        }
        return builder.build();
    }

    @Nullable
    public ChatColor getColor() {
        return this.color;
    }

    @Nullable
    public Color getShadowColor() {
        return this.shadowColor;
    }

    @Nullable
    public String getFont() {
        return this.font;
    }

    @Nullable
    public Boolean isBold() {
        return this.bold;
    }

    @Nullable
    public Boolean isItalic() {
        return this.italic;
    }

    @Nullable
    public Boolean isUnderlined() {
        return this.underlined;
    }

    @Nullable
    public Boolean isStrikethrough() {
        return this.strikethrough;
    }

    @Nullable
    public Boolean isObfuscated() {
        return this.obfuscated;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "DefaultStyle{", "}");
        joiner.setEmptyValue("DefaultStyle{minecraft defaults}");
        if (this.color != null) {
            joiner.add("color=" + this.color.toString().replace('\u00a7', '&'));
        }
        if (this.shadowColor != null) {
            joiner.add("shadowColor=#" + String.format("%08X", this.shadowColor.getRGB()).substring(2));
        }
        if (this.font != null) {
            joiner.add("font='" + this.font + "'");
        }
        if (this.bold != null) {
            joiner.add("bold=" + this.bold);
        }
        if (this.italic != null) {
            joiner.add("italic=" + this.italic);
        }
        if (this.underlined != null) {
            joiner.add("underlined=" + this.underlined);
        }
        if (this.strikethrough != null) {
            joiner.add("strikethrough=" + this.strikethrough);
        }
        if (this.obfuscated != null) {
            joiner.add("obfuscated=" + this.obfuscated);
        }
        return joiner.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultStyle)) {
            return false;
        }
        DefaultStyle that = (DefaultStyle)o;
        return Objects.equals(this.color, that.color) && Objects.equals(this.shadowColor, that.shadowColor) && Objects.equals(this.font, that.font) && Objects.equals(this.bold, that.bold) && Objects.equals(this.italic, that.italic) && Objects.equals(this.underlined, that.underlined) && Objects.equals(this.strikethrough, that.strikethrough) && Objects.equals(this.obfuscated, that.obfuscated);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.color);
        result = 31 * result + Objects.hashCode(this.shadowColor);
        result = 31 * result + Objects.hashCode(this.font);
        result = 31 * result + Objects.hashCode(this.bold);
        result = 31 * result + Objects.hashCode(this.italic);
        result = 31 * result + Objects.hashCode(this.underlined);
        result = 31 * result + Objects.hashCode(this.strikethrough);
        result = 31 * result + Objects.hashCode(this.obfuscated);
        return result;
    }

    @Nullable
    private static ChatColor validateColor(@Nullable ChatColor color) {
        Preconditions.checkArgument((!CHAT_COLOR_HAS_GET_COLOR || color == null || color.getColor() != null ? 1 : 0) != 0, (Object)"Invalid ChatColor, expected a color but found a formatting option");
        return color;
    }
}

