/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.util;

import com.fren_gor.ultimateAdvancementAPI.util.AbstractCompositeCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CompositeSet<T>
extends AbstractCompositeCollection<T>
implements Set<T> {
    private final int size;
    private final Set<T>[] sets;

    @SafeVarargs
    public static <T> Set<T> of(Set<T> ... sets) {
        return Collections.unmodifiableSet(new CompositeSet<T>(sets));
    }

    CompositeSet(@NotNull Set<T>[] sets) {
        this.sets = Objects.requireNonNull(sets);
        int size = 0;
        for (Set<T> set : sets) {
            size += set.size();
        }
        this.size = size;
    }

    @Override
    @NotNull
    protected Collection<T>[] getInner() {
        return this.sets;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return "CompositeSet{sets=" + Arrays.toString(this.sets) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeSet that = (CompositeSet)o;
        return Arrays.equals(this.sets, that.sets);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.sets);
    }
}

