/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.util;

import com.fren_gor.ultimateAdvancementAPI.util.CompositeCollection;
import com.fren_gor.ultimateAdvancementAPI.util.CompositeSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CompositeMap<K, V>
implements Map<K, V> {
    private final int size;
    private final Map<K, V>[] maps;

    @SafeVarargs
    public static <K, V> Map<K, V> of(Map<K, V> ... maps) {
        return Collections.unmodifiableMap(new CompositeMap<K, V>(maps));
    }

    private CompositeMap(@NotNull Map<K, V>[] maps) {
        this.maps = Objects.requireNonNull(maps);
        int size = 0;
        for (Map<K, V> map : maps) {
            size += map.size();
        }
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        for (Map<K, V> map : this.maps) {
            if (!map.containsKey(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object o) {
        for (Map<K, V> map : this.maps) {
            if (!map.containsValue(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object o) {
        for (Map<K, V> map : this.maps) {
            V v = map.get(o);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set[] sets = new Set[this.maps.length];
        int i = 0;
        for (Map<K, V> map : this.maps) {
            sets[i++] = map.keySet();
        }
        return new CompositeSet(sets);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Collection[] collections = new Collection[this.maps.length];
        int i = 0;
        for (Map<K, V> map : this.maps) {
            collections[i++] = map.values();
        }
        return new CompositeCollection(collections);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set[] sets = new Set[this.maps.length];
        int i = 0;
        for (Map<K, V> map : this.maps) {
            sets[i++] = map.entrySet();
        }
        return new CompositeSet<Map.Entry<K, V>>(sets);
    }

    @Override
    @Nullable
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CompositeMap{maps=" + Arrays.toString(this.maps) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeMap that = (CompositeMap)o;
        return Arrays.equals(this.maps, that.maps);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.maps);
    }
}

