/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.util;

import com.fren_gor.ultimateAdvancementAPI.util.AbstractCompositeCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CompositeCollection<T>
extends AbstractCompositeCollection<T> {
    private final int size;
    private final Collection<T>[] collections;

    @SafeVarargs
    public static <T> Collection<T> of(Collection<T> ... collections) {
        return Collections.unmodifiableCollection(new CompositeCollection<T>(collections));
    }

    CompositeCollection(@NotNull Collection<T>[] collections) {
        this.collections = Objects.requireNonNull(collections);
        int size = 0;
        for (Collection<T> collection : collections) {
            size += collection.size();
        }
        this.size = size;
    }

    @Override
    @NotNull
    protected Collection<T>[] getInner() {
        return this.collections;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return "CompositeCollection{collections=" + Arrays.toString(this.collections) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeCollection that = (CompositeCollection)o;
        return Arrays.equals(this.collections, that.collections);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.collections);
    }
}

