/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.util;

import com.fren_gor.ultimateAdvancementAPI.AdvancementMain;
import com.fren_gor.ultimateAdvancementAPI.AdvancementTab;
import com.fren_gor.ultimateAdvancementAPI.advancement.Advancement;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AbstractAdvancementDisplay;
import com.fren_gor.ultimateAdvancementAPI.advancement.display.AdvancementFrameType;
import com.fren_gor.ultimateAdvancementAPI.database.TeamProgression;
import com.fren_gor.ultimateAdvancementAPI.exceptions.AsyncExecutionException;
import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.MinecraftKeyWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.VanillaAdvancementDisablerWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementFrameTypeWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.packets.PacketPlayOutAdvancementsWrapper;
import com.fren_gor.ultimateAdvancementAPI.util.display.DefaultStyle;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdvancementUtils {
    public static final GameRule<Boolean> SHOW_ADVANCEMENT_MESSAGES_GAMERULE = AdvancementUtils.getShowAdvancementMessagesGamerule();
    private static final String NOTIFICATION_NAMESPACE;
    private static final AtomicInteger NOTIFICATION_KEY_NUMBER;
    private static final MinecraftKeyWrapper NOTIFICATION_ROOT_KEY;
    private static final BaseComponent ADV_DESCRIPTION;
    private static final PreparedAdvancementWrapper PREPARED_ROOT;
    private static final AdvancementWrapper ROOT;
    private static final boolean COMPONENT_BUILDER_HAS_BUILD;
    private static final boolean TEXT_COMPONENT_HAS_FROM_LEGACY;
    static final int EMPTY = 0;
    static final int NEW_LINE = 1;
    static final int NO_NEW_LINE = -1;

    public static void displayToast(@NotNull Player player, @NotNull ItemStack icon, @NotNull String title, @NotNull AdvancementFrameType frame) {
        AdvancementUtils.displayToast(player, icon, AdvancementUtils.fromLegacy(title), frame);
    }

    public static void displayToast(@NotNull Player player, @NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull AdvancementFrameType frame) {
        Preconditions.checkNotNull((Object)player, (Object)"Player is null.");
        Preconditions.checkNotNull((Object)icon, (Object)"Icon is null.");
        Preconditions.checkNotNull((Object)title, (Object)"Title is null.");
        Preconditions.checkNotNull((Object)((Object)frame), (Object)"AdvancementFrameType is null.");
        Preconditions.checkArgument((icon.getType() != Material.AIR ? 1 : 0) != 0, (Object)"ItemStack is air.");
        try {
            MinecraftKeyWrapper notification_key = MinecraftKeyWrapper.craft(NOTIFICATION_NAMESPACE, "_-uaapi-internal-_notification-" + NOTIFICATION_KEY_NUMBER.getAndIncrement());
            AdvancementDisplayWrapper display = AdvancementDisplayWrapper.craft(icon, title, ADV_DESCRIPTION, frame.getNMSWrapper(), 0.2f, 0.0f, true, false, false);
            AdvancementWrapper notification = AdvancementWrapper.craftBaseAdvancement(notification_key, PREPARED_ROOT, display, 1);
            PacketPlayOutAdvancementsWrapper.craftSendPacket(Map.of(ROOT, 0, notification, 1)).sendTo(player);
            PacketPlayOutAdvancementsWrapper.craftRemovePacket(Set.of(NOTIFICATION_ROOT_KEY, notification_key)).sendTo(player);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static void displayToastDuringUpdate(@NotNull Player player, @NotNull Advancement advancement) {
        Preconditions.checkNotNull((Object)player, (Object)"Player is null.");
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkArgument((boolean)advancement.isValid(), (Object)"Advancement isn't valid.");
        AbstractAdvancementDisplay display = advancement.getDisplay();
        TeamProgression pro = advancement.getAdvancementTab().getDatabaseManager().getTeamProgression(player);
        try {
            MinecraftKeyWrapper keyWrapper;
            try {
                keyWrapper = MinecraftKeyWrapper.craft(advancement.getKey().getNamespace(), "_-uaapi-internal-_notification-" + advancement.getKey().getKey());
            }
            catch (IllegalArgumentException e) {
                keyWrapper = MinecraftKeyWrapper.craft(advancement.getKey().getNamespace(), "_-uaapi-internal-_notification-" + NOTIFICATION_KEY_NUMBER.getAndIncrement());
            }
            AdvancementDisplayWrapper displayWrapper = AdvancementDisplayWrapper.craft(display.dispatchGetIcon(player, pro), display.dispatchGetTitle(player, pro), ADV_DESCRIPTION, display.dispatchGetFrame(player, pro).getNMSWrapper(), 0.0f, 0.0f, true, false, false);
            AdvancementWrapper advWrapper = AdvancementWrapper.craftBaseAdvancement(keyWrapper, advancement.getNMSWrapper(), displayWrapper, 1);
            PacketPlayOutAdvancementsWrapper.craftSendPacket(Map.of(advWrapper, 1)).sendTo(player);
            PacketPlayOutAdvancementsWrapper.craftRemovePacket(Set.of(keyWrapper)).sendTo(player);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static void disableVanillaAdvancements() throws Exception {
        VanillaAdvancementDisablerWrapper.disableVanillaAdvancements(true, false);
    }

    public static void disableVanillaRecipeAdvancements() throws Exception {
        VanillaAdvancementDisablerWrapper.disableVanillaAdvancements(false, true);
    }

    @Contract(value="_ -> param1")
    public static int validateProgressionValue(int progression) {
        if (progression < 0) {
            throw new IllegalArgumentException("Progression value cannot be < 0");
        }
        return progression;
    }

    public static void validateProgressionValueStrict(int progression, int maxProgression) {
        AdvancementUtils.validateProgressionValue(progression);
        if (progression > maxProgression) {
            throw new IllegalArgumentException("Progression value cannot be greater than the maximum progression (" + maxProgression + ")");
        }
    }

    @Contract(value="null -> fail; !null -> param1")
    public static TeamProgression validateTeamProgression(TeamProgression pro) {
        Preconditions.checkNotNull((Object)pro, (Object)"TeamProgression is null.");
        Preconditions.checkArgument((boolean)pro.isValid(), (Object)"Invalid TeamProgression.");
        return pro;
    }

    public static void checkSync() {
        if (!Bukkit.isPrimaryThread()) {
            throw new AsyncExecutionException("Illegal async method call. This method can be called only from the main thread.");
        }
    }

    @NotNull
    public static BukkitTask runSync(@NotNull AdvancementMain main, @NotNull Runnable runnable) {
        return AdvancementUtils.runSync(main.getOwningPlugin(), runnable);
    }

    @NotNull
    public static BukkitTask runSync(@NotNull Plugin plugin, @NotNull Runnable runnable) {
        return AdvancementUtils.runSync(plugin, 0L, runnable);
    }

    @NotNull
    public static BukkitTask runSync(@NotNull AdvancementMain main, long delay, @NotNull Runnable runnable) {
        return AdvancementUtils.runSync(main.getOwningPlugin(), delay, runnable);
    }

    @NotNull
    public static BukkitTask runSync(@NotNull Plugin plugin, long delay, @NotNull Runnable runnable) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin is null.");
        Preconditions.checkNotNull((Object)runnable, (Object)"Runnable is null.");
        return Bukkit.getScheduler().runTaskLater(plugin, runnable, delay);
    }

    @NotNull
    public static <T> CompletableFuture<T> runSync(@NotNull CompletableFuture<T> completableFuture, @NotNull Plugin plugin, @NotNull BiConsumer<T, Throwable> consumer) {
        return AdvancementUtils.runSync(completableFuture, 0L, plugin, consumer);
    }

    @NotNull
    public static <T> CompletableFuture<T> runSync(@NotNull CompletableFuture<T> completableFuture, long delay, @NotNull Plugin plugin, @NotNull BiConsumer<T, Throwable> consumer) {
        Preconditions.checkNotNull(completableFuture, (Object)"CompletableFuture is null.");
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin is null.");
        Preconditions.checkNotNull(consumer, (Object)"BiConsumer is null.");
        return completableFuture.whenComplete((result, err) -> {
            if (delay == 0L && Bukkit.isPrimaryThread()) {
                try {
                    consumer.accept((Object)result, (Throwable)err);
                }
                catch (Exception e) {
                    plugin.getLogger().log(Level.WARNING, "An exception occurred while executing runSync's consumer of " + plugin.getDescription().getFullName(), e);
                }
            } else {
                Bukkit.getScheduler().runTaskLater(plugin, () -> consumer.accept((Object)result, (Throwable)err), delay);
            }
        });
    }

    @NotNull
    public static UUID uuidFromPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player is null.");
        return player.getUniqueId();
    }

    @NotNull
    public static UUID uuidFromPlayer(@NotNull OfflinePlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)"OfflinePlayer is null.");
        return player.getUniqueId();
    }

    @NotNull
    public static TeamProgression progressionFromPlayer(@NotNull Player player, @NotNull Advancement advancement) {
        return AdvancementUtils.progressionFromPlayer(player, advancement.getAdvancementTab());
    }

    @NotNull
    public static TeamProgression progressionFromUUID(@NotNull UUID uuid, @NotNull Advancement advancement) {
        return AdvancementUtils.progressionFromUUID(uuid, advancement.getAdvancementTab());
    }

    @NotNull
    public static TeamProgression progressionFromPlayer(@NotNull Player player, @NotNull AdvancementTab tab) {
        return AdvancementUtils.progressionFromUUID(AdvancementUtils.uuidFromPlayer(player), tab);
    }

    @NotNull
    public static TeamProgression progressionFromUUID(@NotNull UUID uuid, @NotNull AdvancementTab tab) {
        Preconditions.checkNotNull((Object)uuid, (Object)"UUID is null.");
        return tab.getDatabaseManager().getTeamProgression(uuid);
    }

    @NotNull
    public static BaseComponent getAnnouncementMessage(@NotNull Advancement advancement, @NotNull Player advancementCompleter) {
        return AdvancementUtils.getAnnouncementMessage(advancement, advancementCompleter, false);
    }

    @NotNull
    public static BaseComponent getAnnouncementMessage(@NotNull Advancement advancement, @NotNull Player advancementCompleter, boolean fancy) {
        Preconditions.checkNotNull((Object)advancement, (Object)"Advancement is null.");
        Preconditions.checkNotNull((Object)advancementCompleter, (Object)"Player is null.");
        AbstractAdvancementDisplay display = advancement.getDisplay();
        TeamProgression progression = advancement.getAdvancementTab().getDatabaseManager().getTeamProgression(advancementCompleter);
        AdvancementFrameType frame = display.dispatchGetFrame(advancementCompleter, progression);
        BaseComponent title = display.dispatchGetTitle(advancementCompleter, progression);
        List<BaseComponent> description = display.dispatchGetDescription(advancementCompleter, progression);
        DefaultStyle defaultAMTitleStyle = display.dispatchGetAnnouncementMessageDefaultTitleStyle(advancementCompleter, progression);
        DefaultStyle defaultAMDescriptionStyle = display.dispatchGetAnnouncementMessageDefaultDescriptionStyle(advancementCompleter, progression);
        String chatText = frame.getChatText();
        DefaultStyle frameStyle = frame.getStyle();
        Preconditions.checkNotNull((Object)((Object)frame), (Object)"Display returned a null frame.");
        Preconditions.checkNotNull((Object)title, (Object)"Display returned a null title.");
        Preconditions.checkNotNull(description, (Object)"Display returned a null description.");
        Preconditions.checkNotNull((Object)chatText, (Object)"Frame returned a null chatText.");
        Preconditions.checkNotNull((Object)frameStyle, (Object)"Frame returned a null style.");
        DefaultStyle titleStyle = defaultAMTitleStyle.mergeWith(frameStyle);
        DefaultStyle parenthesesStyle = fancy ? titleStyle : frameStyle;
        title = AdvancementUtils.applyDefaultStyle(title, titleStyle);
        ComponentBuilder hoverText = new ComponentBuilder().append(title, ComponentBuilder.FormatRetention.NONE);
        if (!description.isEmpty()) {
            if (fancy && AdvancementUtils.startsWithNewLine(description.get(0)) == -1) {
                hoverText.append("\n\n", ComponentBuilder.FormatRetention.NONE);
            } else {
                hoverText.append("\n", ComponentBuilder.FormatRetention.NONE);
            }
            DefaultStyle descriptionStyle = defaultAMDescriptionStyle.mergeWith(frameStyle);
            hoverText.append(AdvancementUtils.joinBaseComponents((BaseComponent)new TextComponent("\n"), descriptionStyle, description), ComponentBuilder.FormatRetention.NONE);
        }
        ComponentBuilder hoverBuilder = new ComponentBuilder("[");
        parenthesesStyle.applyTo(hoverBuilder);
        hoverBuilder.append(title, ComponentBuilder.FormatRetention.NONE).append("]", ComponentBuilder.FormatRetention.NONE);
        parenthesesStyle.applyTo(hoverBuilder);
        TextComponent withHover = new TextComponent(hoverBuilder.create());
        withHover.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverText.create()));
        ComponentBuilder cb = new ComponentBuilder(advancementCompleter.getName() + " " + frame.getChatText() + " ").color(ChatColor.WHITE).append((BaseComponent)withHover, ComponentBuilder.FormatRetention.NONE);
        return AdvancementUtils.build(cb);
    }

    static int startsWithNewLine(BaseComponent component) {
        int r;
        if (component == null) {
            return 0;
        }
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            r = AdvancementUtils.startsWithNewLine(textComponent.getText());
            if (r != 0) {
                return r;
            }
        } else {
            return -1;
        }
        List extra = component.getExtra();
        if (extra == null) {
            return 0;
        }
        for (BaseComponent e : extra) {
            if (e == null || (r = AdvancementUtils.startsWithNewLine(e)) == 0) continue;
            return r;
        }
        return 0;
    }

    static int startsWithNewLine(String text) {
        if (text == null) {
            return 0;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                return 1;
            }
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return -1;
        }
        return 0;
    }

    @NotNull
    public static BaseComponent build(@NotNull ComponentBuilder builder) {
        if (COMPONENT_BUILDER_HAS_BUILD) {
            return builder.build();
        }
        BaseComponent[] created = builder.create();
        return created.length == 1 ? created[0] : new TextComponent(created);
    }

    @NotNull
    public static BaseComponent fromLegacy(@NotNull String legacy) {
        Preconditions.checkNotNull((Object)legacy, (Object)"Legacy string is null.");
        if (TEXT_COMPONENT_HAS_FROM_LEGACY) {
            return TextComponent.fromLegacy((String)legacy);
        }
        return new TextComponent(TextComponent.fromLegacyText((String)legacy));
    }

    @NotNull
    public static BaseComponent joinBaseComponents(@NotNull BaseComponent delimiter, @Nullable DefaultStyle defaultStyle, @NotNull Iterable<? extends BaseComponent> toJoin) {
        Preconditions.checkNotNull((Object)delimiter, (Object)"Delimiter is null.");
        Preconditions.checkNotNull(toJoin, (Object)"BaseComponents to join are null.");
        Iterator<? extends BaseComponent> iter = toJoin.iterator();
        if (!iter.hasNext()) {
            return new TextComponent();
        }
        BaseComponent first = Objects.requireNonNull(iter.next(), "A BaseComponent to join is null.");
        ComponentBuilder joiner = new ComponentBuilder(first);
        while (iter.hasNext()) {
            BaseComponent component = Objects.requireNonNull(iter.next(), "A BaseComponent to join is null.");
            joiner.append(delimiter, ComponentBuilder.FormatRetention.NONE).append(component, ComponentBuilder.FormatRetention.NONE);
        }
        return AdvancementUtils.applyDefaultStyle(AdvancementUtils.build(joiner), defaultStyle);
    }

    @NotNull
    public static BaseComponent applyDefaultStyle(@NotNull BaseComponent text, @Nullable DefaultStyle defaultStyle) {
        if (defaultStyle == null || defaultStyle == DefaultStyle.MINECRAFT_DEFAULTS) {
            return text;
        }
        text = text.duplicate();
        defaultStyle.applyTo(text);
        return text;
    }

    private static GameRule<Boolean> getShowAdvancementMessagesGamerule() {
        try {
            return (GameRule)GameRule.class.getDeclaredField("SHOW_ADVANCEMENT_MESSAGES").get(null);
        }
        catch (NoSuchFieldException e) {
            return GameRule.ANNOUNCE_ADVANCEMENTS;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private AdvancementUtils() {
        throw new UnsupportedOperationException("Utility class.");
    }

    static {
        NOTIFICATION_KEY_NUMBER = new AtomicInteger(0);
        NOTIFICATION_NAMESPACE = "_-uaapi-internal-_notification-" + String.valueOf(UUID.randomUUID());
        ADV_DESCRIPTION = new TextComponent("A toast notification.\n\nClose and reopen advancements to hide.");
        ADV_DESCRIPTION.setColor(ChatColor.GRAY);
        try {
            NOTIFICATION_ROOT_KEY = MinecraftKeyWrapper.craft(NOTIFICATION_NAMESPACE, "root");
            AdvancementDisplayWrapper display = AdvancementDisplayWrapper.craft(new ItemStack(Material.BARRIER), (BaseComponent)new TextComponent("Notification"), (BaseComponent)new TextComponent(""), AdvancementFrameTypeWrapper.TASK, 0.0f, 0.0f, false, false, true, "textures/block/stone.png");
            PREPARED_ROOT = PreparedAdvancementWrapper.craft(NOTIFICATION_ROOT_KEY, 1);
            ROOT = PREPARED_ROOT.toAdvancementWrapper(display);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        COMPONENT_BUILDER_HAS_BUILD = ReflectionUtil.hasMethod(ComponentBuilder.class, "build", new Class[0]);
        TEXT_COMPONENT_HAS_FROM_LEGACY = ReflectionUtil.hasMethod(TextComponent.class, "fromLegacy", new Class[0]);
    }
}

