/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
abstract class AbstractCompositeCollection<T>
implements Collection<T> {
    AbstractCompositeCollection() {
    }

    @NotNull
    protected abstract Collection<T>[] getInner();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> c : this.getInner()) {
            if (!c.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        Object[] ret = new Object[this.size()];
        int i = 0;
        for (Collection<T> set : this.getInner()) {
            Object[] obj = set.toArray();
            System.arraycopy(obj, 0, ret, i, obj.length);
            i += obj.length;
        }
        return ret;
    }

    @Override
    @NotNull
    public <E> @NotNull E @NotNull [] toArray(E[] a) {
        Class<?> clazz = a.getClass().getComponentType();
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(clazz, this.size());
        }
        int i = 0;
        for (Collection<Object> collection : this.getInner()) {
            Object[] obj = (Object[])Array.newInstance(clazz, collection.size());
            obj = collection.toArray(obj);
            System.arraycopy(obj, 0, a, i, obj.length);
            i += obj.length;
        }
        if (i < a.length) {
            a[i] = null;
        }
        return a;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new CompositeIterator<T>(this.getInner());
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private static final class CompositeIterator<T>
    implements Iterator<T> {
        private final Collection<T>[] collections;
        private Iterator<T> currentIter;
        private int nextColl;

        public CompositeIterator(@NotNull Collection<T>[] collections) {
            this.collections = collections;
            if (collections.length > 0) {
                this.currentIter = collections[0].iterator();
                this.nextColl = 1;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentIter.hasNext()) {
                return true;
            }
            if (this.nextColl < this.collections.length) {
                this.currentIter = this.collections[this.nextColl++].iterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            try {
                return this.currentIter.next();
            }
            catch (NoSuchElementException ignored) {
                if (this.nextColl < this.collections.length) {
                    this.currentIter = this.collections[this.nextColl++].iterator();
                    return this.next();
                }
                throw new NoSuchElementException();
            }
        }
    }
}

