/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement;

import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.MinecraftKeyWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementWrapper;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class PreparedAdvancementWrapper {
    private static final Constructor<? extends PreparedAdvancementWrapper> constructor;

    @NotNull
    public static PreparedAdvancementWrapper craft(@NotNull MinecraftKeyWrapper key, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) throws ReflectiveOperationException {
        return PreparedAdvancementWrapper.craft(key, null, maxProgression);
    }

    @NotNull
    public static PreparedAdvancementWrapper craft(@NotNull MinecraftKeyWrapper key, @Nullable PreparedAdvancementWrapper parent, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) throws ReflectiveOperationException {
        Preconditions.checkNotNull((Object)key, (Object)"MinecraftKeyWrapper is null.");
        Preconditions.checkArgument((maxProgression > 0 ? 1 : 0) != 0, (Object)"Maximum progression cannot be <= 0");
        return constructor.newInstance(key, parent, maxProgression);
    }

    @NotNull
    public abstract MinecraftKeyWrapper getKey();

    @Nullable
    public abstract PreparedAdvancementWrapper getParent();

    public abstract @Range(from=1L, to=0x7FFFFFFFL) int getMaxProgression();

    @NotNull
    @Contract(value="_ -> new")
    public abstract PreparedAdvancementWrapper withParent(@Nullable PreparedAdvancementWrapper var1);

    @NotNull
    public abstract AdvancementWrapper toAdvancementWrapper(@NotNull AdvancementDisplayWrapper var1);

    public String toString() {
        return "PreparedAdvancementWrapper{key=" + String.valueOf(this.getKey()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedAdvancementWrapper that = (PreparedAdvancementWrapper)o;
        return this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    static {
        Class<PreparedAdvancementWrapper> clazz = ReflectionUtil.getWrapperClass(PreparedAdvancementWrapper.class);
        Preconditions.checkNotNull(clazz, (Object)"PreparedAdvancementWrapper implementation not found.");
        try {
            constructor = clazz.getDeclaredConstructor(MinecraftKeyWrapper.class, PreparedAdvancementWrapper.class, Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Couldn't initialize PreparedAdvancementWrapper.", e);
        }
    }
}

