/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement;

import com.fren_gor.ultimateAdvancementAPI.nms.util.JsonString;
import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementFrameTypeWrapper;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import java.lang.reflect.Constructor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class PreparedAdvancementDisplayWrapper {
    private static final Constructor<? extends PreparedAdvancementDisplayWrapper> constructorJSONs;
    private static final Constructor<? extends PreparedAdvancementDisplayWrapper> constructorBaseComponents;

    @NotNull
    public static PreparedAdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull BaseComponent description, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y) throws ReflectiveOperationException {
        return PreparedAdvancementDisplayWrapper.craft(icon, title, description, frameType, x, y, false, false, false);
    }

    @NotNull
    public static PreparedAdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull BaseComponent description, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, boolean showToast, boolean announceChat, boolean hidden) throws ReflectiveOperationException {
        Preconditions.checkNotNull((Object)icon, (Object)"Icon is null.");
        Preconditions.checkNotNull((Object)title, (Object)"Title is null.");
        Preconditions.checkNotNull((Object)description, (Object)"Description is null.");
        Preconditions.checkNotNull((Object)frameType, (Object)"Frame type is null.");
        Preconditions.checkArgument((boolean)Float.isFinite(x), (Object)"x is not finite.");
        Preconditions.checkArgument((boolean)Float.isFinite(y), (Object)"y is not finite.");
        return constructorBaseComponents.newInstance(icon, title, description, frameType, Float.valueOf(x), Float.valueOf(y), showToast, announceChat, hidden);
    }

    @NotNull
    public static PreparedAdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull JsonString jsonTitle, @NotNull JsonString jsonDescription, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y) throws ReflectiveOperationException, JsonParseException {
        return PreparedAdvancementDisplayWrapper.craft(icon, jsonTitle, jsonDescription, frameType, x, y, false, false, false);
    }

    @NotNull
    public static PreparedAdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull JsonString jsonTitle, @NotNull JsonString jsonDescription, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, boolean showToast, boolean announceChat, boolean hidden) throws ReflectiveOperationException, JsonParseException {
        Preconditions.checkNotNull((Object)icon, (Object)"Icon is null.");
        Preconditions.checkNotNull((Object)jsonTitle, (Object)"Title is null.");
        Preconditions.checkNotNull((Object)jsonDescription, (Object)"Description is null.");
        Preconditions.checkNotNull((Object)frameType, (Object)"Frame type is null.");
        Preconditions.checkArgument((boolean)Float.isFinite(x), (Object)"x is not finite.");
        Preconditions.checkArgument((boolean)Float.isFinite(y), (Object)"y is not finite.");
        return constructorJSONs.newInstance(icon, jsonTitle, jsonDescription, frameType, Float.valueOf(x), Float.valueOf(y), showToast, announceChat, hidden);
    }

    @NotNull
    public abstract ItemStack getIcon();

    @NotNull
    public abstract BaseComponent getTitle();

    @NotNull
    public abstract BaseComponent getDescription();

    @NotNull
    public abstract AdvancementFrameTypeWrapper getAdvancementFrameType();

    public abstract float getX();

    public abstract float getY();

    public abstract boolean doesShowToast();

    public abstract boolean doesAnnounceToChat();

    public abstract boolean isHidden();

    @NotNull
    public abstract AdvancementDisplayWrapper toBaseAdvancementDisplay();

    @NotNull
    public abstract AdvancementDisplayWrapper toRootAdvancementDisplay(@NotNull String var1);

    static {
        Class<PreparedAdvancementDisplayWrapper> clazz = ReflectionUtil.getWrapperClass(PreparedAdvancementDisplayWrapper.class);
        Preconditions.checkNotNull(clazz, (Object)"PreparedAdvancementDisplayWrapper implementation not found.");
        try {
            constructorJSONs = clazz.getDeclaredConstructor(ItemStack.class, JsonString.class, JsonString.class, AdvancementFrameTypeWrapper.class, Float.TYPE, Float.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            constructorBaseComponents = clazz.getDeclaredConstructor(ItemStack.class, BaseComponent.class, BaseComponent.class, AdvancementFrameTypeWrapper.class, Float.TYPE, Float.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Couldn't initialize PreparedAdvancementDisplayWrapper.", e);
        }
    }
}

