/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement;

import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.AbstractWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.MinecraftKeyWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementDisplayWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.PreparedAdvancementWrapper;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class AdvancementWrapper
extends AbstractWrapper {
    private static final Constructor<? extends AdvancementWrapper> rootAdvancementWrapperConstructor;
    private static final Constructor<? extends AdvancementWrapper> baseAdvancementWrapperConstructor;

    @NotNull
    public static AdvancementWrapper craftRootAdvancement(@NotNull MinecraftKeyWrapper key, @NotNull AdvancementDisplayWrapper display, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) throws ReflectiveOperationException {
        Preconditions.checkNotNull((Object)key, (Object)"MinecraftKeyWrapper is null.");
        Preconditions.checkNotNull((Object)display, (Object)"AdvancementDisplayWrapper is null.");
        Preconditions.checkArgument((maxProgression > 0 ? 1 : 0) != 0, (Object)"Maximum progression cannot be <= 0");
        return rootAdvancementWrapperConstructor.newInstance(key, display, maxProgression);
    }

    @NotNull
    public static AdvancementWrapper craftBaseAdvancement(@NotNull MinecraftKeyWrapper key, @NotNull PreparedAdvancementWrapper parent, @NotNull AdvancementDisplayWrapper display, @Range(from=1L, to=0x7FFFFFFFL) int maxProgression) throws ReflectiveOperationException {
        Preconditions.checkNotNull((Object)key, (Object)"MinecraftKeyWrapper is null.");
        Preconditions.checkNotNull((Object)parent, (Object)"PreparedAdvancementWrapper is null.");
        Preconditions.checkNotNull((Object)display, (Object)"AdvancementDisplayWrapper is null.");
        Preconditions.checkArgument((maxProgression > 0 ? 1 : 0) != 0, (Object)"Maximum progression cannot be <= 0");
        return baseAdvancementWrapperConstructor.newInstance(key, parent, display, maxProgression);
    }

    @NotNull
    public abstract MinecraftKeyWrapper getKey();

    @Nullable
    public abstract PreparedAdvancementWrapper getParent();

    @NotNull
    public abstract AdvancementDisplayWrapper getDisplay();

    public abstract @Range(from=1L, to=0x7FFFFFFFL) int getMaxProgression();

    @Override
    public String toString() {
        return "AdvancementWrapper{key=" + String.valueOf(this.getKey()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancementWrapper that = (AdvancementWrapper)o;
        return this.getKey().equals(that.getKey());
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode();
    }

    static {
        Class<AdvancementWrapper> clazz = ReflectionUtil.getWrapperClass(AdvancementWrapper.class);
        Preconditions.checkNotNull(clazz, (Object)"AdvancementWrapper implementation not found.");
        try {
            rootAdvancementWrapperConstructor = clazz.getDeclaredConstructor(MinecraftKeyWrapper.class, AdvancementDisplayWrapper.class, Integer.TYPE);
            baseAdvancementWrapperConstructor = clazz.getDeclaredConstructor(MinecraftKeyWrapper.class, PreparedAdvancementWrapper.class, AdvancementDisplayWrapper.class, Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Couldn't initialize AdvancementWrapper.", e);
        }
    }
}

