/*
 * Decompiled with CFR 0.152.
 */
package com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement;

import com.fren_gor.ultimateAdvancementAPI.nms.util.JsonString;
import com.fren_gor.ultimateAdvancementAPI.nms.util.ReflectionUtil;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.AbstractWrapper;
import com.fren_gor.ultimateAdvancementAPI.nms.wrappers.advancement.AdvancementFrameTypeWrapper;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import java.lang.reflect.Constructor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancementDisplayWrapper
extends AbstractWrapper {
    private static final Constructor<? extends AdvancementDisplayWrapper> constructorJSONs;
    private static final Constructor<? extends AdvancementDisplayWrapper> constructorBaseComponents;

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull BaseComponent description, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y) throws ReflectiveOperationException {
        return AdvancementDisplayWrapper.craft(icon, title, description, frameType, x, y, null);
    }

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull BaseComponent description, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, @Nullable String backgroundTexture) throws ReflectiveOperationException {
        return AdvancementDisplayWrapper.craft(icon, title, description, frameType, x, y, false, false, false, backgroundTexture);
    }

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull BaseComponent description, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, boolean showToast, boolean announceChat, boolean hidden) throws ReflectiveOperationException {
        return AdvancementDisplayWrapper.craft(icon, title, description, frameType, x, y, showToast, announceChat, hidden, null);
    }

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull BaseComponent title, @NotNull BaseComponent description, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, boolean showToast, boolean announceChat, boolean hidden, @Nullable String backgroundTexture) throws ReflectiveOperationException {
        Preconditions.checkNotNull((Object)icon, (Object)"Icon is null.");
        Preconditions.checkNotNull((Object)title, (Object)"Title is null.");
        Preconditions.checkNotNull((Object)description, (Object)"Description is null.");
        Preconditions.checkNotNull((Object)frameType, (Object)"Frame type is null.");
        Preconditions.checkArgument((boolean)Float.isFinite(x), (Object)"x is not finite.");
        Preconditions.checkArgument((boolean)Float.isFinite(y), (Object)"y is not finite.");
        return constructorBaseComponents.newInstance(icon, title, description, frameType, Float.valueOf(x), Float.valueOf(y), showToast, announceChat, hidden, backgroundTexture);
    }

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull JsonString jsonTitle, @NotNull JsonString jsonDescription, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y) throws ReflectiveOperationException, JsonParseException {
        return AdvancementDisplayWrapper.craft(icon, jsonTitle, jsonDescription, frameType, x, y, null);
    }

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull JsonString jsonTitle, @NotNull JsonString jsonDescription, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, @Nullable String backgroundTexture) throws ReflectiveOperationException, JsonParseException {
        return AdvancementDisplayWrapper.craft(icon, jsonTitle, jsonDescription, frameType, x, y, false, false, false, backgroundTexture);
    }

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull JsonString jsonTitle, @NotNull JsonString jsonDescription, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, boolean showToast, boolean announceChat, boolean hidden) throws ReflectiveOperationException, JsonParseException {
        return AdvancementDisplayWrapper.craft(icon, jsonTitle, jsonDescription, frameType, x, y, showToast, announceChat, hidden, null);
    }

    @NotNull
    public static AdvancementDisplayWrapper craft(@NotNull ItemStack icon, @NotNull JsonString jsonTitle, @NotNull JsonString jsonDescription, @NotNull AdvancementFrameTypeWrapper frameType, float x, float y, boolean showToast, boolean announceChat, boolean hidden, @Nullable String backgroundTexture) throws ReflectiveOperationException, JsonParseException {
        Preconditions.checkNotNull((Object)icon, (Object)"Icon is null.");
        Preconditions.checkNotNull((Object)jsonTitle, (Object)"Title is null.");
        Preconditions.checkNotNull((Object)jsonDescription, (Object)"Description is null.");
        Preconditions.checkNotNull((Object)frameType, (Object)"Frame type is null.");
        Preconditions.checkArgument((boolean)Float.isFinite(x), (Object)"x is not finite.");
        Preconditions.checkArgument((boolean)Float.isFinite(y), (Object)"y is not finite.");
        return constructorJSONs.newInstance(icon, jsonTitle, jsonDescription, frameType, Float.valueOf(x), Float.valueOf(y), showToast, announceChat, hidden, backgroundTexture);
    }

    @NotNull
    public abstract ItemStack getIcon();

    @NotNull
    public abstract BaseComponent getTitle();

    @NotNull
    public abstract BaseComponent getDescription();

    @NotNull
    public abstract AdvancementFrameTypeWrapper getAdvancementFrameType();

    public abstract float getX();

    public abstract float getY();

    public abstract boolean doesShowToast();

    public abstract boolean doesAnnounceToChat();

    public abstract boolean isHidden();

    @Nullable
    public abstract String getBackgroundTexture();

    static {
        Class<AdvancementDisplayWrapper> clazz = ReflectionUtil.getWrapperClass(AdvancementDisplayWrapper.class);
        Preconditions.checkNotNull(clazz, (Object)"AdvancementDisplayWrapper implementation not found.");
        try {
            constructorJSONs = clazz.getDeclaredConstructor(ItemStack.class, JsonString.class, JsonString.class, AdvancementFrameTypeWrapper.class, Float.TYPE, Float.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class);
            constructorBaseComponents = clazz.getDeclaredConstructor(ItemStack.class, BaseComponent.class, BaseComponent.class, AdvancementFrameTypeWrapper.class, Float.TYPE, Float.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Couldn't initialize AdvancementDisplayWrapper.", e);
        }
    }
}

